/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.IResourceKey;
import yslelf.cloudpick.render.engine.Resource;

public abstract class Buffer
extends Resource {
    public static final int kRead_MapMode = 0;
    public static final int kWriteDiscard_MapMode = 1;
    protected final long mSize;
    protected final int mUsage;
    private boolean mMapped;
    private long mMappedBuffer;
    private long mMapOffset;
    private long mMapSize;

    protected Buffer(Context context, long size, int usage) {
        super(context, true, false, size);
        assert (size > 0L);
        this.mSize = size;
        this.mUsage = usage;
    }

    public final long getSize() {
        return this.mSize;
    }

    public final int getUsage() {
        return this.mUsage;
    }

    private static int getMapMode(int usage) {
        return (usage & 0x10) != 0 ? 0 : 1;
    }

    public final long map() {
        return this.map(0L, this.mSize);
    }

    public final long map(long offset, long size) {
        if ((this.mUsage & 0x20000) == 0) {
            return 0L;
        }
        if (this.mMapped) {
            assert (offset == this.mMapOffset && size == this.mMapSize);
            return this.mMappedBuffer;
        }
        assert (offset >= 0L && offset + size <= this.mSize);
        this.mMapped = true;
        this.mMapOffset = offset;
        this.mMapSize = size;
        this.mMappedBuffer = this.onMap(Buffer.getMapMode(this.mUsage), offset, size);
        return this.mMappedBuffer;
    }

    public final void unmap() {
        this.unmap(this.mMapSize);
    }

    public final void unmap(long size) {
        if (this.isDestroyed()) {
            return;
        }
        if (this.mMapped) {
            assert (size <= this.mMapSize);
            this.onUnmap(Buffer.getMapMode(this.mUsage), this.mMapOffset, size);
            this.mMapped = false;
            this.mMappedBuffer = 0L;
        }
    }

    protected abstract long onMap(int var1, long var2, long var4);

    protected abstract void onUnmap(int var1, long var2, long var4);

    public final boolean isMapped() {
        return this.mMapped;
    }

    public final long getMappedBuffer() {
        return this.mMappedBuffer;
    }

    public boolean updateData(int offset, int size, long data) {
        assert (data != 0L);
        if (this.isDestroyed() || this.isMapped()) {
            return false;
        }
        assert (size > 0 && (long)(offset + size) <= this.getSize());
        return false;
    }

    public static class ResourceKey
    implements IResourceKey {
        private int mUsage;
        private long mSize;

        public ResourceKey() {
        }

        public ResourceKey(int usage, long size) {
            this.mUsage = usage;
            this.mSize = size;
        }

        public ResourceKey set(int usage, long size) {
            this.mUsage = usage;
            this.mSize = size;
            return this;
        }

        @Override
        public IResourceKey copy() {
            return new ResourceKey(this.mUsage, this.mSize);
        }

        @Override
        public int hashCode() {
            int result = this.mUsage;
            result = 31 * result + (int)(this.mSize ^ this.mSize >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ResourceKey) {
                ResourceKey key = (ResourceKey)o;
                return this.mUsage == key.mUsage && this.mSize == key.mSize;
            }
            return false;
        }
    }
}

