/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.BufferImageCopyData;
import yslelf.cloudpick.render.engine.FlushInfo;
import yslelf.cloudpick.render.engine.FramebufferDesc;
import yslelf.cloudpick.render.engine.GraphicsPipeline;
import yslelf.cloudpick.render.engine.Image;
import yslelf.cloudpick.render.engine.ManagedResource;
import yslelf.cloudpick.render.engine.QueueManager;
import yslelf.cloudpick.render.engine.RenderPassDesc;
import yslelf.cloudpick.render.engine.Resource;
import yslelf.cloudpick.render.engine.Sampler;

public abstract class CommandBuffer {
    private final ObjectArrayList<@SharedPtr Resource> mTrackingUsageResources = new ObjectArrayList();
    private final ObjectArrayList<@SharedPtr ManagedResource> mTrackingManagedResources = new ObjectArrayList();
    private final ObjectArrayList<@SharedPtr Resource> mTrackingCommandBufferResources = new ObjectArrayList();
    private final ArrayDeque<FlushInfo.FinishedCallback> mFinishedCallbacks = new ArrayDeque();

    public abstract boolean beginRenderPass(RenderPassDesc var1, FramebufferDesc var2, Rect2ic var3, float[] var4, float var5, int var6);

    public abstract void setViewport(int var1, int var2, int var3, int var4);

    public abstract void setScissor(int var1, int var2, int var3, int var4);

    public abstract boolean bindGraphicsPipeline(@RawPtr GraphicsPipeline var1);

    public abstract void bindIndexBuffer(int var1, @RawPtr Buffer var2, long var3);

    public abstract void bindVertexBuffer(int var1, @RawPtr Buffer var2, long var3);

    public abstract void bindUniformBuffer(int var1, @RawPtr Buffer var2, long var3, long var5);

    public abstract void bindTextureSampler(int var1, @RawPtr Image var2, @RawPtr Sampler var3, short var4);

    public abstract void draw(int var1, int var2);

    public abstract void drawIndexed(int var1, int var2, int var3);

    public abstract void drawInstanced(int var1, int var2, int var3, int var4);

    public abstract void drawIndexedInstanced(int var1, int var2, int var3, int var4, int var5);

    public abstract void endRenderPass();

    public final boolean copyBuffer(@RawPtr Buffer srcBuffer, @RawPtr Buffer dstBuffer, long srcOffset, long dstOffset, long size) {
        assert (srcBuffer != null && dstBuffer != null);
        return this.onCopyBuffer(srcBuffer, dstBuffer, srcOffset, dstOffset, size);
    }

    protected abstract boolean onCopyBuffer(@RawPtr Buffer var1, @RawPtr Buffer var2, long var3, long var5, long var7);

    public final boolean copyBufferToImage(@RawPtr Buffer srcBuffer, @RawPtr Image dstImage, int srcColorType, int dstColorType, BufferImageCopyData[] copyData) {
        assert (srcBuffer != null && dstImage != null && copyData.length > 0);
        if (!dstImage.isSampledImage() && !dstImage.isStorageImage()) {
            return false;
        }
        return this.onCopyBufferToImage(srcBuffer, dstImage, srcColorType, dstColorType, copyData);
    }

    protected abstract boolean onCopyBufferToImage(@RawPtr Buffer var1, @RawPtr Image var2, int var3, int var4, BufferImageCopyData[] var5);

    public final boolean copyImage(@RawPtr Image srcImage, int srcL, int srcT, int srcR, int srcB, @RawPtr Image dstImage, int dstX, int dstY, int mipLevel) {
        assert (srcImage != null && dstImage != null);
        return this.onCopyImage(srcImage, srcL, srcT, srcR, srcB, dstImage, dstX, dstY, mipLevel);
    }

    protected abstract boolean onCopyImage(@RawPtr Image var1, int var2, int var3, int var4, int var5, @RawPtr Image var6, int var7, int var8, int var9);

    public final void trackResource(@SharedPtr Resource resource) {
        if (resource == null) {
            return;
        }
        this.mTrackingUsageResources.add((Object)resource);
    }

    public final void trackResource(@SharedPtr ManagedResource resource) {
        if (resource == null) {
            return;
        }
        this.mTrackingManagedResources.add((Object)resource);
    }

    public final void trackCommandBufferResource(@SharedPtr Resource resource) {
        if (resource == null) {
            return;
        }
        resource.refCommandBuffer();
        this.mTrackingCommandBufferResources.add((Object)resource);
        resource.unref();
    }

    protected abstract void begin();

    protected abstract boolean submit(QueueManager var1);

    protected abstract boolean checkFinishedAndReset();

    protected abstract void waitUntilFinished();

    protected final void callFinishedCallbacks(boolean success) {
        for (FlushInfo.FinishedCallback callback : this.mFinishedCallbacks) {
            callback.onFinished(success);
        }
        this.mFinishedCallbacks.clear();
    }

    protected final void releaseResources() {
        this.mTrackingUsageResources.forEach(Resource::unref);
        this.mTrackingUsageResources.clear();
        this.mTrackingManagedResources.forEach(RefCnt::unref);
        this.mTrackingManagedResources.clear();
        this.mTrackingCommandBufferResources.forEach(Resource::unrefCommandBuffer);
        this.mTrackingCommandBufferResources.clear();
    }
}

