/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.BaseContextOptions;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.ContextOptions;
import yslelf.cloudpick.render.engine.Device;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.engine.ResourceProvider;
import yslelf.cloudpick.render.engine.SharedResourceCache;
import yslelf.cloudpick.render.granite.RendererProvider;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Context
extends RefCnt {
    protected final Device mDevice;
    protected final Thread mOwnerThread;
    protected ResourceProvider mResourceProvider;

    protected Context(Device device) {
        this.mDevice = device;
        this.mOwnerThread = Thread.currentThread();
    }

    public final int getBackend() {
        return this.mDevice.getBackend();
    }

    @Nullable
    public final BackendFormat getDefaultBackendFormat(int colorType, boolean renderable) {
        return this.mDevice.getDefaultBackendFormat(colorType, renderable);
    }

    @Nullable
    public final BackendFormat getCompressedBackendFormat(int compressionType) {
        return this.mDevice.getCompressedBackendFormat(compressionType);
    }

    public final int getMaxSurfaceSampleCount(int colorType) {
        return this.mDevice.getMaxSurfaceSampleCount(colorType);
    }

    public final boolean isImmediate() {
        return this instanceof ImmediateContext;
    }

    @ApiStatus.Internal
    public final Device getDevice() {
        return this.mDevice;
    }

    @ApiStatus.Internal
    public final boolean matches(Context c) {
        return c != null && this.mDevice == c.mDevice;
    }

    @ApiStatus.Internal
    public final ContextOptions getOptions() {
        return this.mDevice.getOptions();
    }

    @ApiStatus.Internal
    public final int getContextID() {
        return this.mDevice.getContextID();
    }

    public boolean isDeviceLost() {
        return this.mDevice != null && this.mDevice.isDeviceLost();
    }

    @ApiStatus.Internal
    public final Caps getCaps() {
        return this.mDevice.getCaps();
    }

    @ApiStatus.Internal
    public final ResourceProvider getResourceProvider() {
        return this.mResourceProvider;
    }

    public final int getMaxTextureSize() {
        return this.getCaps().mMaxTextureSize;
    }

    public final int getMaxRenderTargetSize() {
        return this.getCaps().mMaxRenderTargetSize;
    }

    public abstract void freeGpuResources();

    public abstract void performDeferredCleanup(long var1);

    public long getCurrentBudgetedBytes() {
        this.checkOwnerThread();
        return this.mResourceProvider.getResourceCacheBudgetedBytes();
    }

    public long getCurrentPurgeableBytes() {
        this.checkOwnerThread();
        return this.mResourceProvider.getResourceCachePurgeableBytes();
    }

    public long getMaxBudgetedBytes() {
        this.checkOwnerThread();
        return this.mResourceProvider.getResourceCacheLimit();
    }

    @ApiStatus.Internal
    public final SharedResourceCache getSharedResourceCache() {
        return this.mDevice.getSharedResourceCache();
    }

    @ApiStatus.Internal
    public final RendererProvider getRendererProvider() {
        return this.mDevice.getRendererProvider();
    }

    public final Logger getLogger() {
        return this.mDevice.getLogger();
    }

    protected boolean init(BaseContextOptions options) {
        this.mResourceProvider = this.mDevice.makeResourceProvider(this, options.mMaxResourceBudget);
        return this.mDevice.isValid();
    }

    @Override
    protected void deallocate() {
        if (this.mResourceProvider != null) {
            this.mResourceProvider.destroy();
            this.mResourceProvider = null;
        }
    }

    public final Thread getOwnerThread() {
        return this.mOwnerThread;
    }

    public final boolean isOwnerThread() {
        return Thread.currentThread() == this.mOwnerThread;
    }

    public final void checkOwnerThread() {
        if (Thread.currentThread() != this.mOwnerThread) {
            throw new IllegalStateException("Method expected to call from " + this.mOwnerThread + ", current " + Thread.currentThread() + ", deferred " + !(this instanceof ImmediateContext));
        }
    }
}

