/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.engine.ImageDesc;

public final class DataUtils {
    public static boolean compressionTypeIsOpaque(int compression) {
        return switch (compression) {
            case 0, 1, 2 -> true;
            case 3 -> false;
            default -> throw new AssertionError(compression);
        };
    }

    public static int num4x4Blocks(int size) {
        return size + 3 >> 2;
    }

    public static long numBlocks(int compression, int width, int height) {
        return switch (compression) {
            case 0 -> (long)width * (long)height;
            case 1, 2, 3 -> {
                long numBlocksWidth = DataUtils.num4x4Blocks(width);
                long numBlocksHeight = DataUtils.num4x4Blocks(height);
                yield numBlocksWidth * numBlocksHeight;
            }
            default -> throw new AssertionError(compression);
        };
    }

    public static int numBlocks(int compression, int size) {
        return switch (compression) {
            case 0 -> size;
            case 1, 2, 3 -> DataUtils.num4x4Blocks(size);
            default -> throw new AssertionError(compression);
        };
    }

    public static long computeSize(ImageDesc desc) {
        long size = DataUtils.numBlocks(desc.getCompressionType(), desc.mWidth, desc.mHeight) * (long)desc.getBytesPerBlock();
        assert (size > 0L);
        if (desc.mMipLevelCount > 1) {
            size = (size - (size >> (desc.mMipLevelCount << 1)) << 2) / 3L;
        } else if (desc.mSampleCount > 1) {
            size *= (long)desc.mSampleCount;
        }
        assert (size > 0L);
        return size;
    }

    public static int computeMipLevelCount(int width, int height, int depth) {
        return MathUtil.floorLog2(Math.max(Math.max(width, height), depth)) + 1;
    }

    public static long computeCombinedBufferSize(int mipLevelCount, int bytesPerBlock, int width, int height, int compressionType, long[] mipOffsetsAndRowBytes) {
        assert (mipLevelCount >= 1);
        assert (mipOffsetsAndRowBytes.length >= (mipLevelCount + 1) * 2);
        long minTransferBufferAlignment = Math.max(bytesPerBlock, 4);
        long combinedBufferSize = 0L;
        for (int mipLevel = 0; mipLevel < mipLevelCount; ++mipLevel) {
            int compressedBlockWidth = DataUtils.numBlocks(compressionType, width);
            int compressedBlockHeight = DataUtils.numBlocks(compressionType, height);
            long rowBytes = (long)compressedBlockWidth * (long)bytesPerBlock;
            long alignedSize = MathUtil.alignTo(rowBytes * (long)compressedBlockHeight, minTransferBufferAlignment);
            mipOffsetsAndRowBytes[mipLevel * 2] = combinedBufferSize;
            mipOffsetsAndRowBytes[mipLevel * 2 + 1] = rowBytes;
            combinedBufferSize += alignedSize;
            width = Math.max(1, width >> 1);
            height = Math.max(1, height >> 1);
        }
        mipOffsetsAndRowBytes[mipLevelCount * 2] = combinedBufferSize;
        mipOffsetsAndRowBytes[mipLevelCount * 2 + 1] = minTransferBufferAlignment;
        return combinedBufferSize;
    }

    private DataUtils() {
    }
}

