/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DepthStencilSettings {
    public static final byte COMPARE_OP_NEVER = 0;
    public static final byte COMPARE_OP_LESS = 1;
    public static final byte COMPARE_OP_EQUAL = 2;
    public static final byte COMPARE_OP_LEQUAL = 3;
    public static final byte COMPARE_OP_GREATER = 4;
    public static final byte COMPARE_OP_NOTEQUAL = 5;
    public static final byte COMPARE_OP_GEQUAL = 6;
    public static final byte COMPARE_OP_ALWAYS = 7;
    public static final byte STENCIL_OP_KEEP = 0;
    public static final byte STENCIL_OP_ZERO = 1;
    public static final byte STENCIL_OP_REPLACE = 2;
    public static final byte STENCIL_OP_INC_CLAMP = 3;
    public static final byte STENCIL_OP_DEC_CLAMP = 4;
    public static final byte STENCIL_OP_INVERT = 5;
    public static final byte STENCIL_OP_INC_WRAP = 6;
    public static final byte STENCIL_OP_DEC_WRAP = 7;
    public final Face mFrontFace;
    public final Face mBackFace;
    public final byte mDepthCompareOp;
    public final boolean mDepthWrite;
    public final boolean mStencilTest;
    public final boolean mDepthTest;

    public DepthStencilSettings(Face frontFace, Face backFace, byte depthCompareOp, boolean depthWrite, boolean stencilTest, boolean depthTest) {
        this.mFrontFace = frontFace != null ? frontFace : backFace;
        this.mBackFace = backFace != null ? backFace : frontFace;
        this.mDepthCompareOp = depthCompareOp;
        this.mDepthWrite = depthWrite;
        this.mStencilTest = stencilTest;
        this.mDepthTest = depthTest;
    }

    public boolean isTwoSided() {
        return !Objects.equals(this.mFrontFace, this.mBackFace);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.mFrontFace);
        result = 31 * result + Objects.hashCode(this.mBackFace);
        result = 31 * result + this.mDepthCompareOp;
        result = 31 * result + (this.mDepthWrite ? 1 : 0);
        result = 31 * result + (this.mStencilTest ? 1 : 0);
        result = 31 * result + (this.mDepthTest ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DepthStencilSettings) {
            DepthStencilSettings that = (DepthStencilSettings)o;
            return this.mDepthCompareOp == that.mDepthCompareOp && this.mDepthWrite == that.mDepthWrite && this.mStencilTest == that.mStencilTest && this.mDepthTest == that.mDepthTest && Objects.equals(this.mFrontFace, that.mFrontFace) && Objects.equals(this.mBackFace, that.mBackFace);
        }
        return false;
    }

    @Immutable
    public static final class Face {
        public final byte mFailOp;
        public final byte mPassOp;
        public final byte mDepthFailOp;
        public final byte mCompareOp;
        public final int mReference;
        public final int mCompareMask;
        public final int mWriteMask;

        public Face(byte failOp, byte passOp, byte depthFailOp, byte compareOp, int reference, int compareMask, int writeMask) {
            this.mFailOp = failOp;
            this.mPassOp = passOp;
            this.mDepthFailOp = depthFailOp;
            this.mCompareOp = compareOp;
            this.mReference = reference;
            this.mCompareMask = compareMask;
            this.mWriteMask = writeMask;
        }

        public int hashCode() {
            int result = this.mFailOp;
            result = 31 * result + this.mPassOp;
            result = 31 * result + this.mDepthFailOp;
            result = 31 * result + this.mCompareOp;
            result = 31 * result + this.mReference;
            result = 31 * result + this.mCompareMask;
            result = 31 * result + this.mWriteMask;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Face) {
                Face face = (Face)o;
                return this.mFailOp == face.mFailOp && this.mPassOp == face.mPassOp && this.mDepthFailOp == face.mDepthFailOp && this.mCompareOp == face.mCompareOp && this.mReference == face.mReference && this.mCompareMask == face.mCompareMask && this.mWriteMask == face.mWriteMask;
            }
            return false;
        }
    }
}

