/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;
import yslelf.cloudpick.render.compiler.ShaderCompiler;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.BackendImage;
import yslelf.cloudpick.render.engine.BackendRenderTarget;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.ContextOptions;
import yslelf.cloudpick.render.engine.Engine;
import yslelf.cloudpick.render.engine.FlushInfo;
import yslelf.cloudpick.render.engine.GpuBufferPool;
import yslelf.cloudpick.render.engine.GpuRenderTarget;
import yslelf.cloudpick.render.engine.Image;
import yslelf.cloudpick.render.engine.ImageProxyView;
import yslelf.cloudpick.render.engine.OpsRenderPass;
import yslelf.cloudpick.render.engine.ResourceProvider;
import yslelf.cloudpick.render.engine.SharedResourceCache;
import yslelf.cloudpick.render.engine.SurfaceProxy;
import yslelf.cloudpick.render.engine.ThreadSafeCache;
import yslelf.cloudpick.render.granite.RendererProvider;
import yslelf.cloudpick.render.granite.ShaderCodeSource;

public abstract class Device
implements Engine {
    private static final AtomicInteger sNextID;
    private final int mBackend;
    private final ContextOptions mOptions;
    private final int mContextID;
    private ThreadSafeCache mThreadSafeCache;
    private SharedResourceCache mSharedResourceCache;
    private ShaderCodeSource mShaderCodeSource;
    RendererProvider mRendererProvider;
    private final AtomicBoolean mDiscarded = new AtomicBoolean(false);
    protected final Caps mCaps;
    protected final ShaderCompiler mCompiler;
    protected final Stats mStats = new Stats();
    protected volatile boolean mOutOfMemoryEncountered = false;
    protected volatile boolean mDeviceIsLost = false;
    private final ArrayList<FlushInfo.SubmittedCallback> mSubmittedCallbacks = new ArrayList();
    private int mResetBits = -1;
    private final Thread mExecutingThread;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static int createUniqueID() {
        int newValue;
        int value;
        while (!sNextID.weakCompareAndSetVolatile(value, newValue = (value = sNextID.get()) == -1 ? 1 : value + 1)) {
        }
        return value;
    }

    protected Device(int backend, ContextOptions options, Caps caps) {
        if (!$assertionsDisabled && caps == null) {
            throw new AssertionError();
        }
        this.mExecutingThread = Thread.currentThread();
        this.mBackend = backend;
        this.mOptions = options;
        this.mContextID = Device.createUniqueID();
        this.mCaps = caps;
        this.mCompiler = new ShaderCompiler();
        this.mSharedResourceCache = new SharedResourceCache();
        this.mShaderCodeSource = new ShaderCodeSource();
    }

    public final Logger getLogger() {
        return (Logger)Objects.requireNonNullElse(this.getOptions().mLogger, NOPLogger.NOP_LOGGER);
    }

    public final Thread getExecutingThread() {
        return this.mExecutingThread;
    }

    public final boolean isOnExecutingThread() {
        return this.mExecutingThread == Thread.currentThread();
    }

    @Nullable
    public BackendFormat getDefaultBackendFormat(int colorType, boolean renderable) {
        if (!$assertionsDisabled && this.mCaps == null) {
            throw new AssertionError();
        }
        BackendFormat format = this.mCaps.getDefaultBackendFormat(colorType = Engine.colorTypeToPublic(colorType), renderable);
        if (format == null) {
            return null;
        }
        if (!$assertionsDisabled && renderable && !this.mCaps.isFormatRenderable(colorType, format, 1)) {
            throw new AssertionError();
        }
        return format;
    }

    @Nullable
    public BackendFormat getCompressedBackendFormat(int compressionType) {
        if (!$assertionsDisabled && this.mCaps == null) {
            throw new AssertionError();
        }
        BackendFormat format = this.mCaps.getCompressedBackendFormat(compressionType);
        if (!($assertionsDisabled || format == null || !format.isExternal() && this.mCaps.isFormatTexturable(format))) {
            throw new AssertionError();
        }
        return format;
    }

    public int getMaxSurfaceSampleCount(int colorType) {
        if (!$assertionsDisabled && this.mCaps == null) {
            throw new AssertionError();
        }
        BackendFormat format = this.mCaps.getDefaultBackendFormat(colorType = Engine.colorTypeToPublic(colorType), true);
        if (format == null) {
            return 0;
        }
        return this.mCaps.getMaxRenderTargetSampleCount(format);
    }

    public boolean isValid() {
        return this.mCaps != null;
    }

    @ApiStatus.Internal
    public int getBackend() {
        return this.mBackend;
    }

    @ApiStatus.Internal
    public ContextOptions getOptions() {
        return this.mOptions;
    }

    @ApiStatus.Internal
    public int getContextID() {
        return this.mContextID;
    }

    boolean discard() {
        return !this.mDiscarded.compareAndExchange(false, true);
    }

    boolean isDiscarded() {
        return this.mDiscarded.get();
    }

    public int hashCode() {
        return this.mContextID;
    }

    public Caps getCaps() {
        return this.mCaps;
    }

    public final ShaderCompiler getShaderCompiler() {
        return this.mCompiler;
    }

    public abstract ResourceProvider makeResourceProvider(Context var1, long var2);

    public final SharedResourceCache getSharedResourceCache() {
        return this.mSharedResourceCache;
    }

    public final ShaderCodeSource getShaderCodeSource() {
        return this.mShaderCodeSource;
    }

    public final RendererProvider getRendererProvider() {
        return this.mRendererProvider;
    }

    public void disconnect(boolean cleanup) {
        this.mSharedResourceCache.release();
    }

    public boolean isDeviceLost() {
        return this.mDeviceIsLost;
    }

    public final Stats getStats() {
        return this.mStats;
    }

    public final void markContextDirty(int state) {
        this.mResetBits |= state;
    }

    protected void handleDirtyContext(int state) {
        int dirtyBits = this.mResetBits & state;
        if (dirtyBits != 0) {
            this.onResetContext(dirtyBits);
            this.mResetBits &= ~dirtyBits;
        }
    }

    protected void onResetContext(int resetBits) {
    }

    @Deprecated
    public GpuBufferPool getVertexPool() {
        return null;
    }

    @Deprecated
    public GpuBufferPool getInstancePool() {
        return null;
    }

    @Deprecated
    public GpuBufferPool getIndexPool() {
        return null;
    }

    protected void freeGpuResources() {
    }

    protected void purgeResourcesNotUsedSince(long timeMillis) {
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget createRenderTarget(int numColorTargets, @Nullable Image[] colorTargets, @Nullable Image[] resolveTargets, @Nullable int[] mipLevels, @Nullable Image depthStencilTarget, int surfaceFlags) {
        int i;
        if (numColorTargets < 0 || numColorTargets > this.mCaps.maxColorAttachments()) {
            return null;
        }
        int usedColorTargets = 0;
        if (colorTargets != null) {
            for (int i2 = 0; i2 < numColorTargets; ++i2) {
                usedColorTargets += colorTargets[i2] != null ? 1 : 0;
            }
        }
        if (usedColorTargets == 0 && depthStencilTarget == null) {
            return null;
        }
        int sampleCount = -1;
        int width = Integer.MAX_VALUE;
        int height = Integer.MAX_VALUE;
        if (colorTargets != null) {
            for (i = 0; i < numColorTargets; ++i) {
                Image colorTarget = colorTargets[i];
                if (colorTarget == null) continue;
                if (!colorTarget.isRenderable()) {
                    return null;
                }
                int samples = colorTarget.getSampleCount();
                if (sampleCount == -1) {
                    sampleCount = samples;
                } else if (sampleCount != samples) {
                    return null;
                }
                width = Math.min(width, colorTarget.getWidth());
                height = Math.min(height, colorTarget.getHeight());
            }
        }
        if (depthStencilTarget != null) {
            if (!depthStencilTarget.isRenderable()) {
                return null;
            }
            int samples = depthStencilTarget.getSampleCount();
            if (sampleCount == -1) {
                sampleCount = samples;
            } else if (sampleCount != samples) {
                return null;
            }
            width = Math.min(width, depthStencilTarget.getWidth());
            height = Math.min(height, depthStencilTarget.getHeight());
        }
        if (sampleCount == -1) {
            return null;
        }
        if (!$assertionsDisabled && width >= Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && height >= Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        if (resolveTargets != null) {
            for (i = 0; i < numColorTargets; ++i) {
                Image resolveTarget = resolveTargets[i];
                if (resolveTarget == null) continue;
                if (colorTargets == null || colorTargets[i] == null) {
                    return null;
                }
                if (sampleCount == 1) {
                    return null;
                }
                if (resolveTarget.getSampleCount() != 1) {
                    return null;
                }
                if (resolveTarget.getWidth() >= width && resolveTarget.getHeight() >= height) continue;
                return null;
            }
        }
        return this.onCreateRenderTarget(width, height, sampleCount, numColorTargets, colorTargets, resolveTargets, mipLevels, depthStencilTarget, surfaceFlags);
    }

    @Deprecated
    @Nullable
    @ApiStatus.OverrideOnly
    @SharedPtr
    protected abstract GpuRenderTarget onCreateRenderTarget(int var1, int var2, int var3, int var4, @Nullable Image[] var5, @Nullable Image[] var6, @Nullable int[] var7, @Nullable Image var8, int var9);

    @Deprecated
    @Nullable
    @SharedPtr
    public GpuRenderTarget wrapRenderableBackendTexture(BackendImage texture, int sampleCount, boolean ownership) {
        if (sampleCount < 1) {
            return null;
        }
        Caps caps = this.mCaps;
        if (!caps.isFormatTexturable(texture.getBackendFormat()) || !caps.isFormatRenderable(texture.getBackendFormat(), sampleCount)) {
            return null;
        }
        if (texture.getWidth() > caps.maxRenderTargetSize() || texture.getHeight() > caps.maxRenderTargetSize()) {
            return null;
        }
        return this.onWrapRenderableBackendTexture(texture, sampleCount, ownership);
    }

    @Deprecated
    @Nullable
    @SharedPtr
    protected abstract GpuRenderTarget onWrapRenderableBackendTexture(BackendImage var1, int var2, boolean var3);

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget wrapGLDefaultFramebuffer(int width, int height, int sampleCount, int depthBits, int stencilBits, BackendFormat format) {
        if (!this.getCaps().isFormatRenderable(format, sampleCount)) {
            return null;
        }
        return this.onWrapGLDefaultFramebuffer(width, height, sampleCount, depthBits, stencilBits, format);
    }

    @Deprecated
    @Nullable
    @ApiStatus.OverrideOnly
    @SharedPtr
    protected GpuRenderTarget onWrapGLDefaultFramebuffer(int width, int height, int sampleCount, int depthBits, int stencilBits, BackendFormat format) {
        return null;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public GpuRenderTarget wrapBackendRenderTarget(BackendRenderTarget backendRenderTarget) {
        if (!this.getCaps().isFormatRenderable(backendRenderTarget.getBackendFormat(), backendRenderTarget.getSampleCount())) {
            return null;
        }
        return this.onWrapBackendRenderTarget(backendRenderTarget);
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public abstract GpuRenderTarget onWrapBackendRenderTarget(BackendRenderTarget var1);

    @Deprecated
    @Nullable
    public final OpsRenderPass getOpsRenderPass(ImageProxyView writeView, Rect2i contentBounds, byte colorOps, byte stencilOps, float[] clearColor, Set<SurfaceProxy> sampledTextures, int pipelineFlags) {
        this.mStats.incRenderPasses();
        return this.onGetOpsRenderPass(writeView, contentBounds, colorOps, stencilOps, clearColor, sampledTextures, pipelineFlags);
    }

    @Deprecated
    protected abstract OpsRenderPass onGetOpsRenderPass(ImageProxyView var1, Rect2i var2, byte var3, byte var4, float[] var5, Set<SurfaceProxy> var6, int var7);

    @Deprecated
    public void resolveRenderTarget(GpuRenderTarget renderTarget, int resolveLeft, int resolveTop, int resolveRight, int resolveBottom) {
        if (!$assertionsDisabled && renderTarget == null) {
            throw new AssertionError();
        }
        this.onResolveRenderTarget(renderTarget, resolveLeft, resolveTop, resolveRight, resolveBottom);
    }

    @Deprecated
    protected abstract void onResolveRenderTarget(GpuRenderTarget var1, int var2, int var3, int var4, int var5);

    public abstract long insertFence();

    public abstract boolean checkFence(long var1);

    public abstract void deleteFence(long var1);

    public abstract void addFinishedCallback(FlushInfo.FinishedCallback var1);

    public abstract void checkFinishedCallbacks();

    public abstract void waitForQueue();

    public final boolean checkOutOfMemory() {
        if (this.mOutOfMemoryEncountered) {
            this.mOutOfMemoryEncountered = false;
            return true;
        }
        return false;
    }

    static {
        boolean bl = $assertionsDisabled = !Device.class.desiredAssertionStatus();
        if (!$assertionsDisabled && 0 != Engine.LoadStoreOps.make((byte)0, (byte)0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 1 != Engine.LoadStoreOps.make((byte)1, (byte)0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 2 != Engine.LoadStoreOps.make((byte)2, (byte)0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 16 != Engine.LoadStoreOps.make((byte)0, (byte)1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 17 != Engine.LoadStoreOps.make((byte)1, (byte)1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 18 != Engine.LoadStoreOps.make((byte)2, (byte)1)) {
            throw new AssertionError();
        }
        sNextID = new AtomicInteger(1);
    }

    public static final class Stats {
        private long mImageCreates = 0L;
        private long mTextureCreates = 0L;
        private long mTextureUploads = 0L;
        private long mTransfersToTexture = 0L;
        private long mTransfersFromSurface = 0L;
        private long mNumDraws = 0L;
        private long mNumFailedDraws = 0L;
        private long mNumSubmitToGpus = 0L;
        private long mNumScratchTexturesReused = 0L;
        private long mNumScratchRenderTargetsReused = 0L;
        private long mNumScratchMSAAAttachmentsReused = 0L;
        private long mRenderPasses = 0L;

        public void reset() {
            this.mImageCreates = 0L;
            this.mTextureCreates = 0L;
            this.mTextureUploads = 0L;
            this.mTransfersToTexture = 0L;
            this.mTransfersFromSurface = 0L;
            this.mNumDraws = 0L;
            this.mNumFailedDraws = 0L;
            this.mNumSubmitToGpus = 0L;
            this.mNumScratchTexturesReused = 0L;
            this.mNumScratchRenderTargetsReused = 0L;
            this.mNumScratchMSAAAttachmentsReused = 0L;
            this.mRenderPasses = 0L;
        }

        public long numImageCreates() {
            return this.mImageCreates;
        }

        public void incImageCreates() {
            ++this.mImageCreates;
        }

        public long numTextureCreates() {
            return this.mTextureCreates;
        }

        public void incTextureCreates() {
            ++this.mTextureCreates;
        }

        public long numTextureUploads() {
            return this.mTextureUploads;
        }

        public void incTextureUploads() {
            ++this.mTextureUploads;
        }

        public long numTransfersToTexture() {
            return this.mTransfersToTexture;
        }

        public void incTransfersToTexture() {
            ++this.mTransfersToTexture;
        }

        public long numTransfersFromSurface() {
            return this.mTransfersFromSurface;
        }

        public void incTransfersFromSurface() {
            ++this.mTransfersFromSurface;
        }

        public long numDraws() {
            return this.mNumDraws;
        }

        public void incNumDraws() {
            ++this.mNumDraws;
        }

        public void incNumDraws(int increment) {
            this.mNumDraws += (long)increment;
        }

        public long numFailedDraws() {
            return this.mNumFailedDraws;
        }

        public void incNumFailedDraws() {
            ++this.mNumFailedDraws;
        }

        public long numSubmitToGpus() {
            return this.mNumSubmitToGpus;
        }

        public void incNumSubmitToGpus() {
            ++this.mNumSubmitToGpus;
        }

        public long numScratchTexturesReused() {
            return this.mNumScratchTexturesReused;
        }

        public void incNumScratchTexturesReused() {
            ++this.mNumScratchTexturesReused;
        }

        public long numScratchRenderTargetsReused() {
            return this.mNumScratchRenderTargetsReused;
        }

        public void incNumScratchRenderTargetsReused() {
            ++this.mNumScratchRenderTargetsReused;
        }

        public long numScratchMSAAAttachmentsReused() {
            return this.mNumScratchMSAAAttachmentsReused;
        }

        public void incNumScratchMSAAAttachmentsReused() {
            ++this.mNumScratchMSAAAttachmentsReused;
        }

        public long numRenderPasses() {
            return this.mRenderPasses;
        }

        public void incRenderPasses() {
            ++this.mRenderPasses;
        }

        public String toString() {
            return "GpuDevice.Stats{mImageCreates=" + this.mImageCreates + ", mTextureCreates=" + this.mTextureCreates + ", mTextureUploads=" + this.mTextureUploads + ", mTransfersToTexture=" + this.mTransfersToTexture + ", mTransfersFromSurface=" + this.mTransfersFromSurface + ", mNumDraws=" + this.mNumDraws + ", mNumFailedDraws=" + this.mNumFailedDraws + ", mNumSubmitToGpus=" + this.mNumSubmitToGpus + ", mNumScratchTexturesReused=" + this.mNumScratchTexturesReused + ", mNumScratchRenderTargetsReused=" + this.mNumScratchRenderTargetsReused + ", mNumScratchMSAAAttachmentsReused=" + this.mNumScratchMSAAAttachmentsReused + ", mRenderPasses=" + this.mRenderPasses + "}";
        }
    }
}

