/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import java.util.Map;
import java.util.Objects;

public class DriverBugWorkarounds {
    public static final int DEFAULT = 0;
    public static final int DISABLED = 1;
    public static final int ENABLED = 2;

    public DriverBugWorkarounds() {
    }

    public DriverBugWorkarounds(Map<String, Boolean> states) {
        if (states == null || states.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Boolean> e : states.entrySet()) {
            Objects.requireNonNull(e.getKey());
        }
    }

    private static byte mask(Map.Entry<?, Boolean> e) {
        Boolean v = e.getValue();
        if (v == Boolean.TRUE) {
            return 2;
        }
        if (v == Boolean.FALSE) {
            return 1;
        }
        return 0;
    }

    public static boolean isEnabled(byte state) {
        return (state & 2) != 0;
    }

    public static boolean isDisabled(byte state) {
        return (state & 1) != 0;
    }

    public void applyOverrides(DriverBugWorkarounds workarounds) {
        if (workarounds != null) {
            // empty if block
        }
    }
}

