/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import yslelf.cloudpick.render.core.ColorInfo;

public interface Engine {
    public static final int COLOR_ENCODING_UNORM = 0;
    public static final int COLOR_ENCODING_UNORM_PACK16 = 1;
    public static final int COLOR_ENCODING_UNORM_PACK32 = 2;
    public static final int COLOR_ENCODING_UNORM_SRGB = 3;
    public static final int COLOR_ENCODING_FLOAT = 4;
    public static final int CLAMP_TYPE_AUTO = 0;
    public static final int CLAMP_TYPE_MANUAL = 1;
    public static final int CLAMP_TYPE_NONE = 2;
    public static final int MASK_FORMAT_A8 = 0;
    public static final int MASK_FORMAT_A565 = 1;
    public static final int MASK_FORMAT_ARGB = 2;
    public static final int LAST_MASK_FORMAT = 2;
    public static final int MASK_FORMAT_COUNT = 3;
    public static final boolean Ownership_Borrowed = false;
    public static final boolean Ownership_Owned = true;
    public static final int INVALID_RESOURCE_HANDLE = -1;

    public static int colorTypeToPublic(int ct) {
        return switch (ct) {
            case 0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> ct;
            case 4, 11, 12, 23 -> 0;
            default -> throw new AssertionError(ct);
        };
    }

    public static int colorTypeEncoding(int ct) {
        return switch (ct) {
            case 0, 2, 3, 4, 5, 6, 7, 11, 13, 15, 19, 20, 22, 23, 24, 25 -> 0;
            case 1 -> 1;
            case 9, 10 -> 2;
            case 8 -> 3;
            case 12, 14, 16, 17, 18, 21 -> 4;
            default -> throw new AssertionError(ct);
        };
    }

    public static int colorTypeClampType(int ct) {
        return switch (ct) {
            case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 19, 20, 22, 23, 24, 25 -> 0;
            case 17 -> 1;
            case 12, 14, 16, 18, 21 -> 2;
            default -> throw new AssertionError(ct);
        };
    }

    public static int maskFormatBytesPerPixel(int maskFormat) {
        if (!1.$assertionsDisabled && maskFormat >= 3) {
            throw new AssertionError();
        }
        return 1 << maskFormat;
    }

    public static int maskFormatToColorType(int maskFormat) {
        int ct = switch (maskFormat) {
            case 0 -> 19;
            case 1 -> 1;
            case 2 -> 6;
            default -> throw new AssertionError();
        };
        if (!1.$assertionsDisabled && Engine.maskFormatBytesPerPixel(maskFormat) != ColorInfo.bytesPerPixel(ct)) {
            throw new AssertionError();
        }
        return ct;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface VertexAttribType {
        public static final byte kFloat = 0;
        public static final byte kFloat2 = 1;
        public static final byte kFloat3 = 2;
        public static final byte kFloat4 = 3;
        public static final byte kHalf = 4;
        public static final byte kHalf2 = 5;
        public static final byte kHalf4 = 6;
        public static final byte kInt2 = 7;
        public static final byte kInt3 = 8;
        public static final byte kInt4 = 9;
        public static final byte kByte = 10;
        public static final byte kByte2 = 11;
        public static final byte kByte4 = 12;
        public static final byte kUByte = 13;
        public static final byte kUByte2 = 14;
        public static final byte kUByte4 = 15;
        public static final byte kUByte_norm = 16;
        public static final byte kUByte4_norm = 17;
        public static final byte kShort2 = 18;
        public static final byte kShort4 = 19;
        public static final byte kUShort2 = 20;
        public static final byte kUShort2_norm = 21;
        public static final byte kInt = 22;
        public static final byte kUInt = 23;
        public static final byte kUShort_norm = 24;
        public static final byte kUShort4_norm = 25;
        public static final byte kLast = 25;

        public static int size(byte type) {
            switch (type) {
                case 0: {
                    return 4;
                }
                case 1: {
                    return 8;
                }
                case 2: {
                    return 12;
                }
                case 3: {
                    return 16;
                }
                case 4: 
                case 24: {
                    return 2;
                }
                case 5: 
                case 18: 
                case 20: 
                case 21: {
                    return 4;
                }
                case 6: 
                case 19: 
                case 25: {
                    return 8;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 12;
                }
                case 9: {
                    return 16;
                }
                case 10: 
                case 13: 
                case 16: {
                    return 1;
                }
                case 11: 
                case 14: {
                    return 2;
                }
                case 12: 
                case 15: 
                case 17: {
                    return 4;
                }
                case 22: 
                case 23: {
                    return 4;
                }
            }
            throw new AssertionError(type);
        }
    }

    public static interface IndexType {
        public static final int kUByte = 0;
        public static final int kUShort = 1;
        public static final int kUInt = 2;

        public static int size(int type) {
            if (!1.$assertionsDisabled && type != 0 && type != 1 && type != 2) {
                throw new AssertionError();
            }
            return 1 << type;
        }
    }

    public static interface LoadStoreOps {
        public static final byte StoreOpShift = 4;
        public static final byte Load_Store = 0;
        public static final byte Clear_Store = 1;
        public static final byte DontLoad_Store = 2;
        public static final byte Load_DontStore = 16;
        public static final byte Clear_DontStore = 17;
        public static final byte DontLoad_DontStore = 18;

        public static byte make(byte load, byte store) {
            if (!1.$assertionsDisabled && load >= 16) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && store >= 16) {
                throw new AssertionError();
            }
            return (byte)(load | store << 4);
        }

        public static byte loadOp(byte ops) {
            return (byte)(ops & 0xF);
        }

        public static byte storeOp(byte ops) {
            return (byte)(ops >>> 4);
        }
    }

    public static interface StoreOp {
        public static final byte kStore = 0;
        public static final byte kDiscard = 1;
        public static final byte kCount = 2;
    }

    public static interface LoadOp {
        public static final byte kLoad = 0;
        public static final byte kClear = 1;
        public static final byte kDiscard = 2;
        public static final byte kCount = 3;
    }

    public static interface BudgetType {
        public static final byte Budgeted = 0;
        public static final byte NotBudgeted = 1;
        public static final byte WrapCacheable = 2;
    }

    public static interface PrimitiveType {
        public static final byte kPointList = 0;
        public static final byte kLineList = 1;
        public static final byte kLineStrip = 2;
        public static final byte kTriangleList = 3;
        public static final byte kTriangleStrip = 4;
        public static final byte kCount = 5;
    }

    public static interface ShaderFlags {
        public static final int kVertex = 1;
        public static final int kGeometry = 2;
        public static final int kFragment = 4;
        public static final int kCompute = 8;
    }

    public static interface BufferUsageFlags {
        public static final int kVertex = 1;
        public static final int kIndex = 2;
        public static final int kDrawIndirect = 4;
        public static final int kUpload = 8;
        public static final int kReadback = 16;
        public static final int kUniform = 32;
        public static final int kStorage = 64;
        public static final int kDeviceLocal = 65536;
        public static final int kHostVisible = 131072;
        public static final int kTypeMask = 65535;
        public static final int kAccessMask = 0xFF0000;
    }

    public static interface DepthStencilFlags {
        public static final int kNone = 0;
        public static final int kDepth = 1;
        public static final int kStencil = 2;
        public static final int kDepthStencil = 3;
    }

    public static interface IOType {
        public static final int kRead = 0;
        public static final int kWrite = 1;
        public static final int kRW = 2;
    }

    public static interface ImageCreateFlags {
    }

    public static interface ImageType {
        public static final int kNone = 0;
        public static final int k2D = 1;
        public static final int k2DArray = 2;
        public static final int kCube = 3;
        public static final int kCubeArray = 4;
        public static final int k3D = 5;
        public static final int kCount = 6;
    }

    public static interface GLBackendState {
        public static final int kRenderTarget = 1;
        public static final int kPixelStore = 2;
        public static final int kPipeline = 4;
        public static final int kTexture = 8;
        public static final int kStencil = 16;
        public static final int kRaster = 32;
        public static final int kBlend = 64;
        public static final int kView = 128;
        public static final int kMisc = 256;
    }

    public static interface SurfaceOrigin {
        public static final int kUpperLeft = 0;
        public static final int kLowerLeft = 1;
    }

    public static interface BackendApi {
        public static final int kOpenGL = 0;
        public static final int kVulkan = 1;
        public static final int kMock = 2;

        public static String toString(int value) {
            return switch (value) {
                case 0 -> "OpenGL";
                case 1 -> "Vulkan";
                case 2 -> "Mock";
                default -> String.valueOf(value);
            };
        }
    }
}

