/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Framebuffer;
import yslelf.cloudpick.render.engine.FramebufferDesc;

public class FramebufferCache
implements AutoCloseable {
    private final HashMap<FramebufferDesc, @SharedPtr Framebuffer> mFramebufferMap = new HashMap();

    @Nullable
    @SharedPtr
    public Framebuffer findFramebuffer(@Nonnull FramebufferDesc desc) {
        Framebuffer framebuffer = this.mFramebufferMap.get(desc);
        if (framebuffer != null) {
            framebuffer.setLastUsedTime();
            framebuffer.ref();
        }
        return framebuffer;
    }

    public void insertFramebuffer(@Nonnull FramebufferDesc desc, @RawPtr Framebuffer framebuffer) {
        Framebuffer old = this.mFramebufferMap.put(desc, framebuffer);
        assert (old == null);
        framebuffer.setLastUsedTime();
        framebuffer.ref();
    }

    public void purgeAllFramebuffers() {
        this.mFramebufferMap.values().forEach(RefCnt::unref);
        this.mFramebufferMap.clear();
    }

    public void purgeFramebuffersNotUsedSince(long timeMillis) {
        if (this.mFramebufferMap.isEmpty()) {
            return;
        }
        ObjectArrayList framebuffersToDelete = new ObjectArrayList();
        for (Map.Entry<FramebufferDesc, Framebuffer> e : this.mFramebufferMap.entrySet()) {
            if (!e.getKey().isStale() && e.getValue().getLastUsedTime() >= timeMillis) continue;
            framebuffersToDelete.add((Object)e.getKey());
        }
        for (FramebufferDesc desc : framebuffersToDelete) {
            this.mFramebufferMap.remove(desc).unref();
        }
    }

    public void purgeStaleFramebuffers() {
        if (this.mFramebufferMap.isEmpty()) {
            return;
        }
        boolean useTime = this.mFramebufferMap.size() > 32;
        long timeMillis = useTime ? System.currentTimeMillis() - 20000L : 0L;
        ObjectArrayList framebuffersToDelete = new ObjectArrayList();
        for (Map.Entry<FramebufferDesc, Framebuffer> e : this.mFramebufferMap.entrySet()) {
            if (!e.getKey().isStale() && (!useTime || e.getValue().getLastUsedTime() >= timeMillis)) continue;
            framebuffersToDelete.add((Object)e.getKey());
        }
        for (FramebufferDesc desc : framebuffersToDelete) {
            this.mFramebufferMap.remove(desc).unref();
        }
    }

    @Override
    public void close() {
        this.purgeAllFramebuffers();
    }
}

