/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.UniqueID;
import yslelf.cloudpick.render.engine.Image;

@Immutable
public final class FramebufferDesc {
    @ApiStatus.Internal
    public static final int FLAG_GL_WRAP_DEFAULT_FB = 2048;
    @ApiStatus.Internal
    public static final int FLAG_MANUAL_MSAA_RESOLVE = 4096;
    @ApiStatus.Internal
    public static final int FLAG_VK_WRAP_SECONDARY_CB = 8192;
    @Nonnull
    public final ColorAttachmentDesc[] mColorAttachments;
    public static final ColorAttachmentDesc[] NO_COLOR_ATTACHMENTS = new ColorAttachmentDesc[0];
    @Nonnull
    public final DepthStencilAttachmentDesc mDepthStencilAttachment;
    public static final DepthStencilAttachmentDesc NO_DEPTH_STENCIL_ATTACHMENT = new DepthStencilAttachmentDesc();
    public final int mWidth;
    public final int mHeight;
    public final int mSampleCount;
    public int mFramebufferFlags;

    public FramebufferDesc(int width, int height, int sampleCount, @Nullable ColorAttachmentDesc colorAttachment, @Nullable DepthStencilAttachmentDesc depthStencilAttachment) {
        ColorAttachmentDesc[] colorAttachmentDescArray;
        if (colorAttachment != null) {
            ColorAttachmentDesc[] colorAttachmentDescArray2 = new ColorAttachmentDesc[1];
            colorAttachmentDescArray = colorAttachmentDescArray2;
            colorAttachmentDescArray2[0] = colorAttachment;
        } else {
            colorAttachmentDescArray = null;
        }
        this(width, height, sampleCount, colorAttachmentDescArray, depthStencilAttachment);
    }

    public FramebufferDesc(int width, int height, int sampleCount, @Nullable ColorAttachmentDesc[] colorAttachments, @Nullable DepthStencilAttachmentDesc depthStencilAttachment) {
        this.mWidth = width;
        this.mHeight = height;
        this.mSampleCount = sampleCount;
        this.mColorAttachments = colorAttachments != null ? colorAttachments : NO_COLOR_ATTACHMENTS;
        DepthStencilAttachmentDesc depthStencilAttachmentDesc = this.mDepthStencilAttachment = depthStencilAttachment != null ? depthStencilAttachment : NO_DEPTH_STENCIL_ATTACHMENT;
        assert (this.mColorAttachments.length <= 8);
        for (ColorAttachmentDesc colorAttachment : this.mColorAttachments) {
            assert (colorAttachment != null);
        }
    }

    public boolean isStale() {
        for (ColorAttachmentDesc colorAttachment : this.mColorAttachments) {
            if (!colorAttachment.isStale()) continue;
            return true;
        }
        return this.mDepthStencilAttachment.isStale();
    }

    public int hashCode() {
        int result = this.mWidth;
        result = 31 * result + this.mHeight;
        result = 31 * result + this.mSampleCount;
        for (ColorAttachmentDesc colorAttachment : this.mColorAttachments) {
            result = 31 * result + colorAttachment.hashCode();
        }
        result = 31 * result + this.mDepthStencilAttachment.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FramebufferDesc) {
            FramebufferDesc that = (FramebufferDesc)o;
            if (this.mWidth == that.mWidth && this.mHeight == that.mHeight && this.mSampleCount == that.mSampleCount && this.mColorAttachments.length == that.mColorAttachments.length && this.mDepthStencilAttachment.equals(that.mDepthStencilAttachment)) {
                for (int i = 0; i < this.mColorAttachments.length; ++i) {
                    if (this.mColorAttachments[i].equals(that.mColorAttachments[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Immutable
    public static final class ColorAttachmentDesc {
        @Nullable
        public final WeakReference<@RawPtr Image> mAttachment;
        @Nullable
        public final WeakReference<@RawPtr Image> mResolveAttachment;
        @Nullable
        public final UniqueID mAttachmentID;
        @Nullable
        public final UniqueID mResolveAttachmentID;
        public final int mMipLevel;
        public final int mArraySlice;

        public ColorAttachmentDesc() {
            this.mAttachment = null;
            this.mAttachmentID = null;
            this.mResolveAttachment = null;
            this.mResolveAttachmentID = null;
            this.mMipLevel = 0;
            this.mArraySlice = 0;
        }

        public ColorAttachmentDesc(@Nullable @RawPtr Image attachment, @Nullable @RawPtr Image resolveAttachment, int mipLevel, int arraySlice) {
            if (attachment != null) {
                this.mAttachment = new WeakReference<Image>(attachment);
                this.mAttachmentID = attachment.getUniqueID();
            } else {
                this.mAttachment = null;
                this.mAttachmentID = null;
            }
            if (resolveAttachment != null) {
                this.mResolveAttachment = new WeakReference<Image>(resolveAttachment);
                this.mResolveAttachmentID = resolveAttachment.getUniqueID();
            } else {
                this.mResolveAttachment = null;
                this.mResolveAttachmentID = null;
            }
            assert (mipLevel >= 0 && arraySlice >= 0);
            this.mMipLevel = mipLevel;
            this.mArraySlice = arraySlice;
        }

        public boolean isStale() {
            Image e;
            return this.mAttachmentID != null && ((e = (Image)this.mAttachment.get()) == null || e.isDestroyed()) || this.mResolveAttachmentID != null && ((e = (Image)this.mResolveAttachment.get()) == null || e.isDestroyed());
        }

        public int hashCode() {
            int result = Objects.hashCode(this.mAttachmentID);
            result = 31 * result + Objects.hashCode(this.mResolveAttachmentID);
            result = 31 * result + this.mMipLevel;
            result = 31 * result + this.mArraySlice;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ColorAttachmentDesc) {
                ColorAttachmentDesc that = (ColorAttachmentDesc)o;
                return this.mMipLevel == that.mMipLevel && this.mArraySlice == that.mArraySlice && this.mAttachmentID == that.mAttachmentID && this.mResolveAttachmentID == that.mResolveAttachmentID;
            }
            return false;
        }
    }

    @Immutable
    public static final class DepthStencilAttachmentDesc {
        @Nullable
        public final WeakReference<@RawPtr Image> mAttachment;
        @Nullable
        public final UniqueID mAttachmentID;

        public DepthStencilAttachmentDesc() {
            this.mAttachment = null;
            this.mAttachmentID = null;
        }

        public DepthStencilAttachmentDesc(@Nullable @RawPtr Image attachment) {
            if (attachment != null) {
                this.mAttachment = new WeakReference<Image>(attachment);
                this.mAttachmentID = attachment.getUniqueID();
            } else {
                this.mAttachment = null;
                this.mAttachmentID = null;
            }
        }

        public boolean isStale() {
            Image e;
            return this.mAttachmentID != null && ((e = (Image)this.mAttachment.get()) == null || e.isDestroyed());
        }

        public int hashCode() {
            return Objects.hashCode(this.mAttachmentID);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DepthStencilAttachmentDesc) {
                DepthStencilAttachmentDesc that = (DepthStencilAttachmentDesc)o;
                return this.mAttachmentID == that.mAttachmentID;
            }
            return false;
        }
    }
}

