/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.CommandBuffer;
import yslelf.cloudpick.render.engine.Mesh;
import yslelf.cloudpick.render.engine.ResourceProvider;

@Deprecated
public abstract class GpuBufferPool {
    public static final int DEFAULT_BUFFER_SIZE = 131072;
    private final ResourceProvider mResourceProvider;
    private final int mBufferType;
    @SharedPtr
    protected Buffer[] mBuffers = new Buffer[8];
    protected int[] mFreeBytes = new int[8];
    protected int mIndex = -1;
    protected long mBufferPtr;
    private int mBytesInUse;
    protected ByteBuffer mCachedWriter;

    protected GpuBufferPool(ResourceProvider resourceProvider, int bufferType) {
        assert (bufferType == 1 || bufferType == 2);
        this.mResourceProvider = resourceProvider;
        this.mBufferType = bufferType;
    }

    @Nonnull
    public static GpuBufferPool makeVertexPool(ResourceProvider resourceProvider) {
        return new VertexPool(resourceProvider);
    }

    @Nonnull
    public static GpuBufferPool makeInstancePool(ResourceProvider resourceProvider) {
        return new InstancePool(resourceProvider);
    }

    @Nonnull
    public static GpuBufferPool makeIndexPool(ResourceProvider resourceProvider) {
        return new IndexPool(resourceProvider);
    }

    public void flush() {
        if (this.mBufferPtr != 0L) {
            assert (this.mIndex >= 0);
            Buffer buffer = this.mBuffers[this.mIndex];
            int usedBytes = (int)buffer.getSize() - this.mFreeBytes[this.mIndex];
            assert (buffer.isMapped());
            assert (buffer.getMappedBuffer() == this.mBufferPtr);
            buffer.unmap(usedBytes);
            this.mBufferPtr = 0L;
        }
    }

    public void reset() {
        Buffer buffer;
        this.mBytesInUse = 0;
        if (this.mIndex >= 0 && (buffer = this.mBuffers[this.mIndex]).isMapped()) {
            assert (this.mBufferPtr != 0L);
            assert (buffer.getMappedBuffer() == this.mBufferPtr);
            buffer.unmap();
            this.mBufferPtr = 0L;
        }
        while (this.mIndex >= 0) {
            buffer = this.mBuffers[this.mIndex];
            assert (!buffer.isMapped());
            this.mBuffers[this.mIndex--] = RefCnt.move(buffer);
        }
        assert (this.mIndex == -1);
        assert (this.mBufferPtr == 0L);
    }

    public void submit(CommandBuffer cmdBuffer) {
        Buffer buffer;
        this.mBytesInUse = 0;
        if (this.mIndex >= 0 && (buffer = this.mBuffers[this.mIndex]).isMapped()) {
            assert (this.mBufferPtr != 0L);
            assert (buffer.getMappedBuffer() == this.mBufferPtr);
            buffer.unmap();
            this.mBufferPtr = 0L;
        }
        while (this.mIndex >= 0) {
            buffer = this.mBuffers[this.mIndex];
            assert (!buffer.isMapped());
            cmdBuffer.trackResource(buffer);
            this.mBuffers[this.mIndex--] = null;
        }
        assert (this.mIndex == -1);
        assert (this.mBufferPtr == 0L);
    }

    public void putBack(int bytes) {
        while (bytes > 0) {
            assert (this.mIndex >= 0);
            Buffer buffer = this.mBuffers[this.mIndex];
            int usedBytes = (int)buffer.getSize() - this.mFreeBytes[this.mIndex];
            if (bytes >= usedBytes) {
                bytes -= usedBytes;
                this.mBytesInUse -= usedBytes;
                assert (buffer.isMapped());
                assert (buffer.getMappedBuffer() == this.mBufferPtr);
                buffer.unmap(usedBytes);
                assert (!buffer.isMapped());
                this.mBuffers[this.mIndex--] = RefCnt.move(buffer);
                this.mBufferPtr = 0L;
                continue;
            }
            int n2 = this.mIndex;
            this.mFreeBytes[n2] = this.mFreeBytes[n2] + bytes;
            this.mBytesInUse -= bytes;
            break;
        }
    }

    public abstract long makeSpace(Mesh var1);

    @Nullable
    public abstract ByteBuffer makeWriter(Mesh var1);

    protected long makeSpace(int size, int alignment) {
        int blockSize;
        Buffer buffer;
        assert (size > 0);
        assert (alignment > 0);
        if (this.mBufferPtr != 0L) {
            assert (this.mIndex >= 0);
            Buffer buffer2 = this.mBuffers[this.mIndex];
            int pos = (int)buffer2.getSize() - this.mFreeBytes[this.mIndex];
            int pad = MathUtil.alignUpPad(pos, alignment);
            int alignedSize = size + pad;
            if (alignedSize <= 0) {
                return 0L;
            }
            if (alignedSize <= this.mFreeBytes[this.mIndex]) {
                int n2 = this.mIndex;
                this.mFreeBytes[n2] = this.mFreeBytes[n2] - alignedSize;
                this.mBytesInUse += alignedSize;
                return this.mBufferPtr + (long)pos + (long)pad;
            }
        }
        if ((buffer = this.mResourceProvider.findOrCreateBuffer(blockSize = Math.max(size, 131072), this.mBufferType | 0x20000, "")) == null) {
            return 0L;
        }
        this.flush();
        int cap = this.mBuffers.length;
        if (++this.mIndex >= cap) {
            cap += cap >> 1;
            this.mBuffers = Arrays.copyOf(this.mBuffers, cap);
            this.mFreeBytes = Arrays.copyOf(this.mFreeBytes, cap);
        }
        this.mBuffers[this.mIndex] = buffer;
        this.mFreeBytes[this.mIndex] = (int)buffer.getSize() - size;
        this.mBytesInUse += size;
        assert (this.mBufferPtr == 0L);
        this.mBufferPtr = buffer.map();
        assert (this.mBufferPtr != 0L);
        assert (buffer.isMapped());
        assert (buffer.getMappedBuffer() == this.mBufferPtr);
        return this.mBufferPtr;
    }

    @Nonnull
    private static ByteBuffer getMappedBuffer(@Nullable ByteBuffer buffer, long address, int capacity) {
        if (buffer != null && MemoryUtil.memAddress0((java.nio.Buffer)buffer) == address && buffer.capacity() == capacity) {
            return buffer;
        }
        return MemoryUtil.memByteBuffer((long)address, (int)capacity);
    }

    private static class VertexPool
    extends GpuBufferPool {
        public VertexPool(ResourceProvider resourceProvider) {
            super(resourceProvider, 1);
        }

        @Override
        public long makeSpace(Mesh mesh) {
            int vertexSize = mesh.getVertexSize();
            int vertexCount = mesh.getVertexCount();
            assert (vertexSize > 0 && vertexCount > 0);
            int totalSize = vertexSize * vertexCount;
            long ptr = this.makeSpace(totalSize, vertexSize);
            if (ptr == 0L) {
                return 0L;
            }
            Buffer buffer = this.mBuffers[this.mIndex];
            int offset = (int)(ptr - this.mBufferPtr);
            assert (offset % vertexSize == 0);
            mesh.setVertexBuffer(buffer, offset / vertexSize, vertexCount);
            return ptr;
        }

        @Override
        @Nullable
        public ByteBuffer makeWriter(Mesh mesh) {
            int vertexSize = mesh.getVertexSize();
            int vertexCount = mesh.getVertexCount();
            assert (vertexSize > 0 && vertexCount > 0);
            int totalSize = vertexSize * vertexCount;
            long ptr = this.makeSpace(totalSize, vertexSize);
            if (ptr == 0L) {
                return null;
            }
            Buffer buffer = this.mBuffers[this.mIndex];
            int offset = (int)(ptr - this.mBufferPtr);
            assert (offset % vertexSize == 0);
            mesh.setVertexBuffer(buffer, offset / vertexSize, vertexCount);
            ByteBuffer writer = GpuBufferPool.getMappedBuffer(this.mCachedWriter, this.mBufferPtr, (int)buffer.getSize());
            writer.limit(offset + totalSize);
            writer.position(offset);
            this.mCachedWriter = writer;
            return writer;
        }
    }

    private static class InstancePool
    extends GpuBufferPool {
        public InstancePool(ResourceProvider resourceProvider) {
            super(resourceProvider, 1);
        }

        @Override
        public long makeSpace(Mesh mesh) {
            int instanceSize = mesh.getInstanceSize();
            int instanceCount = mesh.getInstanceCount();
            assert (instanceSize > 0 && instanceCount > 0);
            int totalSize = instanceSize * instanceCount;
            long ptr = this.makeSpace(totalSize, instanceSize);
            if (ptr == 0L) {
                return 0L;
            }
            Buffer buffer = this.mBuffers[this.mIndex];
            int offset = (int)(ptr - this.mBufferPtr);
            assert (offset % instanceSize == 0);
            mesh.setInstanceBuffer(buffer, offset / instanceSize, instanceCount);
            return ptr;
        }

        @Override
        @Nullable
        public ByteBuffer makeWriter(Mesh mesh) {
            int instanceSize = mesh.getInstanceSize();
            int instanceCount = mesh.getInstanceCount();
            assert (instanceSize > 0 && instanceCount > 0);
            int totalSize = instanceSize * instanceCount;
            long ptr = this.makeSpace(totalSize, instanceSize);
            if (ptr == 0L) {
                return null;
            }
            Buffer buffer = this.mBuffers[this.mIndex];
            int offset = (int)(ptr - this.mBufferPtr);
            assert (offset % instanceSize == 0);
            mesh.setInstanceBuffer(buffer, offset / instanceSize, instanceCount);
            ByteBuffer writer = GpuBufferPool.getMappedBuffer(this.mCachedWriter, this.mBufferPtr, (int)buffer.getSize());
            writer.limit(offset + totalSize);
            writer.position(offset);
            this.mCachedWriter = writer;
            return writer;
        }
    }

    private static class IndexPool
    extends GpuBufferPool {
        public IndexPool(ResourceProvider resourceProvider) {
            super(resourceProvider, 2);
        }

        @Override
        public long makeSpace(Mesh mesh) {
            int indexSize = 2;
            int indexCount = mesh.getIndexCount();
            assert (indexCount > 0);
            int totalSize = 2 * indexCount;
            long ptr = this.makeSpace(totalSize, 2);
            if (ptr == 0L) {
                return 0L;
            }
            Buffer buffer = this.mBuffers[this.mIndex];
            int offset = (int)(ptr - this.mBufferPtr);
            assert (offset % 2 == 0);
            mesh.setIndexBuffer(buffer, offset / 2, indexCount);
            return ptr;
        }

        @Override
        @Nullable
        public ByteBuffer makeWriter(Mesh mesh) {
            int indexSize = 2;
            int indexCount = mesh.getIndexCount();
            assert (indexCount > 0);
            int totalSize = 2 * indexCount;
            long ptr = this.makeSpace(totalSize, 2);
            if (ptr == 0L) {
                return null;
            }
            Buffer buffer = this.mBuffers[this.mIndex];
            int offset = (int)(ptr - this.mBufferPtr);
            assert (offset % 2 == 0);
            mesh.setIndexBuffer(buffer, offset / 2, indexCount);
            ByteBuffer writer = GpuBufferPool.getMappedBuffer(this.mCachedWriter, this.mBufferPtr, (int)buffer.getSize());
            writer.limit(offset + totalSize);
            writer.position(offset);
            this.mCachedWriter = writer;
            return writer;
        }
    }
}

