/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.MathUtil;

public interface ISurface {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_BUDGETED = 1;
    public static final int FLAG_APPROX_FIT = 2;
    public static final int FLAG_MIPMAPPED = 4;
    public static final int FLAG_SAMPLED_IMAGE = 8;
    public static final int FLAG_STORAGE_IMAGE = 16;
    public static final int FLAG_RENDERABLE = 32;
    public static final int FLAG_MEMORYLESS = 64;
    public static final int FLAG_PROTECTED = 128;
    @ApiStatus.Internal
    public static final int FLAG_READ_ONLY = 256;
    @ApiStatus.Internal
    public static final int FLAG_SKIP_ALLOCATOR = 512;
    @ApiStatus.Internal
    public static final int FLAG_DEFERRED_PROVIDER = 1024;

    public static int getApproxSize(int size) {
        int MIN_SCRATCH_IMAGE_SIZE = 16;
        if (MathUtil.isPow2(size = Math.max(16, size))) {
            return size;
        }
        int ceilPow2 = MathUtil.ceilPow2(size);
        if (size <= 1024) {
            return ceilPow2;
        }
        if (size <= 16384) {
            int floorPow2 = ceilPow2 >> 1;
            int mid = floorPow2 + (floorPow2 >> 1);
            if (size <= mid) {
                return mid;
            }
            return ceilPow2;
        }
        return MathUtil.alignTo(size, 4096);
    }
}

