/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.DataUtils;
import yslelf.cloudpick.render.engine.IResourceKey;
import yslelf.cloudpick.render.engine.ImageDesc;
import yslelf.cloudpick.render.engine.ImageMutableState;
import yslelf.cloudpick.render.engine.ReleaseCallback;
import yslelf.cloudpick.render.engine.Resource;

public abstract class Image
extends Resource {
    private final ImageDesc mDesc;
    private final ImageMutableState mMutableState;
    protected int mFlags;
    private boolean mMipmapsDirty;
    @SharedPtr
    private ReleaseCallback mReleaseCallback;

    protected Image(Context context, boolean budgeted, boolean wrapped, ImageDesc desc, ImageMutableState mutableState) {
        super(context, budgeted, wrapped, DataUtils.computeSize(desc));
        this.mDesc = desc;
        this.mMutableState = mutableState;
    }

    @Nonnull
    public final ImageDesc getDesc() {
        return this.mDesc;
    }

    public final ImageMutableState getMutableState() {
        return this.mMutableState;
    }

    public final int getImageType() {
        return this.mDesc.getImageType();
    }

    public final int getWidth() {
        return this.mDesc.mWidth;
    }

    public final int getHeight() {
        return this.mDesc.mHeight;
    }

    public final int getDepth() {
        return this.mDesc.mDepth;
    }

    public final int getArraySize() {
        return this.mDesc.mArraySize;
    }

    public int getDepthBits() {
        return this.mDesc.getDepthBits();
    }

    public int getStencilBits() {
        return this.mDesc.getStencilBits();
    }

    public final boolean isMipmapped() {
        return this.mDesc.isMipmapped();
    }

    public final boolean isSampledImage() {
        return this.mDesc.isSampledImage();
    }

    public final boolean isStorageImage() {
        return this.mDesc.isStorageImage();
    }

    public final boolean isRenderable() {
        return this.mDesc.isRenderable();
    }

    public final int getMipLevelCount() {
        return this.mDesc.mMipLevelCount;
    }

    public final int getSampleCount() {
        return this.mDesc.mSampleCount;
    }

    public final boolean isReadOnly() {
        return (this.mFlags & 0x100) != 0;
    }

    public final boolean isProtected() {
        return this.mDesc.isProtected();
    }

    @Deprecated
    final int getSurfaceFlags() {
        int flags = this.mFlags;
        if (this.isBudgeted()) {
            flags |= 1;
        }
        return flags;
    }

    public final boolean isMipmapsDirty() {
        assert (this.isMipmapped());
        return this.mMipmapsDirty && this.isMipmapped();
    }

    public final void setMipmapsDirty(boolean mipmapsDirty) {
        assert (this.isMipmapped());
        this.mMipmapsDirty = mipmapsDirty;
    }

    public void setReleaseCallback(@SharedPtr ReleaseCallback callback) {
        this.mReleaseCallback = RefCnt.move(this.mReleaseCallback, callback);
    }

    @Override
    protected void onRelease() {
        if (this.mReleaseCallback != null) {
            this.mReleaseCallback.unref();
        }
        this.mReleaseCallback = null;
    }

    public static final class ResourceKey
    implements IResourceKey {
        public int mWidth;
        public int mHeight;
        public int mFormat;
        public int mFlags;

        @Nonnull
        public ResourceKey compute(BackendFormat format, int width, int height, int sampleCount, int surfaceFlags) {
            assert (width > 0 && height > 0);
            assert (!format.isCompressed());
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format.getFormatKey();
            this.mFlags = surfaceFlags & 0xEC | sampleCount << 16;
            return this;
        }

        @Override
        public IResourceKey copy() {
            return null;
        }

        @Override
        public int hashCode() {
            int result = this.mWidth;
            result = 31 * result + this.mHeight;
            result = 31 * result + this.mFormat;
            result = 31 * result + this.mFlags;
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResourceKey)) return false;
            ResourceKey key = (ResourceKey)o;
            if (this.mWidth != key.mWidth) return false;
            if (this.mHeight != key.mHeight) return false;
            if (this.mFormat != key.mFormat) return false;
            if (this.mFlags != key.mFlags) return false;
            return true;
        }
    }
}

