/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.Swizzle;

public class ImageProxyView
implements AutoCloseable {
    @SharedPtr
    ImageViewProxy mProxy;
    int mOrigin;
    short mSwizzle;

    public ImageProxyView(@SharedPtr ImageViewProxy proxy) {
        this.mProxy = proxy;
        this.mOrigin = 0;
        this.mSwizzle = (short)12816;
    }

    public ImageProxyView(@SharedPtr ImageViewProxy proxy, int origin, short swizzle) {
        this.mProxy = proxy;
        this.mOrigin = origin;
        this.mSwizzle = swizzle;
    }

    public int getWidth() {
        return this.mProxy.getWidth();
    }

    public int getHeight() {
        return this.mProxy.getHeight();
    }

    public boolean isMipmapped() {
        return this.mProxy.isMipmapped();
    }

    @RawPtr
    public ImageViewProxy getProxy() {
        return this.mProxy;
    }

    @SharedPtr
    public ImageViewProxy refProxy() {
        this.mProxy.ref();
        return this.mProxy;
    }

    @SharedPtr
    public ImageViewProxy detachProxy() {
        ImageViewProxy surfaceProxy = this.mProxy;
        this.mProxy = null;
        return surfaceProxy;
    }

    public int getOrigin() {
        return this.mOrigin;
    }

    public short getSwizzle() {
        return this.mSwizzle;
    }

    public void concat(short swizzle) {
        this.mSwizzle = Swizzle.concat(this.mSwizzle, swizzle);
    }

    public void reset() {
        if (this.mProxy != null) {
            this.mProxy.unref();
        }
        this.mProxy = null;
        this.mOrigin = 0;
        this.mSwizzle = (short)12816;
    }

    @Override
    public void close() {
        if (this.mProxy != null) {
            this.mProxy.unref();
        }
        this.mProxy = null;
    }
}

