/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Arrays;
import javax.annotation.Nonnull;
import yslelf.cloudpick.render.engine.Key;

public class KeyBuilder
extends Key {
    private int mSize;
    private transient int mCurValue = 0;
    private transient int mBitsUsed = 0;

    public KeyBuilder() {
    }

    public KeyBuilder(@Nonnull KeyBuilder other) {
        assert (other.mCurValue == 0 && other.mBitsUsed == 0);
        int size = other.mSize;
        this.mData = size == 0 ? IntArrays.EMPTY_ARRAY : Arrays.copyOf(other.mData, size);
        this.mSize = size;
    }

    public final void clear() {
        assert (this.mCurValue == 0 && this.mBitsUsed == 0);
        this.mSize = 0;
    }

    @Override
    public final int size() {
        assert (this.mCurValue == 0 && this.mBitsUsed == 0);
        return this.mSize;
    }

    @Override
    public final boolean isEmpty() {
        assert (this.mCurValue == 0 && this.mBitsUsed == 0);
        return this.mSize == 0;
    }

    private void grow(int capacity) {
        if (capacity > this.mData.length) {
            if (this.mData != IntArrays.DEFAULT_EMPTY_ARRAY) {
                capacity = (int)Math.max(Math.min((long)this.mData.length + (long)(this.mData.length >> 1), 0x7FFFFFF7L), (long)capacity);
            } else if (capacity < 10) {
                capacity = 10;
            }
            this.mData = IntArrays.forceCapacity((int[])this.mData, (int)capacity, (int)this.mSize);
        }
    }

    private void add(int k) {
        this.grow(this.mSize + 1);
        this.mData[this.mSize++] = k;
    }

    public void addBits(int numBits, int value, String label) {
        assert (numBits > 0 && numBits <= 32);
        assert (numBits == 32 || 32 - numBits <= Integer.numberOfLeadingZeros(value));
        this.mCurValue |= value << this.mBitsUsed;
        this.mBitsUsed += numBits;
        if (this.mBitsUsed >= 32) {
            this.add(this.mCurValue);
            int excess = this.mBitsUsed - 32;
            this.mCurValue = excess != 0 ? value >>> numBits - excess : 0;
            this.mBitsUsed = excess;
        }
        assert (32 - this.mBitsUsed <= Integer.numberOfLeadingZeros(this.mCurValue));
    }

    public final void addBool(boolean b, String label) {
        this.addBits(1, b ? 1 : 0, label);
    }

    public final void addInt32(int v, String label) {
        this.addBits(32, v, label);
    }

    public final void addInt(int v) {
        this.flush();
        this.add(v);
    }

    public final void addInts(int[] v, int off, int len) {
        this.flush();
        this.grow(this.mSize + len);
        System.arraycopy(v, off, this.mData, this.mSize, len);
        this.mSize += len;
    }

    public final void flush() {
        if (this.mBitsUsed != 0) {
            this.add(this.mCurValue);
            this.mCurValue = 0;
            this.mBitsUsed = 0;
        }
    }

    public final void trim() {
        assert (this.mCurValue == 0 && this.mBitsUsed == 0);
        if (0 < this.mData.length && this.mSize != this.mData.length) {
            int[] t2 = new int[this.mSize];
            System.arraycopy(this.mData, 0, t2, 0, this.mSize);
            this.mData = t2;
        }
    }

    public final Key toStorageKey() {
        assert (this.mCurValue == 0 && this.mBitsUsed == 0);
        if (this.mSize == 0) {
            return Key.EMPTY;
        }
        int[] t2 = new int[this.mSize];
        System.arraycopy(this.mData, 0, t2, 0, this.mSize);
        return new Key(t2);
    }

    @Override
    public final int hashCode() {
        assert (this.mCurValue == 0 && this.mBitsUsed == 0);
        int[] e = this.mData;
        int h2 = 1;
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            h2 = 31 * h2 + e[i];
        }
        return h2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object o) {
        if (!$assertionsDisabled) {
            if (this.mCurValue != 0) throw new AssertionError();
            if (this.mBitsUsed != 0) {
                throw new AssertionError();
            }
        }
        if (!(o instanceof Key)) return false;
        Key key = (Key)o;
        if (!Arrays.equals(this.mData, 0, this.mSize, key.mData, 0, key.mData.length)) return false;
        return true;
    }
}

