/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.Device;
import yslelf.cloudpick.render.engine.GpuRenderTarget;
import yslelf.cloudpick.render.engine.GraphicsPipeline;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.trash.GraphicsPipelineDesc_Old;

@Deprecated
public abstract class OpsRenderPass {
    private static final int kConfigured_DrawPipelineStatus = 0;
    private static final int kNotConfigured_DrawPipelineStatus = 1;
    private static final int kFailedToBind_DrawPipelineStatus = 2;
    private int mDrawPipelineStatus = 1;
    protected GpuRenderTarget mRenderTarget;
    protected int mSurfaceOrigin;
    private ImageViewProxy[] mGeomTextures = new ImageViewProxy[1];

    public OpsRenderPass() {
        this(null, 0);
    }

    public OpsRenderPass(GpuRenderTarget fs, int origin) {
        this.mRenderTarget = fs;
        this.mSurfaceOrigin = origin;
    }

    public void begin() {
        this.mDrawPipelineStatus = 1;
    }

    public void end() {
    }

    public void clearColor(int left, int top, int right, int bottom, float red, float green, float blue, float alpha) {
        assert (this.mRenderTarget != null);
        this.mDrawPipelineStatus = 1;
    }

    public void clearStencil(int left, int top, int right, int bottom, boolean insideMask) {
        assert (this.mRenderTarget != null);
        this.mDrawPipelineStatus = 1;
    }

    public void bindPipeline(GraphicsPipelineDesc_Old graphicsPipelineDesc, GraphicsPipeline pipeline, Rect2fc drawBounds) {
        assert (graphicsPipelineDesc.origin() == this.mSurfaceOrigin);
        if (!this.onBindPipeline(graphicsPipelineDesc, pipeline, drawBounds)) {
            this.mDrawPipelineStatus = 2;
            return;
        }
        this.mDrawPipelineStatus = 0;
    }

    public final void bindTexture(@RawPtr ImageViewProxy geomTexture) {
        this.mGeomTextures[0] = geomTexture;
        this.bindTextures(this.mGeomTextures);
        this.mGeomTextures[0] = null;
    }

    public final void bindTextures(@RawPtr ImageViewProxy[] geomTextures) {
    }

    public final void bindBuffers(@RawPtr Buffer indexBuffer, int indexType, @RawPtr Buffer vertexBuffer, int vertexStreamOffset, @RawPtr Buffer instanceBuffer, int instanceStreamOffset) {
        if (vertexBuffer == null && instanceBuffer == null) {
            this.mDrawPipelineStatus = 2;
            return;
        }
        if (this.mDrawPipelineStatus == 0) {
            this.onBindBuffers(indexBuffer, indexType, vertexBuffer, vertexStreamOffset, instanceBuffer, instanceStreamOffset);
        } else assert (this.mDrawPipelineStatus == 2);
    }

    public final void draw(int vertexCount, int baseVertex) {
        if (this.mDrawPipelineStatus == 0) {
            this.onDraw(vertexCount, baseVertex);
            this.getDevice().getStats().incNumDraws();
        } else {
            assert (this.mDrawPipelineStatus == 2);
            this.getDevice().getStats().incNumFailedDraws();
        }
    }

    public final void drawIndexed(int indexCount, int baseIndex, int baseVertex) {
        if (this.mDrawPipelineStatus == 0) {
            this.onDrawIndexed(indexCount, baseIndex, baseVertex);
            this.getDevice().getStats().incNumDraws();
        } else {
            assert (this.mDrawPipelineStatus == 2);
            this.getDevice().getStats().incNumFailedDraws();
        }
    }

    public final void drawInstanced(int instanceCount, int baseInstance, int vertexCount, int baseVertex) {
        if (this.mDrawPipelineStatus == 0) {
            this.onDrawInstanced(instanceCount, baseInstance, vertexCount, baseVertex);
            this.getDevice().getStats().incNumDraws();
        } else {
            assert (this.mDrawPipelineStatus == 2);
            this.getDevice().getStats().incNumFailedDraws();
        }
    }

    public final void drawIndexedInstanced(int indexCount, int baseIndex, int instanceCount, int baseInstance, int baseVertex) {
        if (this.mDrawPipelineStatus == 0) {
            this.onDrawIndexedInstanced(indexCount, baseIndex, instanceCount, baseInstance, baseVertex);
            this.getDevice().getStats().incNumDraws();
        } else {
            assert (this.mDrawPipelineStatus == 2);
            this.getDevice().getStats().incNumFailedDraws();
        }
    }

    protected void set(GpuRenderTarget renderTarget, int origin) {
        assert (this.mRenderTarget == null);
        this.mRenderTarget = renderTarget;
        this.mSurfaceOrigin = origin;
    }

    protected abstract Device getDevice();

    protected abstract boolean onBindPipeline(GraphicsPipelineDesc_Old var1, GraphicsPipeline var2, Rect2fc var3);

    protected abstract void onBindBuffers(@SharedPtr Buffer var1, int var2, @SharedPtr Buffer var3, int var4, @SharedPtr Buffer var5, int var6);

    protected abstract void onDraw(int var1, int var2);

    protected abstract void onDrawIndexed(int var1, int var2, int var3);

    protected abstract void onDrawInstanced(int var1, int var2, int var3, int var4);

    protected abstract void onDrawIndexedInstanced(int var1, int var2, int var3, int var4, int var5);
}

