/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import yslelf.cloudpick.render.engine.BlendInfo;
import yslelf.cloudpick.render.engine.DepthStencilSettings;
import yslelf.cloudpick.render.engine.Device;
import yslelf.cloudpick.render.engine.VertexInputLayout;

public abstract class PipelineDesc {
    public static final int NO_DYNAMIC_STATE = 0;
    public static final int DYNAMIC_COLOR_BLEND_STATE = 1;

    public GraphicsPipelineInfo createGraphicsPipelineInfo(Device device) {
        throw new IllegalStateException();
    }

    public byte getPrimitiveType() {
        return 0;
    }

    public BlendInfo getBlendInfo() {
        return null;
    }

    public DepthStencilSettings getDepthStencilSettings() {
        return null;
    }

    public int getDynamicStates() {
        return 0;
    }

    public abstract PipelineDesc copy();

    public static final class GraphicsPipelineInfo {
        public byte mPrimitiveType;
        public VertexInputLayout mInputLayout;
        public String mInputLayoutLabel;
        public StringBuilder mVertSource;
        public String mVertLabel;
        public StringBuilder mFragSource;
        public String mFragLabel;
        public BlendInfo mBlendInfo;
        public DepthStencilSettings mDepthStencilSettings;
        public UniformBlockInfo[] mUniformBlockInfos;
        public SamplerInfo[] mSamplerInfos;
        public String mPipelineLabel;
    }

    public static final class SamplerInfo {
        public final int mVisibility;
        public final int mBinding;
        public final String mName;

        public SamplerInfo(int visibility, int binding, String name) {
            this.mVisibility = visibility;
            this.mBinding = binding;
            this.mName = name;
        }
    }

    public static final class UniformBlockInfo {
        public final int mVisibility;
        public final int mBinding;
        public final String mBlockName;

        public UniformBlockInfo(int visibility, int binding, String blockName) {
            this.mVisibility = visibility;
            this.mBinding = binding;
            this.mBlockName = blockName;
        }
    }
}

