/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.Device;
import yslelf.cloudpick.render.engine.Engine;
import yslelf.cloudpick.render.engine.ImageProxyCache;
import yslelf.cloudpick.render.engine.RecordingContextOptions;
import yslelf.cloudpick.render.engine.RenderTaskManager;
import yslelf.cloudpick.render.engine.Resource;
import yslelf.cloudpick.render.engine.UploadBufferManager;
import yslelf.cloudpick.render.engine.task.Task;
import yslelf.cloudpick.render.engine.task.TaskList;
import yslelf.cloudpick.render.granite.AtlasProvider;
import yslelf.cloudpick.render.granite.DrawAtlas;
import yslelf.cloudpick.render.granite.DrawBufferManager;
import yslelf.cloudpick.render.granite.GlyphStrikeCache;
import yslelf.cloudpick.render.granite.GraniteDevice;
import yslelf.cloudpick.render.granite.RootTask;
import yslelf.cloudpick.render.granite.TextBlobCache;

public final class RecordingContext
extends Context {
    private final ImageProxyCache mImageProxyCache;
    private RenderTaskManager mRenderTaskManager;
    private DrawBufferManager mDrawBufferManager;
    private UploadBufferManager mUploadBufferManager;
    private final TaskList mRootTaskList;
    private final AtlasProvider mAtlasProvider;
    private final DrawAtlas.AtlasTokenTracker mAtlasTokenTracker;
    private final GlyphStrikeCache mGlyphStrikeCache;
    private final TextBlobCache mTextBlobCache;
    private final ReferenceArrayList<@SharedPtr GraniteDevice> mTrackedDevices = new ReferenceArrayList();

    protected RecordingContext(Device device) {
        super(device);
        this.mImageProxyCache = new ImageProxyCache(this);
        this.mRootTaskList = new TaskList();
        this.mAtlasProvider = new AtlasProvider(this);
        this.mAtlasTokenTracker = new DrawAtlas.AtlasTokenTracker();
        this.mGlyphStrikeCache = new GlyphStrikeCache();
        this.mTextBlobCache = new TextBlobCache();
    }

    @Override
    public void freeGpuResources() {
        this.checkOwnerThread();
        this.mAtlasProvider.freeGpuResources();
        this.mResourceProvider.freeGpuResources();
        this.mGlyphStrikeCache.clear();
    }

    @Override
    public void performDeferredCleanup(long msNotUsed) {
        this.checkOwnerThread();
        long timeMillis = System.currentTimeMillis() - msNotUsed;
        this.mResourceProvider.purgeResourcesNotUsedSince(timeMillis);
    }

    public void clearStrikeCache() {
        this.mGlyphStrikeCache.clear();
    }

    public boolean isDiscarded() {
        return this.mDevice.isDiscarded();
    }

    public final boolean isImageCompatible(int colorType) {
        return this.getDefaultBackendFormat(colorType, false) != null;
    }

    public final boolean isSurfaceCompatible(int colorType) {
        if (13 == (colorType = Engine.colorTypeToPublic(colorType)) || 20 == colorType || 21 == colorType || 14 == colorType || 15 == colorType || 22 == colorType) {
            return false;
        }
        return this.getMaxSurfaceSampleCount(colorType) > 0;
    }

    @ApiStatus.Internal
    public final ImageProxyCache getSurfaceProvider() {
        return this.mImageProxyCache;
    }

    @ApiStatus.Internal
    public final RenderTaskManager getRenderTaskManager() {
        return this.mRenderTaskManager;
    }

    @ApiStatus.Internal
    public final DrawBufferManager getDynamicBufferManager() {
        return this.mDrawBufferManager;
    }

    @ApiStatus.Internal
    public UploadBufferManager getUploadBufferManager() {
        return this.mUploadBufferManager;
    }

    @ApiStatus.Internal
    public AtlasProvider getAtlasProvider() {
        return this.mAtlasProvider;
    }

    @ApiStatus.Internal
    public DrawAtlas.AtlasTokenTracker getAtlasTokenTracker() {
        return this.mAtlasTokenTracker;
    }

    @ApiStatus.Internal
    public GlyphStrikeCache getGlyphStrikeCache() {
        return this.mGlyphStrikeCache;
    }

    @ApiStatus.Internal
    public TextBlobCache getTextBlobCache() {
        return this.mTextBlobCache;
    }

    public void trackDevice(@SharedPtr GraniteDevice device) {
        assert (this.isOwnerThread());
        assert (device != null);
        this.mTrackedDevices.add((Object)device);
    }

    public void untrackDevice(@RawPtr GraniteDevice device) {
        assert (this.isOwnerThread());
        int index = this.mTrackedDevices.indexOf((Object)device);
        if (index >= 0) {
            RefCnt.move((GraniteDevice)this.mTrackedDevices.set(index, null));
        }
    }

    public void addTask(@SharedPtr Task task) {
        this.mRootTaskList.appendTask(task);
    }

    public RootTask snap() {
        assert (this.isOwnerThread());
        this.flushTrackedDevices();
        if (this.mDrawBufferManager.hasMappingFailed() || this.mRootTaskList.prepare(this) == 1) {
            this.mAtlasProvider.invalidateAtlases();
            this.mRootTaskList.clear();
            return null;
        }
        ObjectArrayList extraResourceRefs = new ObjectArrayList();
        TaskList finalTaskList = new TaskList();
        this.mDrawBufferManager.flush(finalTaskList, (List<Resource>)extraResourceRefs);
        this.mUploadBufferManager.flush((List<Resource>)extraResourceRefs);
        finalTaskList.appendTasks(this.mRootTaskList);
        RootTask recording = new RootTask(finalTaskList, (ObjectArrayList<Resource>)extraResourceRefs);
        this.mRootTaskList.clear();
        return recording;
    }

    @ApiStatus.Internal
    public void flushTrackedDevices() {
        assert (this.isOwnerThread());
        int index = -1;
        while (index < this.mTrackedDevices.size() - 1) {
            GraniteDevice device;
            if ((device = (GraniteDevice)this.mTrackedDevices.get(++index)) == null) continue;
            device.flushPendingWork();
        }
        this.mAtlasTokenTracker.issueFlushToken();
        ObjectListIterator it = this.mTrackedDevices.listIterator();
        while (it.hasNext()) {
            @RawPtr GraniteDevice device = (GraniteDevice)it.next();
            if (device != null && device.getRecordingContext() != null && !device.unique()) continue;
            if (device != null) {
                device.discardRC();
                device.unref();
            }
            it.remove();
        }
    }

    public boolean init(RecordingContextOptions options) {
        if (!super.init(options)) {
            return false;
        }
        if (this.mRenderTaskManager != null) {
            this.mRenderTaskManager.destroy();
        }
        this.mRenderTaskManager = new RenderTaskManager(this);
        this.mDrawBufferManager = new DrawBufferManager(this.getCaps(), this.getResourceProvider());
        this.mUploadBufferManager = new UploadBufferManager(this.getResourceProvider());
        return true;
    }

    protected void discard() {
        if (this.mDevice.discard() && this.mRenderTaskManager != null) {
            throw new AssertionError();
        }
        if (this.mRenderTaskManager != null) {
            this.mRenderTaskManager.destroy();
        }
        this.mRenderTaskManager = null;
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        if (this.mRenderTaskManager != null) {
            this.mRenderTaskManager.destroy();
        }
        this.mRenderTaskManager = null;
        this.mAtlasProvider.close();
        this.mRootTaskList.close();
    }
}

