/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.UniqueID;
import yslelf.cloudpick.render.engine.Device;
import yslelf.cloudpick.render.engine.FlushInfo;
import yslelf.cloudpick.render.engine.ImageProxyView;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.engine.OpFlushState;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.RenderTask;
import yslelf.cloudpick.render.engine.SurfaceAllocator;
import yslelf.cloudpick.render.engine.SurfaceProxy;
import yslelf.cloudpick.render.engine.TopologicalSort;
import yslelf.cloudpick.render.engine.trash.ops.OpsTask;

@Deprecated
public class RenderTaskManager {
    private final RecordingContext mContext;
    private final ImmediateContext mDirect;
    @SharedPtr
    private final ArrayList<RenderTask> mDAG = new ArrayList();
    private final Reference2ObjectOpenHashMap<UniqueID, RenderTask> mLastRenderTasks = new Reference2ObjectOpenHashMap();
    private OpsTask mActiveOpsTask = null;
    private final OpFlushState mFlushState;
    private final SurfaceAllocator mSurfaceAllocator;
    private boolean mFlushing;

    public RenderTaskManager(RecordingContext context) {
        this.mContext = context;
        this.mDirect = null;
        this.mFlushState = null;
        this.mSurfaceAllocator = null;
    }

    void destroy() {
        this.closeTasks();
        this.clearTasks();
    }

    RecordingContext getContext() {
        return this.mContext;
    }

    public OpFlushState getFlushState() {
        return this.mFlushState;
    }

    public boolean flush(FlushInfo info) {
        if (this.mFlushing || this.mContext.isDiscarded()) {
            if (info != null) {
                if (info.mSubmittedCallback != null) {
                    info.mSubmittedCallback.onSubmitted(false);
                }
                if (info.mFinishedCallback != null) {
                    info.mFinishedCallback.onFinished(false);
                }
            }
            return false;
        }
        this.mFlushing = true;
        ImmediateContext context = this.mDirect;
        assert (context != null);
        Device device = context.getDevice();
        assert (device != null);
        this.closeTasks();
        this.mActiveOpsTask = null;
        TopologicalSort.topologicalSort(this.mDAG, RenderTask.SORT_ACCESS);
        for (RenderTask task : this.mDAG) {
            task.gatherSurfaceIntervals(this.mSurfaceAllocator);
        }
        this.mSurfaceAllocator.simulate();
        this.mSurfaceAllocator.allocate();
        boolean cleanup = false;
        if (!this.mSurfaceAllocator.isInstantiationFailed()) {
            cleanup = this.executeRenderTasks();
        }
        this.mSurfaceAllocator.reset();
        this.clearTasks();
        if (cleanup) {
            // empty if block
        }
        this.mFlushing = false;
        return true;
    }

    public void closeTasks() {
        for (RenderTask task : this.mDAG) {
            task.makeClosed(this.mContext);
        }
    }

    public void clearTasks() {
        for (RenderTask task : this.mDAG) {
            task.detach(this);
            task.unref();
        }
        this.mDAG.clear();
        this.mLastRenderTasks.clear();
    }

    public RenderTask appendTask(@SharedPtr RenderTask task) {
        this.mDAG.add(RefCnt.create(task));
        return task;
    }

    public RenderTask prependTask(@SharedPtr RenderTask task) {
        if (this.mDAG.isEmpty()) {
            this.mDAG.add(task);
        } else {
            int pos = this.mDAG.size() - 1;
            this.mDAG.add(this.mDAG.get(pos));
            this.mDAG.set(pos, task);
        }
        return task;
    }

    public void setLastRenderTask(@Nonnull SurfaceProxy surfaceProxy, @Nullable RenderTask task) {
        UniqueID key = surfaceProxy.getUniqueID();
        if (task != null) {
            this.mLastRenderTasks.put((Object)key, (Object)task);
        } else {
            this.mLastRenderTasks.remove((Object)key);
        }
    }

    public RenderTask getLastRenderTask(@Nonnull SurfaceProxy proxy) {
        return (RenderTask)this.mLastRenderTasks.get((Object)proxy.getUniqueID());
    }

    @SharedPtr
    public OpsTask newOpsTask(ImageProxyView writeView) {
        OpsTask opsTask = new OpsTask(this, writeView);
        this.appendTask(opsTask);
        return opsTask;
    }

    private boolean executeRenderTasks() {
        boolean executed = false;
        for (RenderTask task : this.mDAG) {
            if (!task.isInstantiated()) continue;
            task.prepare(this.mFlushState);
        }
        for (RenderTask task : this.mDAG) {
            if (!task.isInstantiated()) continue;
            executed |= task.execute(this.mFlushState);
        }
        this.mFlushState.reset();
        return executed;
    }
}

