/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Comparator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.RefCounted;
import yslelf.cloudpick.render.core.UniqueID;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.Device;
import yslelf.cloudpick.render.engine.IResourceKey;
import yslelf.cloudpick.render.engine.PriorityQueue;
import yslelf.cloudpick.render.engine.ResourceCache;

@NotThreadSafe
public abstract class Resource
implements RefCounted {
    private static final VarHandle USAGE_REF_CNT;
    private static final VarHandle COMMAND_BUFFER_REF_CNT;
    private static final VarHandle CACHE_REF_CNT;
    private static final ConcurrentMap<Resource, Boolean> TRACKER;
    static final int REF_TYPE_USAGE = 0;
    static final int REF_TYPE_COMMAND_BUFFER = 1;
    static final int REF_TYPE_CACHE = 2;
    private volatile int mUsageRefCnt = 1;
    private volatile int mCommandBufferRefCnt = 0;
    private volatile int mCacheRefCnt = 0;
    static final PriorityQueue.Access<Resource> QUEUE_ACCESS;
    volatile Context mContext;
    volatile IResourceKey mKey;
    volatile ResourceCache mReturnCache;
    volatile int mReturnIndex = -1;
    int mCacheIndex = -1;
    int mTimestamp;
    private long mLastUsedTime;
    private volatile boolean mBudgeted;
    private final boolean mWrapped;
    private volatile boolean mCacheable = true;
    boolean mNonShareableInCache = false;
    private final long mMemorySize;
    @Nonnull
    private volatile String mLabel = "";
    private final UniqueID mUniqueID = new UniqueID();

    protected Resource(Context context, boolean budgeted, boolean wrapped, long memorySize) {
        assert (context != null);
        assert (!budgeted || !wrapped);
        this.mContext = context;
        this.mBudgeted = budgeted;
        this.mWrapped = wrapped;
        this.mMemorySize = memorySize;
        assert (TRACKER.put(this, Boolean.TRUE) == null);
    }

    @Override
    public final void ref() {
        assert (this.hasUsageRef());
        USAGE_REF_CNT.getAndAddRelease(this, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unref() {
        boolean shouldRelease = false;
        Resource resource = this;
        synchronized (resource) {
            assert (this.hasUsageRef());
            if (USAGE_REF_CNT.getAndAdd(this, -1) == 1) {
                shouldRelease = this.notifyACntReachedZero(0);
            }
        }
        if (shouldRelease) {
            this.release();
        }
    }

    public final void refCommandBuffer() {
        COMMAND_BUFFER_REF_CNT.getAndAddRelease(this, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unrefCommandBuffer() {
        boolean shouldRelease = false;
        Resource resource = this;
        synchronized (resource) {
            assert (this.hasCommandBufferRef());
            if (COMMAND_BUFFER_REF_CNT.getAndAdd(this, -1) == 1) {
                shouldRelease = this.notifyACntReachedZero(1);
            }
        }
        if (shouldRelease) {
            this.release();
        }
    }

    final void refCache() {
        CACHE_REF_CNT.getAndAddRelease(this, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unrefCache() {
        boolean shouldRelease = false;
        Resource resource = this;
        synchronized (resource) {
            assert (this.hasCacheRef());
            if (CACHE_REF_CNT.getAndAdd(this, -1) == 1) {
                shouldRelease = this.notifyACntReachedZero(2);
            }
        }
        if (shouldRelease) {
            this.release();
        }
    }

    protected final boolean hasUsageRef() {
        return USAGE_REF_CNT.getAcquire(this) > 0;
    }

    protected final boolean hasCommandBufferRef() {
        return COMMAND_BUFFER_REF_CNT.getAcquire(this) > 0;
    }

    protected final boolean hasCacheRef() {
        return CACHE_REF_CNT.getAcquire(this) > 0;
    }

    final void addInitialUsageRef() {
        USAGE_REF_CNT.getAndAddRelease(this, 1);
    }

    @GuardedBy(value="this")
    private boolean notifyACntReachedZero(int refCntType) {
        assert (!this.isDestroyed());
        if (refCntType != 2 && this.mReturnCache != null && this.mReturnCache.returnResource(this, refCntType)) {
            return false;
        }
        return !this.hasAnyRefs();
    }

    public final boolean isDestroyed() {
        return this.mContext == null;
    }

    @Nullable
    public final Context getContext() {
        return this.mContext;
    }

    public final long getMemorySize() {
        return this.mMemorySize;
    }

    public final boolean isBudgeted() {
        return this.mBudgeted;
    }

    @Nonnull
    public UniqueID getUniqueID() {
        return this.mUniqueID;
    }

    @Nonnull
    public final String getLabel() {
        return this.mLabel;
    }

    public final void setLabel(@Nullable String label) {
        String string = label = label != null ? label.trim() : "";
        if (!this.mLabel.equals(label)) {
            this.mLabel = label;
            this.onSetLabel(!label.isEmpty() ? label : null);
        }
    }

    @ApiStatus.Internal
    final void makeBudgeted(boolean budgeted) {
        this.mBudgeted = budgeted;
    }

    @ApiStatus.Internal
    public final boolean isWrapped() {
        return this.mWrapped;
    }

    @ApiStatus.Internal
    public final IResourceKey getKey() {
        return this.mKey;
    }

    @ApiStatus.Internal
    public final void setKey(@Nonnull IResourceKey key) {
        assert (!key.isShareable() || this.mBudgeted);
        this.mKey = key;
    }

    @ApiStatus.Internal
    public final boolean isPurgeable() {
        return !this.hasUsageRef() && !this.hasCommandBufferRef();
    }

    @ApiStatus.Internal
    public final boolean hasAnyRefs() {
        return this.hasUsageRef() || this.hasCommandBufferRef() || this.hasCacheRef();
    }

    protected final void setNonCacheable() {
        this.mCacheable = false;
    }

    final boolean isCacheable() {
        return this.mCacheable;
    }

    final void registerWithCache(ResourceCache returnCache) {
        assert (this.mReturnCache == null);
        assert (returnCache != null);
        this.mReturnCache = returnCache;
    }

    protected Device getDevice() {
        return this.mContext.getDevice();
    }

    protected abstract void onRelease();

    protected void onSetLabel(@Nullable String label) {
    }

    final boolean isUsableAsScratch() {
        return !this.mKey.isShareable() && !this.hasUsageRef() && this.mNonShareableInCache;
    }

    private void release() {
        assert (this.mContext != null);
        this.onRelease();
        this.mContext = null;
        assert (TRACKER.remove(this) == Boolean.TRUE);
    }

    final void setLastUsedTime() {
        this.mLastUsedTime = System.currentTimeMillis();
    }

    final long getLastUsedTime() {
        assert (this.isPurgeable());
        return this.mLastUsedTime;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            USAGE_REF_CNT = lookup.findVarHandle(Resource.class, "mUsageRefCnt", Integer.TYPE);
            COMMAND_BUFFER_REF_CNT = lookup.findVarHandle(Resource.class, "mCommandBufferRefCnt", Integer.TYPE);
            CACHE_REF_CNT = lookup.findVarHandle(Resource.class, "mCacheRefCnt", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        TRACKER = new ConcurrentSkipListMap<Resource, Boolean>(Comparator.comparingInt(System::identityHashCode));
        try {
            assert (false);
        }
        catch (AssertionError e) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                TRACKER.forEach((o, __) -> System.err.printf("UsageRefCnt %d, CommandBufferRefCnt %d, CacheRefCnt %d: %s%n", o.mUsageRefCnt, o.mCommandBufferRefCnt, o.mCacheRefCnt, o));
                assert (TRACKER.isEmpty()) : "Memory leaks in GPU resources";
            }, "Resource-Tracker"));
        }
        QUEUE_ACCESS = new PriorityQueue.Access<Resource>(){

            @Override
            public void setIndex(Resource resource, int index) {
                resource.mCacheIndex = index;
            }

            @Override
            public int getIndex(Resource resource) {
                return resource.mCacheIndex;
            }
        };
    }
}

