/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.jetbrains.annotations.VisibleForTesting;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.IResourceKey;
import yslelf.cloudpick.render.engine.ImageProxyCache;
import yslelf.cloudpick.render.engine.LinkedListMultimap;
import yslelf.cloudpick.render.engine.PriorityQueue;
import yslelf.cloudpick.render.engine.Resource;
import yslelf.cloudpick.render.engine.ThreadSafeCache;

@NotThreadSafe
public final class ResourceCache {
    private static final Comparator<Resource> TIMESTAMP_COMPARATOR = (lhs, rhs) -> Integer.compareUnsigned(lhs.mTimestamp, rhs.mTimestamp);
    private ImageProxyCache mImageProxyCache = null;
    private ThreadSafeCache mThreadSafeCache = null;
    private final Context mContext;
    private int mTimestamp = 0;
    private static final int MAX_TIMESTAMP = -1;
    private final PriorityQueue<Resource> mPurgeableQueue;
    private Resource[] mNonPurgeableList;
    private int mNonPurgeableSize = 0;
    private final LinkedListMultimap<IResourceKey, Resource> mResourceMap;
    private final Object mReturnLock = new Object();
    @GuardedBy(value="mReturnLock")
    private Resource[] mReturnQueue;
    @GuardedBy(value="mReturnLock")
    private int[] mReturnQueueRefTypes;
    @GuardedBy(value="mReturnLock")
    private int mReturnQueueSize = 0;
    private long mMaxBytes;
    private int mBudgetedCount = 0;
    private long mBudgetedBytes = 0L;
    private long mPurgeableBytes = 0L;
    @GuardedBy(value="mReturnLock")
    private boolean mShutdown = false;

    ResourceCache(Context context, long maxBytes) {
        this.mContext = context;
        this.mMaxBytes = maxBytes;
        this.mPurgeableQueue = new PriorityQueue<Resource>(TIMESTAMP_COMPARATOR, Resource.QUEUE_ACCESS);
        this.mNonPurgeableList = new Resource[10];
        this.mReturnQueue = new Resource[10];
        this.mReturnQueueRefTypes = new int[10];
        this.mResourceMap = new LinkedListMultimap();
    }

    @VisibleForTesting
    public void setMaxBudget(long maxBytes) {
        this.mMaxBytes = maxBytes;
        this.processReturnedResources();
        this.purgeAsNeeded();
    }

    public int getResourceCount() {
        return this.mPurgeableQueue.size() + this.mNonPurgeableSize;
    }

    public int getBudgetedResourceCount() {
        return this.mBudgetedCount;
    }

    public long getBudgetedBytes() {
        return this.mBudgetedBytes;
    }

    public long getPurgeableBytes() {
        return this.mPurgeableBytes;
    }

    public long getMaxBudget() {
        return this.mMaxBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        assert (this.mContext.isOwnerThread());
        assert (!this.mShutdown);
        Object object = this.mReturnLock;
        synchronized (object) {
            this.mShutdown = true;
        }
        this.processReturnedResources();
        while (this.mNonPurgeableSize > 0) {
            Resource back = this.mNonPurgeableList[this.mNonPurgeableSize - 1];
            assert (!back.isDestroyed());
            this.removeFromNonPurgeableArray(back);
            back.unrefCache();
        }
        while (!this.mPurgeableQueue.isEmpty()) {
            Resource top = this.mPurgeableQueue.peek();
            assert (!top.isDestroyed());
            this.removeFromPurgeableQueue(top);
            top.unrefCache();
        }
    }

    @Nullable
    public Resource findAndRefResource(@Nonnull IResourceKey key, boolean budgeted) {
        assert (this.mContext.isOwnerThread());
        Resource resource = this.mResourceMap.peekFirstEntry(key);
        if (resource == null && this.processReturnedResources()) {
            resource = this.mResourceMap.peekFirstEntry(key);
        }
        if (resource != null) {
            assert (resource.isBudgeted());
            if (!key.isShareable()) {
                this.mResourceMap.removeFirstEntry(key, resource);
                if (!budgeted) {
                    resource.makeBudgeted(false);
                    --this.mBudgetedCount;
                    this.mBudgetedBytes -= resource.getMemorySize();
                }
                resource.mNonShareableInCache = false;
            } else assert (budgeted);
            this.refAndMakeResourceMRU(resource);
        }
        this.purgeAsNeeded();
        return resource;
    }

    public void setSurfaceProvider(ImageProxyCache imageProxyCache) {
        this.mImageProxyCache = imageProxyCache;
    }

    public void setThreadSafeCache(ThreadSafeCache threadSafeCache) {
        this.mThreadSafeCache = threadSafeCache;
    }

    @VisibleForTesting
    public void purgeAsNeeded() {
        assert (this.mContext.isOwnerThread());
        if (this.isOverBudget() && this.mImageProxyCache != null) {
            this.mImageProxyCache.dropUniqueRefs();
            this.processReturnedResources();
        }
        while (this.isOverBudget() && !this.mPurgeableQueue.isEmpty()) {
            Resource resource = this.mPurgeableQueue.peek();
            assert (!resource.isDestroyed());
            assert (this.mResourceMap.containsKey(resource.getKey()));
            if (resource.mTimestamp == -1) {
                assert (resource.getMemorySize() == 0L);
                break;
            }
            this.purgeResource(resource);
        }
    }

    public void purgeResources() {
        assert (this.mContext.isOwnerThread());
        this.purgeResources(false, -1L);
    }

    public void purgeResourcesNotUsedSince(long timeMillis) {
        assert (this.mContext.isOwnerThread());
        this.purgeResources(true, timeMillis);
    }

    private boolean isOverBudget() {
        return this.mBudgetedBytes > this.mMaxBytes;
    }

    private void purgeResources(boolean useTime, long timeMillis) {
        if (this.mImageProxyCache != null) {
            this.mImageProxyCache.dropUniqueRefsOlderThan(timeMillis);
        }
        this.processReturnedResources();
        if (useTime && !this.mPurgeableQueue.isEmpty() && this.mPurgeableQueue.peek().getLastUsedTime() >= timeMillis) {
            return;
        }
        this.mPurgeableQueue.sort();
        ArrayList<Resource> resourcesToPurge = new ArrayList<Resource>();
        for (int i = 0; i < this.mPurgeableQueue.size(); ++i) {
            Resource resource = this.mPurgeableQueue.elementAt(i);
            if (useTime && resource.getLastUsedTime() >= timeMillis) break;
            assert (resource.isPurgeable());
            resourcesToPurge.add(resource);
        }
        resourcesToPurge.forEach(this::purgeResource);
        this.purgeAsNeeded();
        this.mPurgeableQueue.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean returnResource(@Nonnull Resource resource, int refType) {
        assert (refType != 2);
        Object object = this.mReturnLock;
        synchronized (object) {
            if (this.mShutdown) {
                return false;
            }
            if (resource.mReturnIndex >= 0) {
                if (refType == 0) {
                    assert (resource.mReturnIndex < this.mReturnQueueSize);
                    this.mReturnQueueRefTypes[resource.mReturnIndex] = refType;
                }
                return true;
            }
            int s = this.mReturnQueueSize;
            Resource[] es = this.mReturnQueue;
            if (s == es.length) {
                int newCap = s + (s >> 1);
                this.mReturnQueue = es = Arrays.copyOf(es, newCap);
                this.mReturnQueueRefTypes = Arrays.copyOf(this.mReturnQueueRefTypes, newCap);
            }
            es[s] = resource;
            this.mReturnQueueRefTypes[s] = refType;
            resource.mReturnIndex = s;
            this.mReturnQueueSize = s + 1;
            resource.refCache();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean processReturnedResources() {
        int[] tempRefTypes;
        Resource[] tempQueue;
        Object object = this.mReturnLock;
        synchronized (object) {
            if (this.mReturnQueueSize == 0) {
                return false;
            }
            tempQueue = Arrays.copyOf(this.mReturnQueue, this.mReturnQueueSize);
            tempRefTypes = Arrays.copyOf(this.mReturnQueueRefTypes, this.mReturnQueueSize);
            Arrays.fill(this.mReturnQueue, 0, this.mReturnQueueSize, null);
            this.mReturnQueueSize = 0;
            for (Resource resource : tempQueue) {
                assert (resource.mReturnIndex >= 0);
                resource.mReturnIndex = -1;
            }
        }
        for (int i = 0; i < tempQueue.length; ++i) {
            Resource resource = tempQueue[i];
            if (resource.mCacheIndex != -1) {
                this.returnResourceToCache(resource, tempRefTypes[i]);
            }
            resource.unrefCache();
        }
        return true;
    }

    private void returnResourceToCache(@Nonnull Resource resource, int refType) {
        assert (!resource.isDestroyed());
        assert (this.isInCache(resource));
        if (refType == 0) {
            if (resource.getKey().isShareable()) {
                assert (this.mResourceMap.containsKey(resource.getKey()));
            } else {
                resource.mNonShareableInCache = true;
                this.mResourceMap.addFirstEntry(resource.getKey(), resource);
                if (!resource.isBudgeted()) {
                    resource.makeBudgeted(true);
                    ++this.mBudgetedCount;
                    this.mBudgetedBytes += resource.getMemorySize();
                }
            }
        }
        if (!resource.isPurgeable() || this.isInPurgeableQueue(resource)) {
            return;
        }
        this.setResourceTimestamp(resource, this.getNextTimestamp());
        this.removeFromNonPurgeableArray(resource);
        if (resource.isCacheable()) {
            assert (resource.isPurgeable());
            resource.setLastUsedTime();
            this.mPurgeableQueue.add(resource);
            this.mPurgeableBytes += resource.getMemorySize();
        } else {
            this.purgeResource(resource);
        }
    }

    public void insertResource(@Nonnull Resource resource) {
        assert (this.mContext.isOwnerThread());
        assert (!this.isInCache(resource));
        assert (!resource.isDestroyed());
        assert (!resource.isPurgeable());
        assert (resource.getKey() != null);
        assert (!resource.isWrapped());
        if (resource.getMemorySize() > 0L) {
            this.processReturnedResources();
        }
        resource.registerWithCache(this);
        resource.refCache();
        this.setResourceTimestamp(resource, this.getNextTimestamp());
        resource.setLastUsedTime();
        this.addToNonPurgeableArray(resource);
        if (resource.getKey().isShareable()) {
            this.mResourceMap.addFirstEntry(resource.getKey(), resource);
        }
        if (resource.isBudgeted()) {
            ++this.mBudgetedCount;
            this.mBudgetedBytes += resource.getMemorySize();
        }
        this.purgeAsNeeded();
    }

    private void purgeResource(@Nonnull Resource resource) {
        assert (resource.isPurgeable());
        this.mResourceMap.removeFirstEntry(resource.getKey(), resource);
        if (resource.isCacheable()) {
            assert (this.isInPurgeableQueue(resource));
            this.removeFromPurgeableQueue(resource);
        } else assert (!this.isInCache(resource));
        --this.mBudgetedCount;
        this.mBudgetedBytes -= resource.getMemorySize();
        resource.unrefCache();
    }

    private void refAndMakeResourceMRU(@Nonnull Resource resource) {
        assert (this.isInCache(resource));
        if (this.isInPurgeableQueue(resource)) {
            this.mPurgeableQueue.removeAt(resource.mCacheIndex);
            this.mPurgeableBytes -= resource.getMemorySize();
            this.addToNonPurgeableArray(resource);
        }
        resource.addInitialUsageRef();
        this.setResourceTimestamp(resource, this.getNextTimestamp());
    }

    private void addToNonPurgeableArray(@Nonnull Resource resource) {
        int s = this.mNonPurgeableSize;
        Resource[] es = this.mNonPurgeableList;
        if (s == es.length) {
            this.mNonPurgeableList = es = Arrays.copyOf(es, s + (s >> 1));
        }
        es[s] = resource;
        resource.mCacheIndex = s;
        this.mNonPurgeableSize = s + 1;
    }

    private void removeFromNonPurgeableArray(@Nonnull Resource resource) {
        Resource[] es = this.mNonPurgeableList;
        int pos = resource.mCacheIndex;
        assert (es[pos] == resource);
        int s = --this.mNonPurgeableSize;
        Resource tail = es[s];
        es[s] = null;
        es[pos] = tail;
        tail.mCacheIndex = pos;
        resource.mCacheIndex = -1;
    }

    private void removeFromPurgeableQueue(@Nonnull Resource resource) {
        this.mPurgeableQueue.removeAt(resource.mCacheIndex);
        this.mPurgeableBytes -= resource.getMemorySize();
        resource.mCacheIndex = -1;
    }

    private int getNextTimestamp() {
        if (this.mTimestamp == -1) {
            this.mTimestamp = 0;
            int count = this.getResourceCount();
            if (count > 0) {
                int purgeableSize = this.mPurgeableQueue.size();
                Resource[] sortedPurgeable = new Resource[purgeableSize];
                for (int i = 0; i < purgeableSize; ++i) {
                    sortedPurgeable[i] = (Resource)this.mPurgeableQueue.remove();
                }
                Arrays.sort(this.mNonPurgeableList, 0, this.mNonPurgeableSize, TIMESTAMP_COMPARATOR);
                int currP = 0;
                int currNP = 0;
                while (currP < purgeableSize && currNP < this.mNonPurgeableSize) {
                    int tsP = sortedPurgeable[currP].mTimestamp;
                    int tsNP = this.mNonPurgeableList[currNP].mTimestamp;
                    assert (tsP != tsNP);
                    if (tsP < tsNP) {
                        this.setResourceTimestamp(sortedPurgeable[currP++], this.mTimestamp++);
                        continue;
                    }
                    this.mNonPurgeableList[currNP].mCacheIndex = currNP;
                    this.setResourceTimestamp(this.mNonPurgeableList[currNP++], this.mTimestamp++);
                }
                while (currP < purgeableSize) {
                    this.setResourceTimestamp(sortedPurgeable[currP++], this.mTimestamp++);
                }
                while (currNP < this.mNonPurgeableSize) {
                    this.mNonPurgeableList[currNP].mCacheIndex = currNP;
                    this.setResourceTimestamp(this.mNonPurgeableList[currNP++], this.mTimestamp++);
                }
                Collections.addAll(this.mPurgeableQueue, sortedPurgeable);
                assert (this.mTimestamp == count);
                assert (this.mTimestamp == this.getResourceCount());
            }
        }
        return this.mTimestamp++;
    }

    private void setResourceTimestamp(@Nonnull Resource resource, int timestamp) {
        if (resource.getMemorySize() == 0L) {
            timestamp = -1;
        }
        resource.mTimestamp = timestamp;
    }

    private boolean isInPurgeableQueue(@Nonnull Resource resource) {
        assert (this.isInCache(resource));
        int index = resource.mCacheIndex;
        return index < this.mPurgeableQueue.size() && this.mPurgeableQueue.elementAt(index) == resource;
    }

    private boolean isInCache(@Nonnull Resource resource) {
        int index = resource.mCacheIndex;
        if (index < 0) {
            return false;
        }
        if (index < this.mPurgeableQueue.size() && this.mPurgeableQueue.elementAt(index) == resource) {
            return true;
        }
        if (index < this.mNonPurgeableSize && this.mNonPurgeableList[index] == resource) {
            return true;
        }
        throw new AssertionError((Object)"Resource index should be -1 or the resource should be in the cache.");
    }
}

