/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.UniqueID;
import yslelf.cloudpick.render.engine.GpuSurface;
import yslelf.cloudpick.render.engine.IResourceKey;
import yslelf.cloudpick.render.engine.IUniqueKey;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.engine.LinkedListMultimap;
import yslelf.cloudpick.render.engine.ResourceProvider;
import yslelf.cloudpick.render.engine.SurfaceProxy;

public final class SurfaceAllocator {
    private final ImmediateContext mContext;
    private final Reference2ObjectOpenHashMap<UniqueID, Interval> mIntervalHash = new Reference2ObjectOpenHashMap();
    private final IntervalList mIntervalList = new IntervalList();
    private final IntervalList mActiveIntervals = new IntervalList();
    private final IntervalList mFinishedIntervals = new IntervalList();
    private final LinkedListMultimap<IResourceKey, Register> mFreePool = new LinkedListMultimap();
    private final Object2ObjectOpenHashMap<Object, Register> mUniqueKeyRegisters = new Object2ObjectOpenHashMap();
    private int mNumOps;
    private boolean mSimulated;
    private boolean mAllocated;
    private boolean mInstantiationFailed;
    private final Register[] mRegisterPool = new Register[128];
    private int mRegisterPoolSize;
    private final Interval[] mIntervalPool = new Interval[128];
    private int mIntervalPoolSize;

    public SurfaceAllocator(ImmediateContext context) {
        this.mContext = context;
    }

    public int curOp() {
        return this.mNumOps;
    }

    public void incOps() {
        ++this.mNumOps;
    }

    public void addInterval(@Nonnull @RawPtr SurfaceProxy proxy, int start, int end, boolean actualUse) {
        assert (start <= end);
        assert (!this.mAllocated);
        if (proxy.shouldSkipAllocator()) {
            return;
        }
        if (proxy.isReadOnly()) {
            ResourceProvider resourceProvider = this.mContext.getResourceProvider();
            if (proxy.isLazy() && !proxy.doLazyInstantiation(resourceProvider)) {
                this.mInstantiationFailed = true;
            } else assert (proxy.isInstantiated());
            return;
        }
        UniqueID proxyID = proxy.getUniqueID();
        Interval interval = (Interval)this.mIntervalHash.get((Object)proxyID);
        if (interval != null) {
            if (actualUse) {
                ++interval.mUses;
            }
            if (end > interval.mEnd) {
                interval.mEnd = end;
            }
            return;
        }
        Interval newInterval = this.makeInterval(proxy, start, end);
        if (actualUse) {
            ++newInterval.mUses;
        }
        this.mIntervalList.insertByIncreasingStart(newInterval);
        this.mIntervalHash.put((Object)proxyID, (Object)newInterval);
    }

    public boolean isInstantiationFailed() {
        return this.mInstantiationFailed;
    }

    public boolean simulate() {
        this.mIntervalHash.clear();
        assert (!this.mSimulated && !this.mAllocated);
        this.mSimulated = true;
        ResourceProvider resourceProvider = this.mContext.getResourceProvider();
        Interval cur = this.mIntervalList.peekHead();
        while (cur != null) {
            this.expire(cur.mStart);
            this.mActiveIntervals.insertByIncreasingEnd(cur);
            if (!cur.mSurfaceProxy.isInstantiated()) {
                if (cur.mSurfaceProxy.isLazy()) {
                    if (cur.mSurfaceProxy.isLazyMost()) {
                        boolean bl = this.mInstantiationFailed = !cur.mSurfaceProxy.doLazyInstantiation(resourceProvider);
                        if (this.mInstantiationFailed) {
                            break;
                        }
                    }
                } else {
                    Register r = this.findOrCreateRegister(cur.mSurfaceProxy, resourceProvider);
                    assert (cur.mSurfaceProxy.getGpuSurface() == null);
                    cur.mRegister = r;
                }
            }
            cur = cur.mNext;
        }
        this.expire(Integer.MAX_VALUE);
        return !this.mInstantiationFailed;
    }

    public boolean allocate() {
        Interval cur;
        if (this.mInstantiationFailed) {
            return false;
        }
        assert (this.mSimulated && !this.mAllocated);
        this.mAllocated = true;
        ResourceProvider resourceProvider = this.mContext.getResourceProvider();
        while ((cur = this.mFinishedIntervals.popHead()) != null && !this.mInstantiationFailed) {
            if (cur.mSurfaceProxy.isInstantiated()) continue;
            if (cur.mSurfaceProxy.isLazy()) {
                this.mInstantiationFailed = !cur.mSurfaceProxy.doLazyInstantiation(resourceProvider);
                continue;
            }
            Register r = cur.mRegister;
            assert (r != null);
            this.mInstantiationFailed = !r.instantiateSurface(cur.mSurfaceProxy, resourceProvider);
        }
        return !this.mInstantiationFailed;
    }

    public void reset() {
        Interval cur;
        this.mNumOps = 0;
        this.mSimulated = false;
        this.mAllocated = false;
        this.mInstantiationFailed = false;
        assert (this.mActiveIntervals.isEmpty());
        this.mFinishedIntervals.clear();
        while ((cur = this.mIntervalList.popHead()) != null) {
            if (cur.mRegister != null && cur.mRegister.reset()) {
                this.freeRegister(cur.mRegister);
            }
            if (cur.reset()) {
                this.freeInterval(cur);
                continue;
            }
            assert (false);
        }
        this.mIntervalList.clear();
        this.mIntervalHash.clear();
        this.mFreePool.clear();
        this.mUniqueKeyRegisters.clear();
    }

    private void expire(int curIndex) {
        while (!this.mActiveIntervals.isEmpty() && this.mActiveIntervals.peekHead().mEnd < curIndex) {
            Interval interval = this.mActiveIntervals.popHead();
            assert (interval.mNext == null);
            Register r = interval.mRegister;
            if (r != null && r.isRecyclable(interval.mSurfaceProxy, interval.mUses)) {
                this.mFreePool.addLastEntry(r.mScratchKey, r);
            }
            this.mFinishedIntervals.insertByIncreasingStart(interval);
        }
    }

    private Register findOrCreateRegister(@Nonnull SurfaceProxy proxy, ResourceProvider provider) {
        IUniqueKey uniqueKey = proxy.getUniqueKey();
        if (uniqueKey != null) {
            Register r = (Register)this.mUniqueKeyRegisters.get((Object)uniqueKey);
            if (r != null) {
                return r;
            }
            r = this.makeRegister(proxy, provider, null);
            this.mUniqueKeyRegisters.put((Object)uniqueKey, (Object)r);
            return r;
        }
        IResourceKey scratchKey = proxy.computeScratchKey();
        Register r = this.mFreePool.pollFirstEntry(scratchKey);
        if (r != null) {
            return r;
        }
        return this.makeRegister(proxy, provider, scratchKey);
    }

    private Register makeRegister(@Nonnull SurfaceProxy proxy, ResourceProvider provider, IResourceKey scratchKey) {
        if (this.mRegisterPoolSize == 0) {
            return new Register(proxy, provider, scratchKey);
        }
        return this.mRegisterPool[--this.mRegisterPoolSize].init(proxy, provider, scratchKey);
    }

    private void freeRegister(@Nonnull Register register) {
        if (this.mRegisterPoolSize == this.mRegisterPool.length) {
            return;
        }
        this.mRegisterPool[this.mRegisterPoolSize++] = register;
    }

    private Interval makeInterval(@Nonnull SurfaceProxy proxy, int start, int end) {
        if (this.mIntervalPoolSize == 0) {
            return new Interval(proxy, start, end);
        }
        return this.mIntervalPool[--this.mIntervalPoolSize].init(proxy, start, end);
    }

    private void freeInterval(@Nonnull Interval interval) {
        if (this.mIntervalPoolSize == this.mIntervalPool.length) {
            return;
        }
        this.mIntervalPool[this.mIntervalPoolSize++] = interval;
    }

    private static class IntervalList {
        private Interval mHead;
        private Interval mTail;

        public void clear() {
            this.mTail = null;
            this.mHead = null;
        }

        public boolean isEmpty() {
            assert (this.mHead == null == (this.mTail == null));
            return this.mHead == null;
        }

        public Interval peekHead() {
            return this.mHead;
        }

        public Interval popHead() {
            Interval temp = this.mHead;
            if (temp != null) {
                this.mHead = temp.mNext;
                if (this.mHead == null) {
                    this.mTail = null;
                }
                temp.mNext = null;
            }
            return temp;
        }

        public void insertByIncreasingStart(@Nonnull Interval interval) {
            assert (interval.mNext == null);
            if (this.mHead == null) {
                this.mHead = this.mTail = interval;
            } else if (interval.mStart <= this.mHead.mStart) {
                interval.mNext = this.mHead;
                this.mHead = interval;
            } else if (this.mTail.mStart <= interval.mStart) {
                this.mTail.mNext = interval;
                this.mTail = interval;
            } else {
                Interval prev = this.mHead;
                Interval next = prev.mNext;
                while (interval.mStart > next.mStart) {
                    prev = next;
                    next = next.mNext;
                }
                interval.mNext = next;
                prev.mNext = interval;
            }
        }

        public void insertByIncreasingEnd(@Nonnull Interval interval) {
            assert (interval.mNext == null);
            if (this.mHead == null) {
                this.mHead = this.mTail = interval;
            } else if (interval.mEnd <= this.mHead.mEnd) {
                interval.mNext = this.mHead;
                this.mHead = interval;
            } else if (this.mTail.mEnd <= interval.mEnd) {
                this.mTail.mNext = interval;
                this.mTail = interval;
            } else {
                Interval prev = this.mHead;
                Interval next = prev.mNext;
                while (interval.mEnd > next.mEnd) {
                    prev = next;
                    next = next.mNext;
                }
                interval.mNext = next;
                prev.mNext = interval;
            }
        }
    }

    private static class Register {
        private SurfaceProxy mOriginatingProxy;
        @SharedPtr
        private GpuSurface mExistingSurface;
        private IResourceKey mScratchKey;
        private boolean mInit;

        public Register(SurfaceProxy originatingProxy, ResourceProvider provider, IResourceKey scratchKey) {
            this.init(originatingProxy, provider, scratchKey);
        }

        public Register init(SurfaceProxy originatingProxy, ResourceProvider provider, IResourceKey scratchKey) {
            assert (!this.mInit);
            assert (originatingProxy != null);
            assert (!originatingProxy.isInstantiated());
            assert (!originatingProxy.isLazy());
            this.mOriginatingProxy = originatingProxy;
            this.mScratchKey = scratchKey;
            this.mInit = true;
            return this;
        }

        public boolean isRecyclable(SurfaceProxy proxy, int knownUseCount) {
            if (this.mOriginatingProxy.getUniqueKey() != null) {
                return false;
            }
            assert (proxy.asImageProxy() != null);
            return !this.refCntGreaterThan(proxy, knownUseCount);
        }

        public boolean refCntGreaterThan(SurfaceProxy proxy, int threadIsolatedTestCnt) {
            int cnt = proxy.getRefCntAcquire();
            assert (cnt >= threadIsolatedTestCnt);
            return cnt > threadIsolatedTestCnt;
        }

        public boolean instantiateSurface(SurfaceProxy proxy, ResourceProvider resourceProvider) {
            GpuSurface surface;
            assert (proxy.getGpuSurface() == null);
            if (this.mExistingSurface == null) {
                surface = this.mOriginatingProxy == proxy ? proxy.createSurface(resourceProvider) : RefCnt.create(this.mOriginatingProxy.getGpuSurface());
                if (surface == null) {
                    return false;
                }
            } else {
                surface = RefCnt.create(this.mExistingSurface);
            }
            assert (surface != null);
            assert (proxy.asRenderTargetProxy() == null || surface.asRenderTarget() != null);
            if (proxy.isBudgeted() && surface.isBudgeted()) {
                surface.makeBudgeted(true);
            }
            assert (proxy.getGpuSurface() == null);
            proxy.mGpuSurface = surface;
            return true;
        }

        public boolean reset() {
            if (this.mInit) {
                this.mOriginatingProxy = null;
                this.mExistingSurface = RefCnt.move(this.mExistingSurface);
                this.mInit = false;
                return true;
            }
            assert (this.mOriginatingProxy == null);
            assert (this.mExistingSurface == null);
            return false;
        }
    }

    private static class Interval {
        private SurfaceProxy mSurfaceProxy;
        private int mStart;
        private int mEnd;
        private Interval mNext;
        private int mUses;
        private Register mRegister;
        private boolean mInit;

        public Interval(SurfaceProxy surfaceProxy, int start, int end) {
            this.init(surfaceProxy, start, end);
        }

        public Interval init(SurfaceProxy proxy, int start, int end) {
            assert (!this.mInit);
            assert (proxy != null);
            this.mSurfaceProxy = proxy;
            this.mStart = start;
            this.mEnd = end;
            this.mNext = null;
            this.mUses = 0;
            this.mRegister = null;
            this.mInit = true;
            return this;
        }

        public boolean reset() {
            if (this.mInit) {
                this.mSurfaceProxy = null;
                this.mNext = null;
                this.mRegister = null;
                this.mInit = false;
                return true;
            }
            assert (this.mSurfaceProxy == null);
            assert (this.mNext == null);
            assert (this.mRegister == null);
            return false;
        }
    }
}

