/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import org.jetbrains.annotations.Contract;
import yslelf.cloudpick.render.core.Size;

public final class Swizzle {
    public static final short RGBA = 12816;
    public static final short BGRA = 12306;
    public static final short RGB1 = 21008;
    public static final short BGR1 = 20498;
    public static final short AAAA = 13107;
    public static final short INVALID = -1;
    public static final int COMPONENT_R = 0;
    public static final int COMPONENT_G = 1;
    public static final int COMPONENT_B = 2;
    public static final int COMPONENT_A = 3;
    public static final int COMPONENT_ZERO = 4;
    public static final int COMPONENT_ONE = 5;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Contract(pure=true)
    public static int charToIndex(char c) {
        return switch (c) {
            case 'r' -> 0;
            case 'g' -> 1;
            case 'b' -> 2;
            case 'a' -> 3;
            case '0' -> 4;
            case '1' -> 5;
            default -> throw new AssertionError(c);
        };
    }

    @Contract(pure=true)
    public static char indexToChar(int idx) {
        return switch (idx) {
            case 0 -> 'r';
            case 1 -> 'g';
            case 2 -> 'b';
            case 3 -> 'a';
            case 4 -> '0';
            case 5 -> '1';
            default -> throw new AssertionError(idx);
        };
    }

    @Contract(pure=true)
    public static short make(CharSequence s) {
        return Swizzle.make(s.charAt(0), s.charAt(1), s.charAt(2), s.charAt(3));
    }

    @Contract(pure=true)
    public static short make(char r, char g, char b, char a) {
        return Swizzle.make(Swizzle.charToIndex(r), Swizzle.charToIndex(g), Swizzle.charToIndex(b), Swizzle.charToIndex(a));
    }

    @Contract(pure=true)
    public static short make(int r, int g, int b, int a) {
        return (short)(r | g << 4 | b << 8 | a << 12);
    }

    @Contract(pure=true)
    public static int getR(short swizzle) {
        return swizzle & 0xF;
    }

    @Contract(pure=true)
    public static int getG(short swizzle) {
        return swizzle >> 4 & 0xF;
    }

    @Contract(pure=true)
    public static int getB(short swizzle) {
        return swizzle >> 8 & 0xF;
    }

    @Contract(pure=true)
    public static int getA(short swizzle) {
        return swizzle >>> 12;
    }

    public static short concat(short a, short b) {
        int swizzle = 0;
        for (int i = 0; i < 4; ++i) {
            int idx = b >> 4 * i & 0xF;
            if (idx != 4 && idx != 5) {
                if (!$assertionsDisabled && idx >= 4) {
                    throw new AssertionError();
                }
                idx = a >> 4 * idx & 0xF;
            }
            swizzle |= idx << 4 * i;
        }
        return (short)swizzle;
    }

    public static void apply(short swizzle, @Size(value=4L) float[] inColor, @Size(value=4L) float[] outColor) {
        float r = inColor[0];
        float g = inColor[1];
        float b = inColor[2];
        float a = inColor[3];
        for (int i = 0; i < 4; ++i) {
            outColor[i] = switch (swizzle & 0xF) {
                case 0 -> r;
                case 1 -> g;
                case 2 -> b;
                case 3 -> a;
                case 4 -> 0.0f;
                case 5 -> 1.0f;
                default -> throw new AssertionError();
            };
            swizzle = (short)(swizzle >> 4);
        }
    }

    public static String toString(short swizzle) {
        return "" + Swizzle.indexToChar(Swizzle.getR(swizzle)) + Swizzle.indexToChar(Swizzle.getG(swizzle)) + Swizzle.indexToChar(Swizzle.getB(swizzle)) + Swizzle.indexToChar(Swizzle.getA(swizzle));
    }

    static {
        boolean bl = $assertionsDisabled = !Swizzle.class.desiredAssertionStatus();
        if (!$assertionsDisabled && Swizzle.make('r', 'g', 'b', 'a') != 12816) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Swizzle.make('b', 'g', 'r', 'a') != 12306) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Swizzle.make('r', 'g', 'b', '1') != 21008) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Swizzle.make('b', 'g', 'r', '1') != 20498) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Swizzle.make('a', 'a', 'a', 'a') != 13107) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Swizzle.concat(Swizzle.make('1', '1', '1', 'r'), (short)13107) != Swizzle.make('r', 'r', 'r', 'r')) {
            throw new AssertionError();
        }
    }
}

