/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import java.util.ArrayList;
import java.util.List;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.OpFlushState;
import yslelf.cloudpick.render.engine.RenderTargetProxy;
import yslelf.cloudpick.render.engine.RenderTask;
import yslelf.cloudpick.render.engine.RenderTaskManager;
import yslelf.cloudpick.render.engine.SurfaceProxy;

public final class TextureResolveTask
extends RenderTask {
    private final List<Resolve> mResolves = new ArrayList<Resolve>(4);

    public TextureResolveTask(RenderTaskManager taskManager) {
        super(taskManager);
    }

    public void addResolveTarget(@SharedPtr SurfaceProxy proxy, int resolveFlags) {
        Rect2ic msaaRect;
        assert (this.mTaskManager.getLastRenderTask(proxy) == null || this.mTaskManager.getLastRenderTask(proxy).isClosed());
        assert (resolveFlags != 0);
        if ((resolveFlags & 1) != 0) {
            RenderTargetProxy renderTargetProxy = proxy.asRenderTargetProxy();
            assert (renderTargetProxy != null);
            assert (renderTargetProxy.needsResolve());
            msaaRect = renderTargetProxy.getResolveRect();
            renderTargetProxy.setResolveRect(0, 0, 0, 0);
        } else {
            msaaRect = Rect2i.empty();
        }
        if ((resolveFlags & 2) != 0) {
            ImageViewProxy imageViewProxy = proxy.asImageProxy();
            assert (imageViewProxy != null);
        }
        this.mResolves.add(new Resolve(resolveFlags, msaaRect.left(), msaaRect.top(), msaaRect.right(), msaaRect.bottom()));
        this.addTarget(proxy);
    }

    @Override
    public boolean execute(OpFlushState flushState) {
        return false;
    }

    private record Resolve(int flags, int msaaLeft, int msaaTop, int msaaRight, int msaaBottom) {
    }
}

