/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.Matrix3;
import yslelf.cloudpick.render.core.Matrix4;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.RefCnt;

public abstract class UniformDataManager
extends RefCnt {
    protected final int[] mUniforms;
    protected final int mUniformSize;
    protected final long mUniformData;
    protected boolean mUniformsDirty;

    public UniformDataManager(int uniformCount, int uniformSize) {
        assert (uniformCount >= 1 && uniformSize >= 4);
        this.mUniforms = new int[uniformCount];
        this.mUniformSize = uniformSize;
        this.mUniformData = MemoryUtil.nmemAllocChecked((long)uniformSize);
        this.mUniformsDirty = false;
        assert (MathUtil.isAlign4(uniformSize));
        assert (MathUtil.isAlign4(this.mUniformData));
    }

    @Override
    protected void deallocate() {
        MemoryUtil.nmemFree((long)this.mUniformData);
    }

    public void set1i(int u, int v0) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 27 || uni >> 24 == 31 || uni >> 24 == 1);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memPutInt((long)buffer, (int)v0);
    }

    public void set1iv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 27 || uni >> 24 == 31 || uni >> 24 == 1);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutInt((long)buffer, (int)MemoryUtil.memGetInt((long)value));
            if (++i >= count) break;
            buffer += 16L;
            value += 4L;
        }
    }

    public void set1iv(int u, int offset, int count, int[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 27 || uni >> 24 == 31 || uni >> 24 == 1);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutInt((long)buffer, (int)value[offset + i]);
            if (++i >= count) break;
            buffer += 16L;
        }
    }

    public void set1f(int u, float v0) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 13);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memPutFloat((long)buffer, (float)v0);
    }

    public void set1fv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 13);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutInt((long)buffer, (int)MemoryUtil.memGetInt((long)value));
            if (++i >= count) break;
            buffer += 16L;
            value += 4L;
        }
    }

    public void set1fv(int u, int offset, int count, float[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 13);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutFloat((long)buffer, (float)value[offset + i]);
            if (++i >= count) break;
            buffer += 16L;
        }
    }

    public void set2i(int u, int v0, int v1) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 28 || uni >> 24 == 32 || uni >> 24 == 2);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memPutInt((long)buffer, (int)v0);
        MemoryUtil.memPutInt((long)(buffer + 4L), (int)v1);
    }

    public void set2iv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 28 || uni >> 24 == 32 || uni >> 24 == 2);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutLong((long)buffer, (long)MemoryUtil.memGetLong((long)value));
            if (++i >= count) break;
            buffer += 16L;
            value += 8L;
        }
    }

    public void set2iv(int u, int offset, int count, int[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 28 || uni >> 24 == 32 || uni >> 24 == 2);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutInt((long)buffer, (int)value[offset]);
            MemoryUtil.memPutInt((long)(buffer + 4L), (int)value[offset + 1]);
            if (++i >= count) break;
            buffer += 16L;
            offset += 2;
        }
    }

    public void set2f(int u, float v0, float v1) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 14);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memPutFloat((long)buffer, (float)v0);
        MemoryUtil.memPutFloat((long)(buffer + 4L), (float)v1);
    }

    public void set2fv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 14);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutLong((long)buffer, (long)MemoryUtil.memGetLong((long)value));
            if (++i >= count) break;
            buffer += 16L;
            value += 8L;
        }
    }

    public void set2fv(int u, int offset, int count, float[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 14);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutFloat((long)buffer, (float)value[offset]);
            MemoryUtil.memPutFloat((long)(buffer + 4L), (float)value[offset + 1]);
            if (++i >= count) break;
            buffer += 16L;
            offset += 2;
        }
    }

    public void set3i(int u, int v0, int v1, int v2) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 29 || uni >> 24 == 33 || uni >> 24 == 3);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memPutInt((long)buffer, (int)v0);
        MemoryUtil.memPutInt((long)(buffer + 4L), (int)v1);
        MemoryUtil.memPutInt((long)(buffer + 8L), (int)v2);
    }

    public void set3iv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 29 || uni >> 24 == 33 || uni >> 24 == 3);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutLong((long)buffer, (long)MemoryUtil.memGetLong((long)value));
            MemoryUtil.memPutInt((long)(buffer + 8L), (int)MemoryUtil.memGetInt((long)(value + 8L)));
            if (++i >= count) break;
            buffer += 16L;
            value += 12L;
        }
    }

    public void set3iv(int u, int offset, int count, int[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 29 || uni >> 24 == 33 || uni >> 24 == 3);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutInt((long)buffer, (int)value[offset]);
            MemoryUtil.memPutInt((long)(buffer + 4L), (int)value[offset + 1]);
            MemoryUtil.memPutInt((long)(buffer + 8L), (int)value[offset + 2]);
            if (++i >= count) break;
            buffer += 16L;
            offset += 3;
        }
    }

    public void set3f(int u, float v0, float v1, float v2) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 15);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memPutFloat((long)buffer, (float)v0);
        MemoryUtil.memPutFloat((long)(buffer + 4L), (float)v1);
        MemoryUtil.memPutFloat((long)(buffer + 8L), (float)v2);
    }

    public void set3fv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 15);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutLong((long)buffer, (long)MemoryUtil.memGetLong((long)value));
            MemoryUtil.memPutInt((long)(buffer + 8L), (int)MemoryUtil.memGetInt((long)(value + 8L)));
            if (++i >= count) break;
            buffer += 16L;
            value += 12L;
        }
    }

    public void set3fv(int u, int offset, int count, float[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 15);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutFloat((long)buffer, (float)value[offset]);
            MemoryUtil.memPutFloat((long)(buffer + 4L), (float)value[offset + 1]);
            MemoryUtil.memPutFloat((long)(buffer + 8L), (float)value[offset + 2]);
            if (++i >= count) break;
            buffer += 16L;
            offset += 3;
        }
    }

    public void set4i(int u, int v0, int v1, int v2, int v3) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 30 || uni >> 24 == 34 || uni >> 24 == 4);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memPutInt((long)buffer, (int)v0);
        MemoryUtil.memPutInt((long)(buffer + 4L), (int)v1);
        MemoryUtil.memPutInt((long)(buffer + 8L), (int)v2);
        MemoryUtil.memPutInt((long)(buffer + 12L), (int)v3);
    }

    public void set4iv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 30 || uni >> 24 == 34 || uni >> 24 == 4);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memCopy((long)value, (long)buffer, (long)((long)count * 4L * 4L));
    }

    public void set4iv(int u, int offset, int count, int[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 30 || uni >> 24 == 34 || uni >> 24 == 4);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int e = count * 4;
        for (int i = 0; i < e; ++i) {
            MemoryUtil.memPutInt((long)buffer, (int)value[offset++]);
            buffer += 4L;
        }
    }

    public void set4f(int u, float v0, float v1, float v2, float v3) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 16);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memPutFloat((long)buffer, (float)v0);
        MemoryUtil.memPutFloat((long)(buffer + 4L), (float)v1);
        MemoryUtil.memPutFloat((long)(buffer + 8L), (float)v2);
        MemoryUtil.memPutFloat((long)(buffer + 12L), (float)v3);
    }

    public void set4fv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 16);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memCopy((long)value, (long)buffer, (long)((long)count * 4L * 4L));
    }

    public void set4fv(int u, int offset, int count, float[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 16);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int e = count * 4;
        for (int i = 0; i < e; ++i) {
            MemoryUtil.memPutFloat((long)buffer, (float)value[offset++]);
            buffer += 4L;
        }
    }

    public void setMatrix2fv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 17);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutLong((long)buffer, (long)MemoryUtil.memGetLong((long)value));
            MemoryUtil.memPutLong((long)(buffer + 16L), (long)MemoryUtil.memGetLong((long)(value + 8L)));
            if (++i >= count) break;
            buffer += 32L;
            value += 16L;
        }
    }

    public void setMatrix2fv(int u, int offset, int count, float[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 17);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutFloat((long)buffer, (float)value[offset]);
            MemoryUtil.memPutFloat((long)(buffer + 4L), (float)value[offset + 1]);
            MemoryUtil.memPutFloat((long)(buffer + 16L), (float)value[offset + 2]);
            MemoryUtil.memPutFloat((long)(buffer + 20L), (float)value[offset + 3]);
            if (++i >= count) break;
            buffer += 32L;
            offset += 4;
        }
    }

    public void setMatrix3fv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 18);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutLong((long)buffer, (long)MemoryUtil.memGetLong((long)value));
            MemoryUtil.memPutInt((long)(buffer + 8L), (int)MemoryUtil.memGetInt((long)(value + 8L)));
            MemoryUtil.memPutLong((long)(buffer + 16L), (long)MemoryUtil.memGetLong((long)(value + 12L)));
            MemoryUtil.memPutInt((long)(buffer + 24L), (int)MemoryUtil.memGetInt((long)(value + 20L)));
            MemoryUtil.memPutLong((long)(buffer + 32L), (long)MemoryUtil.memGetLong((long)(value + 24L)));
            MemoryUtil.memPutInt((long)(buffer + 40L), (int)MemoryUtil.memGetInt((long)(value + 32L)));
            if (++i >= count) break;
            buffer += 48L;
            value += 36L;
        }
    }

    public void setMatrix3fv(int u, int offset, int count, float[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 18);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int i = 0;
        while (true) {
            MemoryUtil.memPutFloat((long)buffer, (float)value[offset]);
            MemoryUtil.memPutFloat((long)(buffer + 4L), (float)value[offset + 1]);
            MemoryUtil.memPutFloat((long)(buffer + 8L), (float)value[offset + 2]);
            MemoryUtil.memPutFloat((long)(buffer + 16L), (float)value[offset + 3]);
            MemoryUtil.memPutFloat((long)(buffer + 20L), (float)value[offset + 4]);
            MemoryUtil.memPutFloat((long)(buffer + 24L), (float)value[offset + 5]);
            MemoryUtil.memPutFloat((long)(buffer + 32L), (float)value[offset + 6]);
            MemoryUtil.memPutFloat((long)(buffer + 36L), (float)value[offset + 7]);
            MemoryUtil.memPutFloat((long)(buffer + 40L), (float)value[offset + 8]);
            if (++i >= count) break;
            buffer += 48L;
            offset += 9;
        }
    }

    public void setMatrix4fv(int u, int count, long value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 19);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        MemoryUtil.memCopy((long)value, (long)buffer, (long)((long)count * 4L * 4L * 4L));
    }

    public void setMatrix4fv(int u, int offset, int count, float[] value) {
        assert (count > 0);
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 19);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        int e = count * 4 * 4;
        for (int i = 0; i < e; ++i) {
            MemoryUtil.memPutFloat((long)buffer, (float)value[offset++]);
            buffer += 4L;
        }
    }

    public void setMatrix3f(int u, Matrixc matrix) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 18);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        matrix.storeAligned(buffer);
    }

    public void setMatrix3f(int u, Matrix3 matrix) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 18);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        matrix.storeAligned(buffer);
    }

    public void setMatrix4f(int u, Matrix4 matrix) {
        int uni = this.mUniforms[u];
        assert (uni >> 24 == 19);
        long buffer = this.getBufferPtrAndMarkDirty(uni);
        matrix.store(buffer);
    }

    protected long getBufferPtrAndMarkDirty(int uni) {
        this.mUniformsDirty = true;
        return this.mUniformData + (long)(uni & 0xFFFFFF);
    }
}

