/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.BufferViewInfo;
import yslelf.cloudpick.render.engine.Resource;
import yslelf.cloudpick.render.engine.ResourceProvider;

public class UploadBufferManager {
    public static final long SMALL_BUFFER_SIZE = 262144L;
    private final ResourceProvider mResourceProvider;
    @SharedPtr
    private Buffer mSmallBuffer;
    private long mSmallBufferOffset;
    private final ObjectArrayList<@SharedPtr Buffer> mUsedBuffers = new ObjectArrayList();

    public static long getLargeBufferSize(long minBytes) {
        assert (minBytes >= 262144L);
        if (MathUtil.isPow2(minBytes)) {
            return minBytes;
        }
        long ceilPow2 = MathUtil.ceilPow2(minBytes);
        if (minBytes <= 0x400000L) {
            return ceilPow2;
        }
        if (minBytes <= 0x4000000L) {
            long floorPow2 = ceilPow2 >> 1;
            long mid = floorPow2 + (floorPow2 >> 1);
            if (minBytes <= mid) {
                return mid;
            }
            return ceilPow2;
        }
        return MathUtil.alignTo(minBytes, 0x1000000L);
    }

    public UploadBufferManager(ResourceProvider resourceProvider) {
        this.mResourceProvider = resourceProvider;
    }

    public long getUploadPointer(long requiredBytes, long requiredAlignment, BufferViewInfo outInfo) {
        if (requiredBytes <= 0L) {
            outInfo.set(null);
            return 0L;
        }
        if ((requiredBytes = MathUtil.alignTo(requiredBytes, requiredAlignment = Math.max(requiredAlignment, 4L))) >= 262144L) {
            long mappedPtr;
            @SharedPtr Buffer buffer = this.mResourceProvider.findOrCreateBuffer(UploadBufferManager.getLargeBufferSize(requiredBytes), 131080, "UploadBuffer");
            long l2 = mappedPtr = buffer != null ? buffer.map() : 0L;
            if (mappedPtr == 0L) {
                RefCnt.move(buffer);
                outInfo.set(null);
                return 0L;
            }
            outInfo.mBuffer = buffer;
            outInfo.mOffset = 0L;
            outInfo.mSize = requiredBytes;
            this.mUsedBuffers.add((Object)buffer);
            return mappedPtr;
        }
        this.mSmallBufferOffset = MathUtil.alignTo(this.mSmallBufferOffset, requiredAlignment);
        if (this.mSmallBuffer != null && requiredBytes > this.mSmallBuffer.getSize() - this.mSmallBufferOffset) {
            this.mUsedBuffers.add((Object)this.mSmallBuffer);
            this.mSmallBuffer = null;
        }
        if (this.mSmallBuffer == null) {
            this.mSmallBuffer = this.mResourceProvider.findOrCreateBuffer(262144L, 131080, "SmallUploadBuffer");
            this.mSmallBufferOffset = 0L;
            if (this.mSmallBuffer == null || this.mSmallBuffer.map() == 0L) {
                this.mSmallBuffer = RefCnt.move(this.mSmallBuffer);
                outInfo.set(null);
                return 0L;
            }
        }
        long mappedPtr = this.mSmallBuffer.getMappedBuffer();
        assert (mappedPtr != 0L);
        outInfo.mBuffer = this.mSmallBuffer;
        outInfo.mOffset = this.mSmallBufferOffset;
        outInfo.mSize = requiredBytes;
        this.mSmallBufferOffset += requiredBytes;
        return mappedPtr += this.mSmallBufferOffset;
    }

    public void flush(List<@SharedPtr Resource> outResourceRefs) {
        for (Buffer buffer : this.mUsedBuffers) {
            assert (buffer.isMapped());
            buffer.unmap();
        }
        outResourceRefs.addAll((Collection<Resource>)this.mUsedBuffers);
        this.mUsedBuffers.clear();
        this.mSmallBufferOffset = 0L;
        if (this.mSmallBuffer != null) {
            assert (this.mSmallBuffer.isMapped());
            this.mSmallBuffer.unmap();
            outResourceRefs.add(this.mSmallBuffer);
            this.mSmallBuffer = null;
        }
    }
}

