/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine.task;

import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.CommandBuffer;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.task.Task;

public class CopyBufferTask
extends Task {
    @SharedPtr
    private Buffer mSrcBuffer;
    @SharedPtr
    private Buffer mDstBuffer;
    private final long mSrcOffset;
    private final long mDstOffset;
    private final long mSize;

    CopyBufferTask(@SharedPtr Buffer srcBuffer, @SharedPtr Buffer dstBuffer, long srcOffset, long dstOffset, long size) {
        this.mSrcBuffer = srcBuffer;
        this.mDstBuffer = dstBuffer;
        this.mSrcOffset = srcOffset;
        this.mDstOffset = dstOffset;
        this.mSize = size;
    }

    @SharedPtr
    public static CopyBufferTask make(@SharedPtr Buffer srcBuffer, @SharedPtr Buffer dstBuffer, long srcOffset, long dstOffset, long size) {
        assert (srcBuffer != null);
        assert (size <= srcBuffer.getSize() - srcOffset);
        assert (dstBuffer != null);
        assert (size <= dstBuffer.getSize() - dstOffset);
        return new CopyBufferTask(srcBuffer, dstBuffer, srcOffset, dstOffset, size);
    }

    @Override
    protected void deallocate() {
        this.mSrcBuffer = RefCnt.move(this.mSrcBuffer);
        this.mDstBuffer = RefCnt.move(this.mDstBuffer);
    }

    @Override
    public int prepare(RecordingContext context) {
        return 0;
    }

    @Override
    public int execute(ImmediateContext context, CommandBuffer commandBuffer) {
        if (commandBuffer.copyBuffer(this.mSrcBuffer, this.mDstBuffer, this.mSrcOffset, this.mDstOffset, this.mSize)) {
            commandBuffer.trackResource(RefCnt.create(this.mSrcBuffer));
            commandBuffer.trackResource(RefCnt.create(this.mDstBuffer));
            return 0;
        }
        return 1;
    }
}

