/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine.task;

import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.PixelUtils;
import yslelf.cloudpick.render.core.Pixels;
import yslelf.cloudpick.render.core.Pixmap;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.BufferImageCopyData;
import yslelf.cloudpick.render.engine.BufferViewInfo;
import yslelf.cloudpick.render.engine.CommandBuffer;
import yslelf.cloudpick.render.engine.DataUtils;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.task.Task;

public class ImageUploadTask
extends Task {
    @RawPtr
    private Buffer mBuffer;
    @SharedPtr
    private ImageViewProxy mImageViewProxy;
    private int mSrcColorType;
    private int mDstColorType;
    private BufferImageCopyData[] mCopyData;
    @Nullable
    private UploadCondition mUploadCondition;

    public static UploadCondition uploadOnce() {
        return OnceUploadCondition.INSTANCE;
    }

    ImageUploadTask(@RawPtr Buffer buffer, @SharedPtr ImageViewProxy imageViewProxy, int srcColorType, int dstColorType, BufferImageCopyData[] copyData, @Nullable UploadCondition uploadCondition) {
        this.mBuffer = buffer;
        this.mImageViewProxy = imageViewProxy;
        this.mSrcColorType = srcColorType;
        this.mDstColorType = dstColorType;
        this.mCopyData = copyData;
        this.mUploadCondition = uploadCondition;
    }

    @Nullable
    @SharedPtr
    public static ImageUploadTask make(RecordingContext context, @SharedPtr ImageViewProxy imageViewProxy, int srcColorType, int srcAlphaType, ColorSpace srcColorSpace, int dstColorType, int dstAlphaType, ColorSpace dstColorSpace, MipLevel[] levels, Rect2ic dstRect, UploadCondition condition) {
        assert (imageViewProxy != null);
        int mipLevelCount = levels.length;
        assert (mipLevelCount == 1 || dstRect.width() == imageViewProxy.getWidth() && dstRect.height() == imageViewProxy.getHeight());
        if (dstRect.isEmpty()) {
            imageViewProxy.unref();
            return null;
        }
        for (int i = 0; i < mipLevelCount; ++i) {
            if (levels[i].mAddress != 0L) continue;
            imageViewProxy.unref();
            return null;
        }
        if (srcColorType == 0 || dstColorType == 0) {
            imageViewProxy.unref();
            return null;
        }
        int actualColorType = (int)context.getCaps().getSupportedWriteColorType(dstColorType, imageViewProxy.getDesc(), srcColorType);
        if (actualColorType == 0) {
            return null;
        }
        int bpp = ColorInfo.bytesPerPixel(actualColorType);
        long[] mipOffsetsAndRowBytes = new long[mipLevelCount * 2 + 2];
        long combinedBufferSize = DataUtils.computeCombinedBufferSize(mipLevelCount, bpp, dstRect.width(), dstRect.height(), 0, mipOffsetsAndRowBytes);
        BufferViewInfo bufferInfo = new BufferViewInfo();
        long writer = context.getUploadBufferManager().getUploadPointer(combinedBufferSize, mipOffsetsAndRowBytes[mipLevelCount * 2 + 1], bufferInfo);
        if (writer == 0L) {
            context.getLogger().warn("Failed to get write-mapped buffer for pixel upload of size {}", (Object)combinedBufferSize);
            imageViewProxy.unref();
            return null;
        }
        BufferImageCopyData[] copyData = new BufferImageCopyData[mipLevelCount];
        int width = dstRect.width();
        int height = dstRect.height();
        for (int mipLevel = 0; mipLevel < mipLevelCount; ++mipLevel) {
            MipLevel level = levels[mipLevel];
            int srcRowBytes = level.mRowBytes;
            long mipOffset = mipOffsetsAndRowBytes[mipLevel * 2];
            long dstRowBytes = mipOffsetsAndRowBytes[mipLevel * 2 + 1];
            Object srcBase = level.mBase;
            long srcAddr = level.mAddress;
            ImageInfo srcImageInfo = ImageInfo.make(width, height, srcColorType, srcAlphaType, srcColorSpace);
            ImageInfo dstImageInfo = ImageInfo.make(width, height, actualColorType, dstAlphaType, dstColorSpace);
            boolean res = PixelUtils.convertPixels(srcImageInfo, srcBase, srcAddr, srcRowBytes, dstImageInfo, null, writer + mipOffset, dstRowBytes);
            assert (res);
            copyData[mipLevel] = new BufferImageCopyData(bufferInfo.mOffset + mipOffset, dstRowBytes, mipLevel, 0, 1, dstRect.x(), dstRect.y(), 0, width, height, 1);
            width = Math.max(1, width >> 1);
            height = Math.max(1, height >> 1);
        }
        return new ImageUploadTask(bufferInfo.mBuffer, imageViewProxy, srcColorType, dstColorType, copyData, condition);
    }

    @Override
    protected void deallocate() {
        this.mImageViewProxy = RefCnt.move(this.mImageViewProxy);
    }

    @Override
    public int prepare(RecordingContext context) {
        if (!this.mImageViewProxy.instantiateIfNonLazy(context.getResourceProvider())) {
            return 1;
        }
        return 0;
    }

    @Override
    public int execute(ImmediateContext context, CommandBuffer commandBuffer) {
        assert (this.mImageViewProxy != null && this.mImageViewProxy.isInstantiated());
        if (this.mUploadCondition != null && !this.mUploadCondition.needsUpload(context)) {
            return 0;
        }
        if (!commandBuffer.copyBufferToImage(this.mBuffer, this.mImageViewProxy.getImage(), this.mSrcColorType, this.mDstColorType, this.mCopyData)) {
            return 1;
        }
        commandBuffer.trackCommandBufferResource(this.mImageViewProxy.refImage());
        if (this.mUploadCondition != null && !this.mUploadCondition.onUploadSubmitted()) {
            return 2;
        }
        return 0;
    }

    static class OnceUploadCondition
    implements UploadCondition {
        public static final UploadCondition INSTANCE = new OnceUploadCondition();

        OnceUploadCondition() {
        }

        @Override
        public boolean needsUpload(ImmediateContext context) {
            return true;
        }

        @Override
        public boolean onUploadSubmitted() {
            return false;
        }
    }

    public static interface UploadCondition {
        public static final boolean PRESERVE = true;
        public static final boolean DISCARD = false;

        public boolean needsUpload(ImmediateContext var1);

        default public boolean onUploadSubmitted() {
            return true;
        }
    }

    public static class MipLevel {
        public Object mBase;
        public long mAddress;
        public int mRowBytes;

        public MipLevel() {
        }

        public MipLevel(Object base, long address, int rowBytes) {
            this.mBase = base;
            this.mAddress = address;
            this.mRowBytes = rowBytes;
        }

        public MipLevel(Pixmap pixmap) {
            this.mBase = pixmap.getBase();
            this.mAddress = pixmap.getAddress();
            this.mRowBytes = pixmap.getRowBytes();
        }

        public MipLevel(Pixels pixels) {
            this.mBase = pixels.getBase();
            this.mAddress = pixels.getAddress();
            this.mRowBytes = pixels.getRowBytes();
        }
    }
}

