/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine.trash;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.SurfaceCharacterization;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.ContextOptions;
import yslelf.cloudpick.render.engine.Device;
import yslelf.cloudpick.render.engine.Engine;
import yslelf.cloudpick.render.engine.SharedResourceCache;
import yslelf.cloudpick.render.engine.ThreadSafeCache;

@Deprecated
public final class SharedContext {
    private static final AtomicInteger sNextID = new AtomicInteger(1);
    private final int mBackend;
    private final ContextOptions mOptions;
    private final int mContextID;
    private volatile Caps mCaps;
    private volatile ThreadSafeCache mThreadSafeCache;
    private volatile SharedResourceCache mSharedResourceCache;
    private final AtomicBoolean mDiscarded = new AtomicBoolean(false);

    private static int createUniqueID() {
        int newValue;
        int value;
        while (!sNextID.weakCompareAndSetVolatile(value, newValue = (value = sNextID.get()) == -1 ? 1 : value + 1)) {
        }
        return value;
    }

    SharedContext(int backend, ContextOptions options) {
        this.mBackend = backend;
        this.mOptions = options;
        this.mContextID = SharedContext.createUniqueID();
    }

    @Nullable
    public SurfaceCharacterization createCharacterization(long cacheMaxResourceBytes, ImageInfo imageInfo, BackendFormat backendFormat, int origin, int sampleCount, boolean texturable, boolean mipmapped, boolean glWrapDefaultFramebuffer, boolean vkSupportInputAttachment, boolean vkSecondaryCommandBuffer, boolean isProtected) {
        assert (this.mCaps != null);
        if (!texturable && mipmapped) {
            return null;
        }
        if (this.mBackend != backendFormat.getBackend()) {
            return null;
        }
        if (backendFormat.getBackend() != 0 && glWrapDefaultFramebuffer) {
            return null;
        }
        if (backendFormat.getBackend() != 1 && (vkSupportInputAttachment || vkSecondaryCommandBuffer)) {
            return null;
        }
        if (imageInfo.width() < 1 || imageInfo.width() > this.mCaps.maxRenderTargetSize() || imageInfo.height() < 1 || imageInfo.height() > this.mCaps.maxRenderTargetSize()) {
            return null;
        }
        int colorType = imageInfo.colorType();
        if (!this.mCaps.isFormatCompatible(colorType, backendFormat)) {
            return null;
        }
        if (!this.mCaps.isFormatRenderable(colorType, backendFormat, sampleCount)) {
            return null;
        }
        sampleCount = this.mCaps.getRenderTargetSampleCount(sampleCount, backendFormat);
        assert (sampleCount > 0);
        if (glWrapDefaultFramebuffer && texturable) {
            return null;
        }
        if (texturable && !this.mCaps.isFormatTexturable(backendFormat)) {
            return null;
        }
        if (vkSecondaryCommandBuffer && (texturable || glWrapDefaultFramebuffer || vkSupportInputAttachment)) {
            return null;
        }
        return new SurfaceCharacterization(this, cacheMaxResourceBytes, imageInfo, backendFormat, origin, sampleCount, texturable, mipmapped, glWrapDefaultFramebuffer, vkSupportInputAttachment, vkSecondaryCommandBuffer, isProtected);
    }

    @Nullable
    public BackendFormat getDefaultBackendFormat(int colorType, boolean renderable) {
        assert (this.mCaps != null);
        BackendFormat format = this.mCaps.getDefaultBackendFormat(colorType = Engine.colorTypeToPublic(colorType), renderable);
        if (format == null) {
            return null;
        }
        assert (!renderable || this.mCaps.isFormatRenderable(colorType, format, 1));
        return format;
    }

    @Nullable
    public BackendFormat getCompressedBackendFormat(int compressionType) {
        assert (this.mCaps != null);
        BackendFormat format = this.mCaps.getCompressedBackendFormat(compressionType);
        assert (format == null || !format.isExternal() && this.mCaps.isFormatTexturable(format));
        return format;
    }

    public int getMaxSurfaceSampleCount(int colorType) {
        assert (this.mCaps != null);
        BackendFormat format = this.mCaps.getDefaultBackendFormat(colorType = Engine.colorTypeToPublic(colorType), true);
        if (format == null) {
            return 0;
        }
        return this.mCaps.getMaxRenderTargetSampleCount(format);
    }

    public boolean isValid() {
        return this.mCaps != null;
    }

    @ApiStatus.Internal
    public boolean matches(Context c) {
        return false;
    }

    @ApiStatus.Internal
    public int getBackend() {
        return this.mBackend;
    }

    @ApiStatus.Internal
    public ContextOptions getOptions() {
        return this.mOptions;
    }

    @ApiStatus.Internal
    public int getContextID() {
        return this.mContextID;
    }

    @ApiStatus.Internal
    public Caps getCaps() {
        return this.mCaps;
    }

    @ApiStatus.Internal
    public ThreadSafeCache getThreadSafeCache() {
        return this.mThreadSafeCache;
    }

    @ApiStatus.Internal
    public SharedResourceCache getPipelineCache() {
        return this.mSharedResourceCache;
    }

    void init(Device device) {
        assert (device != null);
        this.mCaps = device.getCaps();
        this.mThreadSafeCache = new ThreadSafeCache();
        this.mSharedResourceCache = device.getSharedResourceCache();
    }

    boolean discard() {
        return !this.mDiscarded.compareAndExchange(false, true);
    }

    boolean isDiscarded() {
        return this.mDiscarded.get();
    }

    public int hashCode() {
        return this.mContextID;
    }
}

