/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.granite.GlyphAtlasManager;
import yslelf.cloudpick.render.granite.SurfaceDrawContext;

public class AtlasProvider
implements AutoCloseable {
    private final RecordingContext mRC;
    private GlyphAtlasManager mGlyphAtlasManager;

    public AtlasProvider(RecordingContext rc) {
        this.mRC = rc;
        this.mGlyphAtlasManager = new GlyphAtlasManager(rc);
    }

    @Override
    public void close() {
        this.mGlyphAtlasManager.close();
        this.mGlyphAtlasManager = null;
    }

    public GlyphAtlasManager getGlyphAtlasManager() {
        return this.mGlyphAtlasManager;
    }

    public void recordUploads(SurfaceDrawContext sdc) {
        if (!this.mGlyphAtlasManager.recordUploads(sdc)) {
            this.mRC.getLogger().error("GlyphAtlasManager uploads have failed");
        }
    }

    public void freeGpuResources() {
        this.purge();
    }

    public void compact() {
        this.mGlyphAtlasManager.compact();
    }

    public void purge() {
        this.mGlyphAtlasManager.purge();
    }

    public void invalidateAtlases() {
        this.mGlyphAtlasManager.evictAtlases();
    }
}

