/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.core.Canvas;
import yslelf.cloudpick.render.core.GlyphRunList;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.StrikeCache;
import yslelf.cloudpick.render.granite.GraniteDevice;
import yslelf.cloudpick.render.granite.SubRunContainer;
import yslelf.cloudpick.render.granite.TextBlobCache;

public final class BakedTextBlob {
    BakedTextBlob mPrev;
    BakedTextBlob mNext;
    TextBlobCache.PrimaryKey mPrimaryKey;
    TextBlobCache.FeatureKey mFeatureKey;
    private final SubRunContainer mSubRuns;
    private final long mMemorySize;

    public BakedTextBlob(@Nonnull SubRunContainer subRuns) {
        this.mSubRuns = subRuns;
        long size = subRuns.getMemorySize();
        this.mMemorySize = size += 120L;
    }

    @Nonnull
    public static BakedTextBlob make(@Nonnull GlyphRunList glyphRunList, @Nonnull Paint paint, @Nonnull Matrixc positionMatrix, @Nonnull StrikeCache strikeCache) {
        SubRunContainer container = SubRunContainer.make(glyphRunList, positionMatrix, paint, strikeCache);
        return new BakedTextBlob(container);
    }

    public void draw(Canvas canvas, float originX, float originY, Paint paint, GraniteDevice device) {
        this.mSubRuns.draw(canvas, originX, originY, paint, device);
    }

    public long getMemorySize() {
        return this.mMemorySize;
    }
}

