/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2ic;

public final class ClipResult_old
implements Cloneable {
    private int mStencilSeq;
    private int mScissorX0;
    private int mScissorY0;
    private int mScissorX1;
    private int mScissorY1;
    private int mScreenWidth;
    private int mScreenHeight;

    public ClipResult_old init(int logicalWidth, int logicalHeight, int physicalWidth, int physicalHeight) {
        assert (logicalWidth > 0 && logicalHeight > 0);
        assert (physicalWidth > 0 && physicalHeight > 0);
        assert (logicalWidth <= physicalWidth && logicalHeight <= physicalHeight);
        this.mScreenWidth = physicalWidth;
        this.mScreenHeight = physicalHeight;
        this.setScissor(0, 0, logicalWidth, logicalHeight);
        this.mStencilSeq = 0;
        return this;
    }

    public boolean addScissor(Rect2ic rect, Rect2f clippedBounds) {
        return this.intersect(rect.left(), rect.top(), rect.right(), rect.bottom()) && clippedBounds.intersect(rect);
    }

    public void setScissor(int l2, int t2, int r, int b) {
        this.mScissorX0 = 0;
        this.mScissorY0 = 0;
        this.mScissorX1 = this.mScreenWidth;
        this.mScissorY1 = this.mScreenHeight;
        this.intersect(l2, t2, r, b);
    }

    private boolean intersect(int l2, int t2, int r, int b) {
        int tmpL = Math.max(this.mScissorX0, l2);
        int tmpT = Math.max(this.mScissorY0, t2);
        int tmpR = Math.min(this.mScissorX1, r);
        int tmpB = Math.min(this.mScissorY1, b);
        if (tmpR <= tmpL || tmpB <= tmpT) {
            this.mScissorX0 = 0;
            this.mScissorY0 = 0;
            this.mScissorX1 = 0;
            this.mScissorY1 = 0;
            return false;
        }
        this.mScissorX0 = tmpL;
        this.mScissorY0 = tmpT;
        this.mScissorX1 = tmpR;
        this.mScissorY1 = tmpB;
        return true;
    }

    public boolean hasScissorClip() {
        return this.mScissorX0 > 0 || this.mScissorY0 > 0 || this.mScissorX1 < this.mScreenWidth || this.mScissorY1 < this.mScreenHeight;
    }

    public int getScissorX0() {
        return this.mScissorX0;
    }

    public int getScissorY0() {
        return this.mScissorY0;
    }

    public int getScissorX1() {
        return this.mScissorX1;
    }

    public int getScissorY1() {
        return this.mScissorY1;
    }

    public void setStencil(int seq) {
        assert (this.mStencilSeq == 0);
        this.mStencilSeq = seq;
    }

    public boolean hasStencilClip() {
        return this.mStencilSeq != 0;
    }

    public int getStencilSeq() {
        return this.mStencilSeq;
    }

    public boolean hasClip() {
        return this.hasScissorClip() || this.hasStencilClip();
    }

    public int hashCode() {
        int h2 = this.mStencilSeq;
        h2 = 31 * h2 + this.mScissorX0;
        h2 = 31 * h2 + this.mScissorY0;
        h2 = 31 * h2 + this.mScissorX1;
        h2 = 31 * h2 + this.mScissorY1;
        h2 = 31 * h2 + this.mScreenWidth;
        h2 = 31 * h2 + this.mScreenHeight;
        return h2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClipResult_old other = (ClipResult_old)o;
        return this.mStencilSeq == other.mStencilSeq && this.mScissorX0 == other.mScissorX0 && this.mScissorY0 == other.mScissorY0 && this.mScissorX1 == other.mScissorX1 && this.mScissorY1 == other.mScissorY1 && this.mScreenWidth == other.mScreenWidth && this.mScreenHeight == other.mScreenHeight;
    }

    public ClipResult_old clone() {
        try {
            return (ClipResult_old)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

