/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.PixelUtils;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.RectanglePacker;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.ImageDesc;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.task.ImageUploadTask;
import yslelf.cloudpick.render.granite.SurfaceDrawContext;

public class DrawAtlas
implements AutoCloseable {
    private final Page[] mPages;
    private int mNumActivePages;
    private final int mColorType;
    private final int mBytesPerPixel;
    private final int mTextureWidth;
    private final int mTextureHeight;
    private final int mPlotWidth;
    private final int mPlotHeight;
    private final int mNumPlots;
    private final boolean mUseStorageTextures;
    private final String mLabel;
    private final AtlasGenerationCounter mGenerationCounter;
    private long mAtlasGeneration;
    private PlotEvictionCallback mEvictionCallback;
    private long mPrevFlushToken;
    private int mFlushesSinceLastUsed;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE = 1;
    public static final int RESULT_TRY_AGAIN = 2;
    private static final int kPlotRecentlyUsedCount = 300;
    private static final int kAtlasRecentlyUsedCount = 1200;

    public DrawAtlas(int ct, int width, int height, int plotWidth, int plotHeight, @Nonnull AtlasGenerationCounter generationCounter, boolean useMultiPages, boolean useStorageTextures, String label) {
        this.mColorType = ct;
        this.mBytesPerPixel = ColorInfo.bytesPerPixel(ct);
        assert (MathUtil.isPow2(width) && MathUtil.isPow2(height));
        int numPlotsX = width / plotWidth;
        int numPlotsY = height / plotHeight;
        int numPlots = numPlotsX * numPlotsY;
        assert (numPlots <= 64);
        assert (plotWidth * numPlotsX == width);
        assert (plotHeight * numPlotsY == height);
        this.mTextureWidth = width;
        this.mTextureHeight = height;
        this.mPlotWidth = plotWidth;
        this.mPlotHeight = plotHeight;
        this.mNumPlots = numPlots;
        this.mUseStorageTextures = useStorageTextures;
        this.mLabel = label;
        this.mGenerationCounter = generationCounter;
        this.mAtlasGeneration = generationCounter.next();
        this.mPrevFlushToken = 0L;
        this.mFlushesSinceLastUsed = 0;
        this.mPages = new Page[useMultiPages ? 4 : 1];
        for (int pageIndex = 0; pageIndex < this.mPages.length; ++pageIndex) {
            Page page = this.mPages[pageIndex] = new Page();
            page.mPlots = new Plot[numPlots];
            int i = 0;
            int y = numPlotsY - 1;
            int r = 0;
            while (y >= 0) {
                int x = numPlotsX - 1;
                int c = 0;
                while (x >= 0) {
                    int plotIndex = r * numPlotsX + c;
                    Plot plot = new Plot(pageIndex, plotIndex, generationCounter, x, y, this.mPlotWidth, this.mPlotHeight, this.mColorType, this.mBytesPerPixel);
                    assert (i == plotIndex);
                    page.mPlots[i++] = plot;
                    page.addToHead(plot);
                    --x;
                    ++c;
                }
                --y;
                ++r;
            }
            assert (i == numPlots);
        }
    }

    @Nonnull
    public static DrawAtlas make(int ct, int width, int height, int plotWidth, int plotHeight, @Nonnull AtlasGenerationCounter generationCounter, boolean useMultiPages, boolean useStorageTextures, PlotEvictionCallback evictor, String label) {
        DrawAtlas atlas = new DrawAtlas(ct, width, height, plotWidth, plotHeight, generationCounter, useMultiPages, useStorageTextures, label);
        if (evictor != null) {
            atlas.mEvictionCallback = evictor;
        }
        return atlas;
    }

    @Override
    public void close() {
        for (Page page : this.mPages) {
            for (Plot plot : page.mPlots) {
                plot.close();
            }
            page.mPlots = null;
            page.mTexture = RefCnt.move(page.mTexture);
        }
    }

    public int addRect(@Nonnull RecordingContext context, int width, int height, @Nonnull AtlasLocator atlasLocator) {
        int pageIndex;
        if (width > this.mPlotWidth || height > this.mPlotHeight || width < 0 || height < 0) {
            return 1;
        }
        if (width == 0 || height == 0) {
            if (this.mNumActivePages == 0 && !this.activateNextPage(context)) {
                return 1;
            }
            atlasLocator.setRect(Rect2i.empty());
            atlasLocator.setLocation(this.mPages[0].mHead);
            return 0;
        }
        for (pageIndex = 0; pageIndex < this.mNumActivePages; ++pageIndex) {
            if (!this.addRectToPage(pageIndex, width, height, atlasLocator)) continue;
            return 0;
        }
        if (this.mNumActivePages < this.getMaxPages() && this.activateNextPage(context)) {
            if (this.addRectToPage(this.mNumActivePages - 1, width, height, atlasLocator)) {
                return 0;
            }
            assert (false);
            return 1;
        }
        if (this.mNumActivePages == 0) {
            return 1;
        }
        for (pageIndex = 0; pageIndex < this.mNumActivePages; ++pageIndex) {
            Page page = this.mPages[pageIndex];
            Plot plot = page.mTail;
            if (AtlasToken.compare(plot.getLastUseToken(), context.getAtlasTokenTracker().nextFlushToken()) >= 0) continue;
            this.evictAndReset(plot);
            if (plot.addRect(width, height, atlasLocator)) {
                page.moveToHead(plot);
                atlasLocator.setLocation(plot);
                return 0;
            }
            assert (false);
            return 1;
        }
        return 2;
    }

    public long getDataAt(@Nonnull AtlasLocator atlasLocator) {
        Plot plot = this.getPlot(atlasLocator);
        return plot.dataAt(atlasLocator);
    }

    public int addToAtlas(@Nonnull RecordingContext context, int width, int height, Object imageBase, long imageAddr, @Nonnull AtlasLocator atlasLocator) {
        int res = this.addRect(context, width, height, atlasLocator);
        if (res == 0) {
            Plot plot = this.getPlot(atlasLocator);
            plot.copySubImage(atlasLocator, imageBase, imageAddr);
        }
        return res;
    }

    public boolean recordUploads(RecordingContext context, SurfaceDrawContext sdc) {
        for (int pageIndex = 0; pageIndex < this.mNumActivePages; ++pageIndex) {
            Page page = this.mPages[pageIndex];
            Plot plot = page.mHead;
            while (plot != null) {
                if (plot.needsUpload()) {
                    ImageViewProxy texture = page.mTexture;
                    assert (texture != null);
                    Rect2i dstRect = new Rect2i();
                    long dataPtr = plot.prepareForUpload(dstRect);
                    if (!dstRect.isEmpty()) {
                        ImageUploadTask.MipLevel[] levels = new ImageUploadTask.MipLevel[]{new ImageUploadTask.MipLevel(null, dataPtr, this.mBytesPerPixel * this.mPlotWidth)};
                        if (!sdc.recordUpload(context, RefCnt.create(texture), this.mColorType, 2, null, this.mColorType, 2, null, levels, dstRect, null)) {
                            return false;
                        }
                    }
                }
                plot = plot.mNext;
            }
        }
        return true;
    }

    @RawPtr
    public ImageViewProxy getTexture(int pageIndex) {
        return this.mPages[pageIndex].mTexture;
    }

    public long getAtlasGeneration() {
        return this.mAtlasGeneration;
    }

    public int getNumActivePages() {
        return this.mNumActivePages;
    }

    public int getNumPlots() {
        return this.mNumPlots;
    }

    public int getMaxPages() {
        return this.mPages.length;
    }

    public int getPlotWidth() {
        return this.mPlotWidth;
    }

    public int getPlotHeight() {
        return this.mPlotHeight;
    }

    public boolean contains(@Nonnull PlotLocator plotLocator) {
        if (!plotLocator.isValid()) {
            return false;
        }
        int plotIndex = plotLocator.getPlotIndex();
        int pageIndex = plotLocator.getPageIndex();
        long plotGeneration = this.mPages[pageIndex].mPlots[plotIndex].getGeneration();
        long locatorGeneration = plotLocator.getGeneration();
        return plotIndex < this.mNumPlots && pageIndex < this.mNumActivePages && plotGeneration == locatorGeneration;
    }

    public void setLastUseToken(@Nonnull AtlasLocator atlasLocator, long token) {
        assert (this.contains(atlasLocator));
        int plotIndex = atlasLocator.getPlotIndex();
        int pageIndex = atlasLocator.getPageIndex();
        Page page = this.mPages[pageIndex];
        Plot plot = page.mPlots[plotIndex];
        page.moveToHead(plot);
        plot.setLastUseToken(token);
    }

    public void setLastUseTokenBulk(@Nonnull PlotBulkUseUpdater updater, long token) {
        int count = updater.count();
        for (int i = 0; i < count; ++i) {
            int data = updater.dataAt(i);
            int plotIndex = data & 0xFFFF;
            int pageIndex = data >>> 16;
            if (pageIndex >= this.mNumActivePages) continue;
            Page page = this.mPages[pageIndex];
            Plot plot = page.mPlots[plotIndex];
            page.moveToHead(plot);
            plot.setLastUseToken(token);
        }
    }

    public void compact(long startTokenForNextFlush) {
        if (this.mNumActivePages == 0) {
            this.mPrevFlushToken = startTokenForNextFlush;
            return;
        }
        boolean atlasUsedThisFlush = false;
        for (int pageIndex = 0; pageIndex < this.mNumActivePages; ++pageIndex) {
            Page page = this.mPages[pageIndex];
            Plot plot = page.mHead;
            while (plot != null) {
                if (AtlasToken.inInterval(plot.getLastUseToken(), this.mPrevFlushToken, startTokenForNextFlush)) {
                    plot.resetFlushesSinceLastUsed();
                    atlasUsedThisFlush = true;
                }
                plot = plot.mNext;
            }
        }
        this.mFlushesSinceLastUsed = atlasUsedThisFlush ? 0 : ++this.mFlushesSinceLastUsed;
        if (atlasUsedThisFlush || this.mFlushesSinceLastUsed > 1200) {
            Plot plot;
            ObjectArrayList availablePlots = null;
            int lastPageIndex = this.mNumActivePages - 1;
            if (lastPageIndex > 0) {
                availablePlots = new ObjectArrayList();
                for (int pageIndex = 0; pageIndex < lastPageIndex; ++pageIndex) {
                    Page page = this.mPages[pageIndex];
                    plot = page.mHead;
                    while (plot != null) {
                        if (!AtlasToken.inInterval(plot.getLastUseToken(), this.mPrevFlushToken, startTokenForNextFlush)) {
                            plot.incFlushesSinceLastUsed();
                        }
                        if (plot.numFlushesSinceLastUsed() > 300) {
                            availablePlots.push((Object)plot);
                        }
                        plot = plot.mNext;
                    }
                }
            }
            Page lastPage = this.mPages[lastPageIndex];
            int usedPlots = 0;
            plot = lastPage.mHead;
            while (plot != null) {
                if (!AtlasToken.inInterval(plot.getLastUseToken(), this.mPrevFlushToken, startTokenForNextFlush)) {
                    plot.incFlushesSinceLastUsed();
                }
                if (plot.numFlushesSinceLastUsed() <= 300) {
                    ++usedPlots;
                } else if (plot.getLastUseToken() != 0L) {
                    this.evictAndReset(plot);
                }
                plot = plot.mNext;
            }
            if (availablePlots != null && !availablePlots.isEmpty() && usedPlots <= this.mNumPlots / 4) {
                plot = lastPage.mHead;
                while (plot != null) {
                    if (plot.numFlushesSinceLastUsed() <= 300) {
                        if (!availablePlots.isEmpty()) {
                            this.evictAndReset(plot);
                            this.evictAndReset((Plot)availablePlots.pop());
                            --usedPlots;
                        }
                        if (usedPlots == 0 || availablePlots.isEmpty()) break;
                    }
                    plot = plot.mNext;
                }
            }
            if (usedPlots == 0) {
                this.deactivateLastPage();
                this.mFlushesSinceLastUsed = 0;
            }
        }
        this.mPrevFlushToken = startTokenForNextFlush;
    }

    public void purge(long startTokenForNextFlush) {
        boolean atlasUsedThisFlush = false;
        for (int pageIndex = this.mNumActivePages - 1; pageIndex >= 0; --pageIndex) {
            Page page = this.mPages[pageIndex];
            Plot plot = page.mHead;
            while (plot != null) {
                if (AtlasToken.inInterval(plot.getLastUseToken(), this.mPrevFlushToken, startTokenForNextFlush)) {
                    plot.resetFlushesSinceLastUsed();
                    atlasUsedThisFlush = true;
                } else {
                    this.evictAndReset(plot);
                }
                plot = plot.mNext;
            }
            if (atlasUsedThisFlush) continue;
            this.deactivateLastPage();
        }
        this.mFlushesSinceLastUsed = 0;
        this.mPrevFlushToken = startTokenForNextFlush;
    }

    public void evictAllPlots() {
        for (int pageIndex = 0; pageIndex < this.mNumActivePages; ++pageIndex) {
            Page page = this.mPages[pageIndex];
            Plot plot = page.mHead;
            while (plot != null) {
                this.evictAndReset(plot);
                plot = plot.mNext;
            }
        }
    }

    private Plot getPlot(@Nonnull AtlasLocator atlasLocator) {
        assert (this.contains(atlasLocator));
        int plotIndex = atlasLocator.getPlotIndex();
        int pageIndex = atlasLocator.getPageIndex();
        return this.mPages[pageIndex].mPlots[plotIndex];
    }

    private boolean activateNextPage(@Nonnull RecordingContext context) {
        assert (this.mNumActivePages < this.getMaxPages());
        assert (this.mPages[this.mNumActivePages].mTexture == null);
        Caps caps = context.getCaps();
        ImageDesc desc = caps.getDefaultColorImageDesc(1, this.mColorType, this.mTextureWidth, this.mTextureHeight, 1, 8 | (this.mUseStorageTextures ? 16 : 0));
        if (desc == null) {
            return false;
        }
        this.mPages[this.mNumActivePages].mTexture = ImageViewProxy.make(context, desc, 0, (short)12816, true, this.mLabel);
        if (this.mPages[this.mNumActivePages].mTexture == null) {
            return false;
        }
        ++this.mNumActivePages;
        return true;
    }

    private void deactivateLastPage() {
        assert (this.mNumActivePages > 0);
        Page lastPage = this.mPages[this.mNumActivePages - 1];
        int numPlotsX = this.mTextureWidth / this.mPlotWidth;
        int numPlotsY = this.mTextureHeight / this.mPlotHeight;
        lastPage.mHead = null;
        lastPage.mTail = null;
        for (int r = 0; r < numPlotsY; ++r) {
            for (int c = 0; c < numPlotsX; ++c) {
                int plotIndex = r * numPlotsX + c;
                Plot currPlot = lastPage.mPlots[plotIndex];
                currPlot.clear();
                currPlot.resetFlushesSinceLastUsed();
                lastPage.addToHead(currPlot);
            }
        }
        lastPage.mTexture = RefCnt.move(lastPage.mTexture);
        --this.mNumActivePages;
    }

    private boolean addRectToPage(int pageIndex, int width, int height, AtlasLocator atlasLocator) {
        assert (this.mPages[pageIndex].mTexture != null);
        Page page = this.mPages[pageIndex];
        Plot plot = page.mHead;
        while (plot != null) {
            if (plot.addRect(width, height, atlasLocator)) {
                page.moveToHead(plot);
                atlasLocator.setLocation(plot);
                return true;
            }
            plot = plot.mNext;
        }
        return false;
    }

    private void evictAndReset(Plot plot) {
        if (this.mEvictionCallback != null) {
            this.mEvictionCallback.onEvict(plot);
        }
        this.mAtlasGeneration = this.mGenerationCounter.next();
        plot.clear();
    }

    public static class PlotLocator {
        public static final int MAX_PAGES = 4;
        public static final int MAX_PLOTS = 64;
        private long loc;

        public long getGeneration() {
            return this.loc & 0xFFFFFFFFFFFFL;
        }

        public int getPlotIndex() {
            return (int)(this.loc >> 48) & 0xFFFF;
        }

        public int getPageIndex() {
            return (int)(this.loc >>> 56);
        }

        public boolean isValid() {
            return this.loc != 0L;
        }

        public void setLocation(@Nonnull PlotLocator plotLocator) {
            this.loc = plotLocator.loc;
        }

        public void setLocation(int pageIndex, int plotIndex, long generation) {
            assert (pageIndex < 4);
            assert (plotIndex < 64);
            assert (generation < 0x1000000000000L);
            this.loc = (long)pageIndex << 56 | (long)plotIndex << 48 | generation;
        }

        public void setGeneration(long generation) {
            assert (generation < 0x1000000000000L);
            this.loc = this.loc & 0xFFFF000000000000L | generation;
        }

        public String toString() {
            return "PlotLocator{generation=" + this.getGeneration() + ", plotIndex=" + this.getPlotIndex() + ", pageIndex=" + this.getPageIndex() + "}";
        }
    }

    public static class AtlasGenerationCounter {
        public static final long INVALID_GENERATION = 0L;
        public static final long MAX_GENERATION = 0xFFFFFFFFFFFFL;
        private long mGeneration = 1L;

        public long next() {
            if (this.mGeneration > 0xFFFFFFFFFFFFL) {
                this.mGeneration = 1L;
            }
            return this.mGeneration++;
        }
    }

    public static class AtlasToken {
        public static final long INVALID_TOKEN = 0L;

        public static long next(long token) {
            long next = token + 1L;
            if (next == 0L) {
                return 1L;
            }
            return next;
        }

        public static int compare(long lhs, long rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (lhs == 0L) {
                return -1;
            }
            if (rhs == 0L) {
                return 1;
            }
            return rhs - lhs > 0L ? -1 : 1;
        }

        public static boolean inInterval(long token, long start, long end) {
            assert (end != 0L);
            if (start == 0L) {
                return true;
            }
            if (token == 0L) {
                return false;
            }
            return token - start >= 0L && end - token >= 0L;
        }

        private AtlasToken() {
        }
    }

    private static class Page {
        Plot[] mPlots;
        Plot mHead;
        Plot mTail;
        @SharedPtr
        ImageViewProxy mTexture;

        Page() {
        }

        void addToHead(Plot entry) {
            entry.mPrev = null;
            entry.mNext = this.mHead;
            if (this.mHead != null) {
                this.mHead.mPrev = entry;
            }
            this.mHead = entry;
            if (this.mTail == null) {
                this.mTail = entry;
            }
        }

        void moveToHead(Plot entry) {
            assert (this.mHead != null && this.mTail != null);
            if (this.mHead == entry) {
                return;
            }
            Plot prev = entry.mPrev;
            Plot next = entry.mNext;
            if (prev != null) {
                prev.mNext = next;
            } else {
                this.mHead = next;
            }
            if (next != null) {
                next.mPrev = prev;
            } else {
                this.mTail = prev;
            }
            entry.mPrev = null;
            entry.mNext = this.mHead;
            if (this.mHead != null) {
                this.mHead.mPrev = entry;
            }
            this.mHead = entry;
            if (this.mTail == null) {
                this.mTail = entry;
            }
        }
    }

    public static class Plot
    extends PlotLocator
    implements AutoCloseable {
        private Plot mPrev;
        private Plot mNext;
        private long mLastUseToken = 0L;
        private int mFlushesSinceLastUsed = 0;
        private final AtlasGenerationCounter mGenerationCounter;
        private long mData;
        private final int mWidth;
        private final int mHeight;
        private final RectanglePacker.Skyline mRectanglePacker;
        private final int mOffsetX;
        private final int mOffsetY;
        private final int mColorType;
        private final int mBytesPerPixel;
        private final Rect2i mDirtyRect = new Rect2i();
        private final Rect2i mTmpRect = new Rect2i();

        public Plot(int pageIndex, int plotIndex, AtlasGenerationCounter generationCounter, int plotX, int plotY, int width, int height, int colorType, int bpp) {
            this.mGenerationCounter = generationCounter;
            this.setLocation(pageIndex, plotIndex, generationCounter.next());
            this.mData = 0L;
            this.mWidth = width;
            this.mHeight = height;
            this.mRectanglePacker = new RectanglePacker.Skyline(width, height);
            this.mOffsetX = plotX * width;
            this.mOffsetY = plotY * height;
            this.mColorType = colorType;
            this.mBytesPerPixel = bpp;
            assert (MathUtil.isAlign4(width * bpp));
            assert (bpp == 1 || bpp == 2 || bpp == 4);
        }

        @Override
        public void close() {
            if (this.mData != 0L) {
                MemoryUtil.nmemFree((long)this.mData);
            }
            this.mData = 0L;
        }

        public boolean addRect(int width, int height, AtlasLocator atlasLocator) {
            assert (width <= this.mWidth && height <= this.mHeight);
            Rect2i rect = this.mTmpRect;
            rect.set(0, 0, width, height);
            if (!this.mRectanglePacker.addRect(rect)) {
                return false;
            }
            this.mDirtyRect.join(rect);
            rect.offset(this.mOffsetX, this.mOffsetY);
            atlasLocator.setRect(rect);
            return true;
        }

        public long dataAt(AtlasLocator atlasLocator) {
            long bpp = this.mBytesPerPixel;
            if (this.mData == 0L) {
                this.mData = MemoryUtil.nmemAlloc((long)(bpp * (long)this.mWidth * (long)this.mHeight));
                if (this.mData == 0L) {
                    throw new OutOfMemoryError();
                }
            }
            long dataPtr = this.mData;
            int x = atlasLocator.u1 & 0xFFFF;
            int y = atlasLocator.v1 & 0xFFFF;
            assert (x >= this.mOffsetX && x < this.mOffsetX + this.mWidth && y >= this.mOffsetY && y < this.mOffsetY + this.mHeight);
            dataPtr += bpp * (long)this.mWidth * (long)(y -= this.mOffsetY);
            return dataPtr += bpp * (long)(x -= this.mOffsetX);
        }

        public void copySubImage(AtlasLocator atlasLocator, Object srcBase, long srcAddr) {
            long bpp = this.mBytesPerPixel;
            long dstAddr = this.dataAt(atlasLocator);
            int w = atlasLocator.width() & 0xFFFF;
            int h2 = atlasLocator.height() & 0xFFFF;
            PixelUtils.copyImage(srcBase, srcAddr, bpp * (long)w, null, dstAddr, bpp * (long)this.mWidth, bpp * (long)w, h2);
        }

        public long getLastUseToken() {
            return this.mLastUseToken;
        }

        public void setLastUseToken(long token) {
            assert (token != 0L);
            this.mLastUseToken = token;
        }

        public int numFlushesSinceLastUsed() {
            return this.mFlushesSinceLastUsed;
        }

        public void incFlushesSinceLastUsed() {
            ++this.mFlushesSinceLastUsed;
        }

        public void resetFlushesSinceLastUsed() {
            this.mFlushesSinceLastUsed = 0;
        }

        public boolean needsUpload() {
            return !this.mDirtyRect.isEmpty();
        }

        public long prepareForUpload(Rect2i outRect) {
            assert (this.needsUpload());
            if (this.mData == 0L) {
                outRect.setEmpty();
                return 0L;
            }
            int clearBits = 3 / this.mBytesPerPixel;
            this.mDirtyRect.mLeft &= ~clearBits;
            this.mDirtyRect.mRight += clearBits;
            this.mDirtyRect.mRight &= ~clearBits;
            assert (this.mDirtyRect.mRight <= this.mWidth);
            long dstAddr = this.mData;
            dstAddr += (long)this.mBytesPerPixel * (long)this.mWidth * (long)this.mDirtyRect.y();
            outRect.set(this.mDirtyRect);
            outRect.offset(this.mOffsetX, this.mOffsetY);
            this.mDirtyRect.setEmpty();
            return dstAddr += (long)this.mBytesPerPixel * (long)this.mDirtyRect.x();
        }

        public void clear() {
            this.mRectanglePacker.clear();
            this.setGeneration(this.mGenerationCounter.next());
            this.mLastUseToken = 0L;
            if (this.mData != 0L) {
                MemoryUtil.memSet((long)this.mData, (int)0, (long)((long)this.mBytesPerPixel * (long)this.mWidth * (long)this.mHeight));
            }
            this.mDirtyRect.setEmpty();
        }
    }

    public static interface PlotEvictionCallback {
        public void onEvict(PlotLocator var1);
    }

    public static class AtlasLocator
    extends PlotLocator {
        public short u1;
        public short v1;
        public short u2;
        public short v2;

        public short width() {
            return (short)(this.u2 - this.u1);
        }

        public short height() {
            return (short)(this.v2 - this.v1);
        }

        public void setRect(Rect2ic rect) {
            assert (rect.left() >= 0 && rect.right() <= 65535);
            this.u1 = (short)rect.left();
            this.v1 = (short)rect.top();
            this.u2 = (short)rect.right();
            this.v2 = (short)rect.bottom();
        }

        public void insetRect(int padding) {
            assert (padding >= 0);
            assert (2 * padding <= (this.width() & 0xFFFF));
            assert (2 * padding <= (this.height() & 0xFFFF));
            this.u1 = (short)(this.u1 + (short)padding);
            this.v1 = (short)(this.v1 + (short)padding);
            this.u2 = (short)(this.u2 - (short)padding);
            this.v2 = (short)(this.v2 - (short)padding);
        }

        @Override
        public String toString() {
            return "AtlasLocator{generation=" + this.getGeneration() + ", plotIndex=" + this.getPlotIndex() + ", pageIndex=" + this.getPageIndex() + ", u1=" + Short.toUnsignedInt(this.u1) + ", v1=" + Short.toUnsignedInt(this.v1) + ", u2=" + Short.toUnsignedInt(this.u2) + ", v2=" + Short.toUnsignedInt(this.v2) + "}";
        }
    }

    public static class AtlasTokenTracker {
        private long mCurrentFlushToken = 0L;

        public long nextFlushToken() {
            return AtlasToken.next(this.mCurrentFlushToken);
        }

        public void issueFlushToken() {
            this.mCurrentFlushToken = AtlasToken.next(this.mCurrentFlushToken);
        }
    }

    public static class PlotBulkUseUpdater {
        private final long[] mBitSet = new long[4];
        private int[] mData = new int[4];
        private int mCount = 0;

        public boolean add(AtlasLocator locator) {
            int plotIndex = locator.getPlotIndex();
            int pageIndex = locator.getPageIndex();
            assert (plotIndex < 64);
            assert (pageIndex < 4);
            if ((this.mBitSet[pageIndex] >>> plotIndex & 1L) != 0L) {
                return false;
            }
            int n2 = pageIndex;
            this.mBitSet[n2] = this.mBitSet[n2] | 1L << plotIndex;
            if (this.mCount >= this.mData.length) {
                this.mData = Arrays.copyOf(this.mData, this.mData.length << 1);
            }
            this.mData[this.mCount++] = plotIndex | pageIndex << 16;
            return true;
        }

        public void clear() {
            this.mCount = 0;
            Arrays.fill(this.mBitSet, 0L);
        }

        public int count() {
            return this.mCount;
        }

        public int dataAt(int index) {
            return this.mData[index];
        }

        public long getMemorySize() {
            long size = 16L;
            size += 16L + (long)this.mBitSet.length * 8L + 8L;
            return size += 16L + (long)this.mData.length * 4L + 8L;
        }
    }
}

