/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.BufferViewInfo;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.Resource;
import yslelf.cloudpick.render.engine.ResourceProvider;
import yslelf.cloudpick.render.engine.task.Task;

public class DrawBufferManager {
    public static final int VERTEX_BUFFER_SIZE = 131072;
    public static final int INDEX_BUFFER_SIZE = 8192;
    public static final int UNIFORM_BUFFER_SIZE = 32768;
    static final int kVertexBufferIndex = 0;
    static final int kIndexBufferIndex = 1;
    static final int kUniformBufferIndex = 2;
    final BlockBuffer[] mCurrentBuffers = new BlockBuffer[3];
    final ObjectArrayList<@SharedPtr Buffer> mUsedBuffers = new ObjectArrayList();
    private final ResourceProvider mResourceProvider;
    private boolean mMappingFailed = false;

    public DrawBufferManager(Caps caps, ResourceProvider resourceProvider) {
        this.mResourceProvider = resourceProvider;
        this.mCurrentBuffers[0] = new BlockBuffer(caps, 131073, 131072);
        this.mCurrentBuffers[1] = new BlockBuffer(caps, 131074, 8192);
        this.mCurrentBuffers[2] = new BlockBuffer(caps, 131104, 32768);
    }

    public long getVertexPointer(int requiredBytes, BufferViewInfo outInfo) {
        return this.prepareMappedPointer(this.mCurrentBuffers[0], requiredBytes, outInfo, "DirectVertexBuffer");
    }

    public long getUniformPointer(int requiredBytes, BufferViewInfo outInfo) {
        return this.prepareMappedPointer(this.mCurrentBuffers[2], requiredBytes, outInfo, "DirectUniformBuffer");
    }

    public void putBackVertexBytes(int unusedBytes) {
    }

    public int alignUniformBlockSize(int dataSize) {
        return MathUtil.alignTo(dataSize, this.mCurrentBuffers[2].mOffsetAlignment);
    }

    private long prepareMappedPointer(BlockBuffer target, int requiredBytes, BufferViewInfo outInfo, String label) {
        assert ((target.mUsage & 0x20000) != 0);
        this.prepareBuffer(target, requiredBytes, outInfo, label);
        if (outInfo.mBuffer == null) {
            assert (this.mMappingFailed);
            return 0L;
        }
        assert (!this.mMappingFailed);
        assert (outInfo.mBuffer == target.mBuffer);
        assert (outInfo.mBuffer.isMapped());
        long mappedPointer = outInfo.mBuffer.getMappedBuffer();
        assert (mappedPointer != 0L);
        return mappedPointer + outInfo.mOffset;
    }

    private void prepareBuffer(BlockBuffer target, int requiredBytes, BufferViewInfo outInfo, String label) {
        assert (requiredBytes > 0);
        if (this.mMappingFailed) {
            outInfo.set(null);
            return;
        }
        int startOffset = -1;
        if (target.mBuffer != null && ((startOffset = MathUtil.alignTo(target.mOffset, target.mOffsetAlignment)) < 0 || (long)startOffset > target.mBuffer.getSize() - (long)requiredBytes)) {
            this.mUsedBuffers.add((Object)target.mBuffer);
            target.mBuffer = null;
            startOffset = -1;
        }
        if (target.mBuffer == null) {
            long mappedPtr;
            long bufferSize = Math.min(MathUtil.alignTo(requiredBytes, target.mBlockSize), Integer.MAX_VALUE);
            target.mBuffer = this.mResourceProvider.findOrCreateBuffer(bufferSize, target.mUsage, label);
            target.mOffset = 0;
            if (target.mBuffer == null) {
                this.setMappingFailed();
                outInfo.set(null);
                return;
            }
            if ((target.mUsage & 0x20000) != 0 && (mappedPtr = target.mBuffer.map()) == 0L) {
                this.setMappingFailed();
                outInfo.set(null);
                return;
            }
        }
        if (startOffset == -1) {
            startOffset = MathUtil.alignTo(target.mOffset, target.mOffsetAlignment);
        }
        outInfo.mBuffer = target.mBuffer;
        outInfo.mOffset = startOffset;
        outInfo.mSize = requiredBytes;
        target.mOffset = startOffset + requiredBytes;
    }

    private void setMappingFailed() {
        this.mMappingFailed = true;
        for (Buffer buffer : this.mUsedBuffers) {
            if (buffer.isMapped()) {
                buffer.unmap(0L);
            }
            buffer.unref();
        }
        this.mUsedBuffers.clear();
        for (BlockBuffer target : this.mCurrentBuffers) {
            target.mOffset = 0;
            if (target.mBuffer == null) continue;
            if (target.mBuffer.isMapped()) {
                target.mBuffer.unmap(0L);
            }
            target.mBuffer = RefCnt.move(target.mBuffer);
        }
    }

    public boolean hasMappingFailed() {
        return this.mMappingFailed;
    }

    public void flush(Consumer<@SharedPtr Task> outTasks, List<@SharedPtr Resource> outResourceRefs) {
        assert (!this.mMappingFailed);
        for (Buffer buffer : this.mUsedBuffers) {
            if (!buffer.isMapped()) continue;
            buffer.unmap();
        }
        outResourceRefs.addAll((Collection<Resource>)this.mUsedBuffers);
        this.mUsedBuffers.clear();
        for (BlockBuffer target : this.mCurrentBuffers) {
            target.mOffset = 0;
            if (target.mBuffer == null) continue;
            if (target.mBuffer.isMapped()) {
                target.mBuffer.unmap();
            }
            outResourceRefs.add(target.mBuffer);
            target.mBuffer = null;
        }
    }

    private static class BlockBuffer {
        final int mUsage;
        final int mOffsetAlignment;
        final int mBlockSize;
        @SharedPtr
        Buffer mBuffer;
        int mOffset;

        BlockBuffer(Caps caps, int usage, int blockSize) {
            this.mUsage = usage;
            this.mBlockSize = blockSize;
            this.mOffsetAlignment = (usage & 0x20) != 0 ? caps.minUniformBufferOffsetAlignment() : 4;
        }
    }
}

