/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.PrintWriter;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.BufferViewInfo;

public class DrawCommandList {
    public static final int CMD_BIND_GRAPHICS_PIPELINE = 0;
    public static final int CMD_DRAW = 1;
    public static final int CMD_DRAW_INDEXED = 2;
    public static final int CMD_DRAW_INSTANCED = 3;
    public static final int CMD_DRAW_INDEXED_INSTANCED = 4;
    public static final int CMD_BIND_INDEX_BUFFER = 5;
    public static final int CMD_BIND_VERTEX_BUFFER = 6;
    public static final int CMD_SET_SCISSOR = 7;
    public static final int CMD_BIND_UNIFORM_BUFFER = 8;
    public static final int CMD_BIND_TEXTURES = 9;
    public final IntArrayList mPrimitives = new IntArrayList(128);
    public final ObjectArrayList<Object> mPointers = new ObjectArrayList();

    public void bindGraphicsPipeline(int pipelineIndex) {
        this.mPrimitives.add(0);
        this.mPrimitives.add(pipelineIndex);
    }

    public void draw(int vertexCount, int baseVertex) {
        this.mPrimitives.add(1);
        this.mPrimitives.add(vertexCount);
        this.mPrimitives.add(baseVertex);
    }

    public final void drawIndexed(int indexCount, int baseIndex, int baseVertex) {
        this.mPrimitives.add(2);
        this.mPrimitives.add(indexCount);
        this.mPrimitives.add(baseIndex);
        this.mPrimitives.add(baseVertex);
    }

    public final void drawInstanced(int instanceCount, int baseInstance, int vertexCount, int baseVertex) {
        this.mPrimitives.add(3);
        this.mPrimitives.add(instanceCount);
        this.mPrimitives.add(baseInstance);
        this.mPrimitives.add(vertexCount);
        this.mPrimitives.add(baseVertex);
    }

    public final void drawIndexedInstanced(int indexCount, int baseIndex, int instanceCount, int baseInstance, int baseVertex) {
        this.mPrimitives.add(4);
        this.mPrimitives.add(indexCount);
        this.mPrimitives.add(baseIndex);
        this.mPrimitives.add(instanceCount);
        this.mPrimitives.add(baseInstance);
        this.mPrimitives.add(baseVertex);
    }

    public final void bindIndexBuffer(int indexType, BufferViewInfo bufferInfo) {
        this.mPrimitives.add(5);
        this.mPrimitives.add(indexType);
        this.mPrimitives.add((int)bufferInfo.mOffset);
        this.mPointers.add((Object)bufferInfo.mBuffer);
    }

    public final void bindVertexBuffer(int binding, BufferViewInfo bufferInfo) {
        this.mPrimitives.add(6);
        this.mPrimitives.add(binding);
        this.mPrimitives.add((int)bufferInfo.mOffset);
        this.mPointers.add((Object)bufferInfo.mBuffer);
    }

    public final void setScissor(Rect2ic scissor, int surfaceHeight, int origin) {
        int y;
        int height = scissor.height();
        if (origin == 1) {
            y = surfaceHeight - scissor.bottom();
        } else {
            assert (origin == 0);
            y = scissor.y();
        }
        assert (y >= 0);
        this.mPrimitives.add(7);
        this.mPrimitives.add(scissor.x());
        this.mPrimitives.add(y);
        this.mPrimitives.add(scissor.width());
        this.mPrimitives.add(height);
    }

    public final void bindUniformBuffer(int binding, @RawPtr Buffer buffer, long offset, long size) {
        this.mPrimitives.add(8);
        this.mPrimitives.add(binding);
        this.mPrimitives.add((int)offset);
        this.mPrimitives.add((int)size);
        this.mPointers.add((Object)buffer);
    }

    public final void bindTextures(int[] textures) {
        int n2 = textures.length >> 1;
        assert (n2 > 0);
        this.mPrimitives.add(9);
        this.mPrimitives.add(n2);
        this.mPrimitives.addElements(this.mPrimitives.size(), textures);
    }

    public final void finish() {
    }

    public void debug(PrintWriter pw) {
        int[] p2 = this.mPrimitives.elements();
        int i = 0;
        Object[] oa = this.mPointers.elements();
        int oi = 0;
        int lim = this.mPrimitives.size();
        while (i < lim) {
            switch (p2[i++]) {
                case 0: {
                    int pipelineIndex = p2[i++];
                    pw.printf("[BindGraphicsPipeline pipelineIndex:%d]%n", pipelineIndex);
                    break;
                }
                case 1: {
                    int vertexCount = p2[i++];
                    int baseVertex = p2[i++];
                    pw.printf("[Draw vertexCount:%d baseVertex:%d]%n", vertexCount, baseVertex);
                    break;
                }
                case 2: {
                    int indexCount = p2[i++];
                    int baseIndex = p2[i++];
                    int baseVertex = p2[i++];
                    pw.printf("[DrawIndexed indexCount:%d baseIndex:%d baseVertex:%d]%n", indexCount, baseIndex, baseVertex);
                    break;
                }
                case 3: {
                    int instanceCount = p2[i++];
                    int baseInstance = p2[i++];
                    int vertexCount = p2[i++];
                    int baseVertex = p2[i++];
                    pw.printf("[DrawInstanced instanceCount:%d baseInstance:%d vertexCount:%d baseVertex:%d]%n", instanceCount, baseInstance, vertexCount, baseVertex);
                    break;
                }
                case 4: {
                    int indexCount = p2[i++];
                    int baseIndex = p2[i++];
                    int instanceCount = p2[i++];
                    int baseInstance = p2[i++];
                    int baseVertex = p2[i++];
                    pw.printf("[DrawIndexedInstanced indexCount:%d baseIndex:%d instanceCount:%d baseInstance:%d baseVertex:%d]%n", indexCount, baseIndex, instanceCount, baseInstance, baseVertex);
                    break;
                }
                case 5: {
                    int indexType = p2[i++];
                    long offset = p2[i++];
                    pw.printf("[BindIndexBuffer indexType:%d buffer:%s offset:%d]%n", indexType, oa[oi++], offset);
                    break;
                }
                case 6: {
                    int binding = p2[i++];
                    long offset = p2[i++];
                    pw.printf("[BindVertexBuffer binding:%d buffer:%s offset:%d]%n", binding, oa[oi++], offset);
                }
            }
        }
    }
}

