/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

public class DrawOrder {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 65535;
    public static final int CLEAR_DEPTH = 0;
    public static final int NO_INTERSECTION = 0;
    public static final int PAINTERS_ORDER_SHIFT = 32;
    public static final int STENCIL_INDEX_SHIFT = 16;
    public static final int DEPTH_SHIFT = 0;
    public static final int BIT_MASK = 65535;

    public static long makeFromDepth(int depth) {
        return (long)depth << 0;
    }

    public static long makeFromDepthAndPaintersOrder(int depth, int paintersOrder) {
        return (long)paintersOrder << 32 | (long)depth << 0;
    }

    public static int getPaintersOrder(long packedDrawOrder) {
        return (int)(packedDrawOrder >>> 32) & 0xFFFF;
    }

    public static int getStencilIndex(long packedDrawOrder) {
        return (int)(packedDrawOrder >>> 16) & 0xFFFF;
    }

    public static int getDepth(long packedDrawOrder) {
        return (int)(packedDrawOrder >>> 0) & 0xFFFF;
    }

    public static float getDepthAsFloat(long packedDrawOrder) {
        return (float)DrawOrder.getDepth(packedDrawOrder) / 65535.0f;
    }

    public static long updateWithPaintersOrder(long packedDrawOrder, int prevPaintersOrder) {
        int nextOrder = prevPaintersOrder + 1;
        int order = Math.max(nextOrder, DrawOrder.getPaintersOrder(packedDrawOrder));
        return packedDrawOrder & 0xFFFFFFFFL | (long)order << 32;
    }

    public static long updateWithStencilIndex(long packedDrawOrder, int disjointSet) {
        assert (DrawOrder.getStencilIndex(packedDrawOrder) == 0);
        return packedDrawOrder | (long)disjointSet << 16;
    }
}

