/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.Blender;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.Image;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SamplingOptions;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.effects.BlendModeColorFilter;
import yslelf.cloudpick.render.core.effects.ColorFilter;
import yslelf.cloudpick.render.core.effects.ComposeColorFilter;
import yslelf.cloudpick.render.core.shaders.AngularGradient;
import yslelf.cloudpick.render.core.shaders.BlendShader;
import yslelf.cloudpick.render.core.shaders.Color4fShader;
import yslelf.cloudpick.render.core.shaders.ColorShader;
import yslelf.cloudpick.render.core.shaders.EmptyShader;
import yslelf.cloudpick.render.core.shaders.Gradient1DShader;
import yslelf.cloudpick.render.core.shaders.GradientShader;
import yslelf.cloudpick.render.core.shaders.ImageShader;
import yslelf.cloudpick.render.core.shaders.LocalMatrixShader;
import yslelf.cloudpick.render.core.shaders.Shader;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.KeyBuilder;
import yslelf.cloudpick.render.engine.SamplerDesc;
import yslelf.cloudpick.render.granite.GraniteImage;
import yslelf.cloudpick.render.granite.KeyContext;
import yslelf.cloudpick.render.granite.PaintParams;
import yslelf.cloudpick.render.granite.TextureDataGatherer;
import yslelf.cloudpick.render.granite.UniformDataGatherer;

public class FragmentHelpers {
    public static final ColorSpace.Rgb.TransferParameters LINEAR_TRANSFER_PARAMETERS = new ColorSpace.Rgb.TransferParameters(1.0, 0.0, 0.0, 0.0, 1.0);
    public static final int kCubicClampUnpremul = 0;
    public static final int kCubicClampPremul = 1;

    private static void append_transfer_function_uniform(ColorSpace.Rgb.TransferParameters tf, UniformDataGatherer uniformDataGatherer) {
        uniformDataGatherer.write4f((float)tf.g, (float)tf.a, (float)tf.b, (float)tf.c);
        uniformDataGatherer.write4f((float)tf.d, (float)tf.e, (float)tf.f, 0.0f);
    }

    public static void appendColorSpaceUniforms(@Nullable ColorSpace srcCS, int srcAT, @Nullable ColorSpace dstCS, int dstAT, UniformDataGatherer uniformDataGatherer) {
        if (dstAT == 1) {
            dstAT = srcAT;
        }
        if (srcCS == null) {
            srcCS = ColorSpace.get(ColorSpace.Named.SRGB);
        }
        if (dstCS == null) {
            dstCS = srcCS;
        }
        boolean srcXYZ = srcCS.getModel() == ColorSpace.Model.XYZ;
        boolean dstXYZ = dstCS.getModel() == ColorSpace.Model.XYZ;
        ColorSpace.Rgb srcRGB = srcCS.getModel() == ColorSpace.Model.RGB ? (ColorSpace.Rgb)srcCS : null;
        ColorSpace.Rgb dstRGB = dstCS.getModel() == ColorSpace.Model.RGB ? (ColorSpace.Rgb)dstCS : null;
        boolean csXform = (srcXYZ || srcRGB != null && srcRGB.getTransferParameters() != null) && (dstXYZ || dstRGB != null && dstRGB.getTransferParameters() != null) && !srcCS.equals(dstCS);
        int flags = 0;
        if (csXform || srcAT != dstAT) {
            if (srcAT == 2) {
                flags |= 1;
            }
            if (srcAT != 1 && dstAT == 2) {
                flags |= 0x10;
            }
        }
        if (csXform) {
            flags |= 4;
            if (srcRGB != null && !LINEAR_TRANSFER_PARAMETERS.equals(srcRGB.getTransferParameters())) {
                flags |= 2;
            }
            if (dstRGB != null && !LINEAR_TRANSFER_PARAMETERS.equals(dstRGB.getTransferParameters())) {
                flags |= 8;
            }
            float[] transform = ColorSpace.Connector.Rgb.computeTransform(srcXYZ, srcRGB, dstXYZ, dstRGB);
            uniformDataGatherer.write1i(flags);
            FragmentHelpers.append_transfer_function_uniform(srcRGB == null ? LINEAR_TRANSFER_PARAMETERS : srcRGB.getTransferParameters(), uniformDataGatherer);
            uniformDataGatherer.writeMatrix3f(0, transform);
            FragmentHelpers.append_transfer_function_uniform(dstRGB == null ? LINEAR_TRANSFER_PARAMETERS : dstRGB.getTransferParameters(), uniformDataGatherer);
        } else {
            uniformDataGatherer.write1i(flags);
            FragmentHelpers.append_transfer_function_uniform(LINEAR_TRANSFER_PARAMETERS, uniformDataGatherer);
            uniformDataGatherer.writeMatrix3f(Matrix.identity());
            FragmentHelpers.append_transfer_function_uniform(LINEAR_TRANSFER_PARAMETERS, uniformDataGatherer);
        }
    }

    public static void appendSolidColorShaderBlock(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, float r, float g, float b, float a) {
        uniformDataGatherer.write4f(r, g, b, a);
        keyBuilder.addInt(2);
    }

    public static void appendRGBOpaquePaintColorBlock(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer) {
        uniformDataGatherer.writePaintColor(keyContext.r(), keyContext.g(), keyContext.b(), keyContext.a());
        keyBuilder.addInt(3);
    }

    public static void appendAlphaOnlyPaintColorBlock(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer) {
        uniformDataGatherer.writePaintColor(keyContext.r(), keyContext.g(), keyContext.b(), keyContext.a());
        keyBuilder.addInt(4);
    }

    public static void appendDitherShaderBlock(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, float range) {
        uniformDataGatherer.write1f(range);
        keyBuilder.addInt(20);
    }

    public static void appendLocalMatrixShaderBlock(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, Matrixc localMatrix) {
        Matrix inverse = new Matrix();
        localMatrix.invert(inverse);
        uniformDataGatherer.writeMatrix3f(inverse);
        keyBuilder.addInt(16);
    }

    public static void appendImageShaderBlock(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, Rect2fc subset, int tileModeX, int tileModeY, SamplingOptions sampling, int imageWidth, int imageHeight, int srcAT, @SharedPtr ImageViewProxy view) {
        boolean useHwTiling = !sampling.mUseCubic && subset.contains(0.0f, 0.0f, imageWidth, imageHeight) && (keyContext.getCaps().clampToBorderSupport() || tileModeX != 3 && tileModeY != 3);
        int filterMode = 0;
        if (useHwTiling || !sampling.mUseCubic) {
            uniformDataGatherer.write2f(1.0f / (float)imageWidth, 1.0f / (float)imageHeight);
        }
        if (useHwTiling) {
            keyBuilder.addInt(19);
        } else {
            assert (sampling.mMipmapMode == 0 || !keyContext.getCaps().clampToBorderSupport());
            uniformDataGatherer.write4f(subset.left(), subset.top(), subset.right(), subset.bottom());
            if (sampling.mUseCubic) {
                assert (sampling.mMinFilter == 0 && sampling.mMagFilter == 0);
                uniformDataGatherer.writeMatrix4f(0, ImageShader.makeCubicMatrix(sampling.mCubicB, sampling.mCubicC));
                uniformDataGatherer.write1i(srcAT == 2 ? 1 : 0);
                keyBuilder.addInt(18);
            } else {
                filterMode = sampling.mMinFilter | sampling.mMagFilter;
                uniformDataGatherer.write1i(filterMode);
                keyBuilder.addInt(17);
            }
            uniformDataGatherer.write1i(tileModeX);
            uniformDataGatherer.write1i(tileModeY);
        }
        SamplerDesc samplerDesc = useHwTiling ? SamplerDesc.make(sampling.mMagFilter, sampling.mMinFilter, sampling.mMipmapMode, tileModeX, tileModeY, 2) : SamplerDesc.make(filterMode);
        textureDataGatherer.add(view, samplerDesc);
    }

    private static void append_gradient_head(GradientData gradientData, UniformDataGatherer uniformDataGatherer) {
        if (gradientData.mNumStops <= 8) {
            if (gradientData.mNumStops <= 4) {
                uniformDataGatherer.write4fv(0, 4, gradientData.mColors);
                uniformDataGatherer.write4fv(0, 1, gradientData.mOffsets);
            } else {
                assert (gradientData.mNumStops <= 8);
                uniformDataGatherer.write4fv(0, 8, gradientData.mColors);
                uniformDataGatherer.write4fv(0, 2, gradientData.mOffsets);
            }
        }
    }

    private static void append_gradient_tail(GradientData gradientData, UniformDataGatherer uniformDataGatherer) {
        if (gradientData.mNumStops > 8) {
            uniformDataGatherer.write1i(gradientData.mNumStops);
        }
        uniformDataGatherer.write1i(gradientData.mTileMode);
        uniformDataGatherer.write1i(GradientShader.Interpolation.getColorSpace(gradientData.mInterpolation));
        uniformDataGatherer.write1i(GradientShader.Interpolation.isInPremul(gradientData.mInterpolation) ? 1 : 0);
    }

    public static void appendGradientShaderBlock(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, GradientData gradData) {
        int stageID = 0;
        switch (gradData.mSrcShader.asGradient()) {
            case 1: {
                stageID = gradData.mNumStops <= 4 ? 5 : (gradData.mNumStops <= 8 ? 6 : 0);
                FragmentHelpers.append_gradient_head(gradData, uniformDataGatherer);
                FragmentHelpers.append_gradient_tail(gradData, uniformDataGatherer);
                break;
            }
            case 2: {
                stageID = gradData.mNumStops <= 4 ? 7 : (gradData.mNumStops <= 8 ? 8 : 0);
                FragmentHelpers.append_gradient_head(gradData, uniformDataGatherer);
                FragmentHelpers.append_gradient_tail(gradData, uniformDataGatherer);
                break;
            }
            case 3: {
                stageID = gradData.mNumStops <= 4 ? 9 : (gradData.mNumStops <= 8 ? 10 : 0);
                FragmentHelpers.append_gradient_head(gradData, uniformDataGatherer);
                uniformDataGatherer.write1f(gradData.mBias);
                uniformDataGatherer.write1f(gradData.mScale);
                FragmentHelpers.append_gradient_tail(gradData, uniformDataGatherer);
            }
        }
        keyBuilder.addInt(stageID);
    }

    private static void append_gradient_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, Gradient1DShader shader, float bias, float scale) {
        Gradient1DShader.ColorTransformer colorTransformer = new Gradient1DShader.ColorTransformer(shader, keyContext.targetInfo().colorSpace());
        GradientData data = new GradientData(shader, bias, scale, shader.getTileMode(), colorTransformer.mColorCount, colorTransformer.mColors, colorTransformer.mPositions, shader.getInterpolation());
        boolean inputPremul = GradientShader.Interpolation.isInPremul(shader.getInterpolation());
        switch (GradientShader.Interpolation.getColorSpace(shader.getInterpolation())) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                inputPremul = false;
            }
        }
        ColorSpace dstColorSpace = keyContext.targetInfo().colorSpace();
        if (dstColorSpace == null) {
            dstColorSpace = ColorSpace.get(ColorSpace.Named.SRGB);
        }
        int intermediateAlphaType = inputPremul ? 2 : 3;
        int dstAlphaType = 2;
        keyBuilder.addInt(26);
        FragmentHelpers.appendGradientShaderBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, data);
        FragmentHelpers.appendColorSpaceUniforms(colorTransformer.mIntermediateColorSpace, intermediateAlphaType, dstColorSpace, dstAlphaType, uniformDataGatherer);
        keyBuilder.addInt(21);
    }

    public static void appendBlendMode(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, BlendMode bm) {
        boolean coeffs = false;
        switch (bm) {
            case CLEAR: {
                uniformDataGatherer.write4f(0.0f, 0.0f, 0.0f, 0.0f);
                coeffs = true;
                break;
            }
            case SRC: {
                uniformDataGatherer.write4f(1.0f, 0.0f, 0.0f, 0.0f);
                coeffs = true;
                break;
            }
            case DST: {
                uniformDataGatherer.write4f(0.0f, 1.0f, 0.0f, 0.0f);
                coeffs = true;
                break;
            }
            case SRC_OVER: {
                uniformDataGatherer.write4f(1.0f, 1.0f, 0.0f, -1.0f);
                coeffs = true;
                break;
            }
            case DST_OVER: {
                uniformDataGatherer.write4f(1.0f, 1.0f, -1.0f, 0.0f);
                coeffs = true;
                break;
            }
            case SRC_IN: {
                uniformDataGatherer.write4f(0.0f, 0.0f, 1.0f, 0.0f);
                coeffs = true;
                break;
            }
            case DST_IN: {
                uniformDataGatherer.write4f(0.0f, 0.0f, 0.0f, 1.0f);
                coeffs = true;
                break;
            }
            case SRC_OUT: {
                uniformDataGatherer.write4f(1.0f, 0.0f, -1.0f, 0.0f);
                coeffs = true;
                break;
            }
            case DST_OUT: {
                uniformDataGatherer.write4f(0.0f, 1.0f, 0.0f, -1.0f);
                coeffs = true;
                break;
            }
            case SRC_ATOP: {
                uniformDataGatherer.write4f(0.0f, 1.0f, 1.0f, -1.0f);
                coeffs = true;
                break;
            }
            case DST_ATOP: {
                uniformDataGatherer.write4f(1.0f, 0.0f, -1.0f, 1.0f);
                coeffs = true;
                break;
            }
            case XOR: {
                uniformDataGatherer.write4f(1.0f, 1.0f, -1.0f, -1.0f);
                coeffs = true;
            }
        }
        if (coeffs) {
            keyBuilder.addInt(24);
        } else {
            FragmentHelpers.appendFixedBlendMode(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, bm);
        }
    }

    public static void appendFixedBlendMode(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, BlendMode bm) {
        keyBuilder.addInt(27 + bm.ordinal());
    }

    public static void appendPrimitiveColorBlock(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer) {
        FragmentHelpers.appendColorSpaceUniforms(ColorSpace.get(ColorSpace.Named.SRGB), 2, keyContext.targetInfo().colorSpace(), 2, uniformDataGatherer);
        keyBuilder.addInt(25);
    }

    public static void appendToKey(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr Shader shader) {
        if (shader == null) {
            return;
        }
        if (shader instanceof LocalMatrixShader) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (LocalMatrixShader)shader);
        } else if (shader instanceof ImageShader) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (ImageShader)shader);
        } else if (shader instanceof ColorShader) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (ColorShader)shader);
        } else if (shader instanceof Color4fShader) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (Color4fShader)shader);
        } else if (shader instanceof Gradient1DShader) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (Gradient1DShader)shader);
        } else if (shader instanceof BlendShader) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (BlendShader)shader);
        } else if (shader instanceof EmptyShader) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (EmptyShader)shader);
        }
    }

    public static void appendToKey(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr ColorFilter colorFilter) {
        if (colorFilter == null) {
            return;
        }
        if (colorFilter instanceof BlendModeColorFilter) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (BlendModeColorFilter)colorFilter);
        } else if (colorFilter instanceof ComposeColorFilter) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (ComposeColorFilter)colorFilter);
        }
    }

    public static void appendToKey(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr Blender blender) {
        if (blender == null) {
            return;
        }
        if (blender instanceof BlendMode) {
            FragmentHelpers.append_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, (BlendMode)blender);
        }
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr ColorShader shader) {
        int color = shader.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        FragmentHelpers.appendSolidColorShaderBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, r * a, g * a, b * a, a);
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr Color4fShader shader) {
        float[] color = new float[]{shader.r(), shader.g(), shader.b(), shader.a()};
        ColorSpace srcCS = shader.getColorSpace();
        ColorSpace dstCS = keyContext.targetInfo().colorSpace();
        if (srcCS != null && !srcCS.isSrgb() || dstCS != null && !dstCS.isSrgb()) {
            if (srcCS == null) {
                srcCS = ColorSpace.get(ColorSpace.Named.SRGB);
            }
            if (dstCS == null) {
                dstCS = ColorSpace.get(ColorSpace.Named.SRGB);
            }
            ColorSpace.connect(srcCS, dstCS).transform(color);
        }
        int i = 0;
        while (i < 3) {
            int n2 = i++;
            color[n2] = color[n2] * color[3];
        }
        FragmentHelpers.appendSolidColorShaderBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, color[0], color[1], color[2], color[3]);
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr ImageShader shader) {
        Image image = shader.getImage();
        if (!(image instanceof GraniteImage)) {
            keyBuilder.addInt(0);
            return;
        }
        GraniteImage imageToDraw = (GraniteImage)image;
        @SharedPtr ImageViewProxy view = RefCnt.create(imageToDraw.getImageViewProxy());
        if (view == null) {
            keyBuilder.addInt(0);
            return;
        }
        int srcAlphaType = imageToDraw.getAlphaType();
        int dstAlphaType = 2;
        if (imageToDraw.isAlphaOnly()) {
            keyBuilder.addInt(22);
            FragmentHelpers.appendImageShaderBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, shader.getSubset(), shader.getTileModeX(), shader.getTileModeY(), shader.getSampling(), view.getWidth(), view.getHeight(), srcAlphaType, view);
            FragmentHelpers.appendRGBOpaquePaintColorBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
            FragmentHelpers.appendFixedBlendMode(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, BlendMode.DST_IN);
        } else {
            keyBuilder.addInt(26);
            FragmentHelpers.appendImageShaderBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, shader.getSubset(), shader.getTileModeX(), shader.getTileModeY(), shader.getSampling(), view.getWidth(), view.getHeight(), srcAlphaType, view);
            FragmentHelpers.appendColorSpaceUniforms(imageToDraw.getColorSpace(), srcAlphaType, keyContext.targetInfo().colorSpace(), 2, uniformDataGatherer);
            keyBuilder.addInt(21);
        }
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr LocalMatrixShader shader) {
        Shader baseShader = shader.getBase();
        Matrix matrix = new Matrix();
        if (baseShader instanceof ImageShader) {
            GraniteImage textureImage;
            ImageViewProxy view;
            ImageShader imageShader = (ImageShader)baseShader;
            Image image = imageShader.getImage();
            if (image instanceof GraniteImage && (view = (textureImage = (GraniteImage)image).getImageViewProxy()).getOrigin() == 1) {
                matrix.setScaleTranslate(1.0f, -1.0f, 0.0f, view.getHeight());
            }
        } else if (baseShader instanceof Gradient1DShader) {
            Gradient1DShader gradShader = (Gradient1DShader)baseShader;
            Matrixc gradMatrix = gradShader.getGradientMatrix();
            boolean res = gradMatrix.invert(matrix);
            assert (res);
        }
        matrix.postConcat(shader.getLocalMatrix());
        FragmentHelpers.appendLocalMatrixShaderBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, matrix);
        FragmentHelpers.appendToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, baseShader);
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr Gradient1DShader shader) {
        switch (shader.asGradient()) {
            case 1: 
            case 2: {
                FragmentHelpers.append_gradient_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, shader, 0.0f, 0.0f);
                break;
            }
            case 3: {
                AngularGradient angularGrad = (AngularGradient)shader;
                FragmentHelpers.append_gradient_to_key(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, shader, angularGrad.getTBias(), angularGrad.getTScale());
            }
        }
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr BlendShader shader) {
        keyBuilder.addInt(22);
        FragmentHelpers.appendToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, shader.getSrc());
        FragmentHelpers.appendToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, shader.getDst());
        FragmentHelpers.appendBlendMode(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, shader.getMode());
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr EmptyShader shader) {
        keyBuilder.addInt(1);
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr BlendModeColorFilter colorFilter) {
        float[] blendColor = (float[])colorFilter.getColor().clone();
        PaintParams.prepareColorForDst(blendColor, keyContext.targetInfo(), false);
        int i = 0;
        while (i < 3) {
            int n2 = i++;
            blendColor[n2] = blendColor[n2] * blendColor[3];
        }
        keyBuilder.addInt(22);
        FragmentHelpers.appendSolidColorShaderBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, blendColor[0], blendColor[1], blendColor[2], blendColor[3]);
        keyBuilder.addInt(1);
        FragmentHelpers.appendBlendMode(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, colorFilter.getMode());
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr ComposeColorFilter colorFilter) {
        keyBuilder.addInt(26);
        FragmentHelpers.appendToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, colorFilter.getBefore());
        FragmentHelpers.appendToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, colorFilter.getAfter());
    }

    private static void append_to_key(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, @RawPtr BlendMode blender) {
        FragmentHelpers.appendBlendMode(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, blender);
    }

    public static class GradientData {
        static final int kNumInternalStorageStops = 8;
        float mBias;
        float mScale;
        int mTileMode;
        int mNumStops;
        float[] mColors = new float[32];
        float[] mOffsets = new float[8];
        Gradient1DShader mSrcShader;
        int mInterpolation;

        GradientData(Gradient1DShader shader, float bias, float scale, int tileMode, int numStops, float[] colors, float[] offsets, int interpolation) {
            this.mSrcShader = shader;
            this.mBias = bias;
            this.mScale = scale;
            this.mTileMode = tileMode;
            this.mNumStops = numStops;
            this.mInterpolation = interpolation;
            if (this.mNumStops <= 8) {
                System.arraycopy(colors, 0, this.mColors, 0, this.mNumStops * 4);
                if (offsets != null) {
                    System.arraycopy(offsets, 0, this.mOffsets, 0, this.mNumStops);
                } else {
                    for (int i = 0; i < this.mNumStops; ++i) {
                        this.mOffsets[i] = (float)i / (float)(this.mNumStops - 1);
                    }
                }
                int last = this.mNumStops - 1;
                for (int i = this.mNumStops; i < 8; ++i) {
                    System.arraycopy(this.mColors, last * 4, this.mColors, i * 4, 4);
                    this.mOffsets[i] = this.mOffsets[last];
                }
            }
        }
    }
}

