/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import yslelf.cloudpick.render.granite.FragmentStage;

public class FragmentNode {
    public static final FragmentNode[] NO_CHILDREN = new FragmentNode[0];
    private final FragmentStage mStage;
    private final FragmentNode[] mChildren;
    private final int mCodeID;
    private final int mStageIndex;
    private final int mRequirementFlags;

    public FragmentNode(FragmentStage stage, FragmentNode[] children, int codeID, int stageIndex) {
        assert (stage.mNumChildren == children.length);
        this.mStage = stage;
        this.mChildren = children;
        this.mCodeID = codeID;
        this.mStageIndex = stageIndex;
        boolean isCompose = codeID == 26 || codeID == 22;
        int requirementFlags = stage.mRequirementFlags;
        for (FragmentNode child : children) {
            int mask = 0;
            if (codeID >= FragmentStage.kBuiltinStageIDCount || isCompose && child == children[children.length - 1]) {
                mask = 7;
            }
            requirementFlags |= child.mRequirementFlags & ~mask;
        }
        this.mRequirementFlags = requirementFlags;
    }

    public FragmentStage stage() {
        return this.mStage;
    }

    public int codeID() {
        return this.mCodeID;
    }

    public int stageIndex() {
        return this.mStageIndex;
    }

    public int numChildren() {
        return this.mStage.mNumChildren;
    }

    public FragmentNode childAt(int index) {
        return this.mChildren[index];
    }

    public FragmentNode[] children() {
        return this.mChildren;
    }

    public int requirementFlags() {
        return this.mRequirementFlags;
    }
}

