/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import javax.annotation.Nonnull;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.Glyph;
import yslelf.cloudpick.render.core.PixelUtils;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.engine.Engine;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.granite.BakedGlyph;
import yslelf.cloudpick.render.granite.DrawAtlas;
import yslelf.cloudpick.render.granite.SurfaceDrawContext;

public class GlyphAtlasManager
extends DrawAtlas.AtlasGenerationCounter
implements AutoCloseable {
    private static final int MAX_ATLAS_SIZE = 4096;
    private static final int SMALL_PLOT_SIZE = 256;
    private static final int LARGE_PLOT_SIZE = 512;
    private final RecordingContext mRC;
    private final DrawAtlas[] mAtlases = new DrawAtlas[3];
    private final int mMaxTextureSize;

    public GlyphAtlasManager(RecordingContext rc) {
        this.mRC = rc;
        this.mMaxTextureSize = Math.min(rc.getCaps().maxTextureSize(), 4096);
    }

    @Override
    public void close() {
        for (int i = 0; i < this.mAtlases.length; ++i) {
            if (this.mAtlases[i] != null) {
                this.mAtlases[i].close();
            }
            this.mAtlases[i] = null;
        }
    }

    public boolean initAtlas(int maskFormat) {
        if (this.mAtlases[maskFormat] == null) {
            int ct = Engine.maskFormatToColorType(maskFormat);
            int atlasSize = maskFormat == 0 ? this.mMaxTextureSize : Math.min(2048, this.mMaxTextureSize);
            int plotSize = atlasSize == 4096 ? 512 : 256;
            this.mAtlases[maskFormat] = DrawAtlas.make(ct, atlasSize, atlasSize, plotSize, plotSize, this, false, false, null, "GlyphAtlas");
            return this.mAtlases[maskFormat] != null;
        }
        return true;
    }

    @RawPtr
    public ImageViewProxy getCurrentTexture(int maskFormat) {
        return this.getAtlas(maskFormat).getTexture(0);
    }

    public boolean hasGlyph(int maskFormat, @Nonnull BakedGlyph glyph) {
        return this.getAtlas(maskFormat).contains(glyph);
    }

    private static void get_packed_glyph_image(Glyph src, int maskFormat, long dst, int dstRB) {
        int width = src.getWidth();
        int height = src.getHeight();
        Object srcBase = src.getImageBase();
        long srcAddr = src.getImageAddress();
        int srcRB = src.getRowBytes();
        if (src.getMaskFormat() != 0) {
            assert (srcRB == Engine.maskFormatBytesPerPixel(maskFormat) * width);
            PixelUtils.copyImage(srcBase, srcAddr, srcRB, null, dst, dstRB, srcRB, height);
        } else {
            PixelUtils.unpackBWToA8(srcBase, srcAddr, srcRB, null, dst, dstRB, width, height);
        }
    }

    public int addGlyphToAtlas(@Nonnull Glyph glyph, @Nonnull BakedGlyph bakedGlyph) {
        if (glyph.getImageBase() == null) {
            return 1;
        }
        int maskFormat = BakedGlyph.chooseMaskFormat(glyph);
        int bytesPerPixel = Engine.maskFormatBytesPerPixel(maskFormat);
        int width = glyph.getWidth() + 2;
        int height = glyph.getHeight() + 2;
        long srcRB = (long)bytesPerPixel * (long)width;
        DrawAtlas atlas = this.getAtlas(maskFormat);
        int res = atlas.addRect(this.mRC, width, height, bakedGlyph);
        if (res == 0) {
            long dst = atlas.getDataAt(bakedGlyph);
            int dstRB = bytesPerPixel * atlas.getPlotWidth();
            for (int y = 0; y < height; ++y) {
                MemoryUtil.memSet((long)(dst + (long)y * (long)dstRB), (int)0, (long)srcRB);
            }
            GlyphAtlasManager.get_packed_glyph_image(glyph, maskFormat, dst += (long)((dstRB + bytesPerPixel) * 1), dstRB);
            bakedGlyph.insetRect(1);
        }
        return res;
    }

    public void addGlyphAndSetLastUseToken(@Nonnull DrawAtlas.PlotBulkUseUpdater updater, @Nonnull BakedGlyph glyph, int maskFormat, long token) {
        if (updater.add(glyph)) {
            this.getAtlas(maskFormat).setLastUseToken(glyph, token);
        }
    }

    public long getAtlasGeneration(int maskFormat) {
        return this.getAtlas(maskFormat).getAtlasGeneration();
    }

    public void setLastUseTokenBulk(int maskFormat, DrawAtlas.PlotBulkUseUpdater updater, long token) {
        this.getAtlas(maskFormat).setLastUseTokenBulk(updater, token);
    }

    public boolean recordUploads(SurfaceDrawContext sdc) {
        for (DrawAtlas atlas : this.mAtlases) {
            if (atlas == null || atlas.recordUploads(this.mRC, sdc)) continue;
            return false;
        }
        return true;
    }

    public void evictAtlases() {
        for (DrawAtlas atlas : this.mAtlases) {
            if (atlas == null) continue;
            atlas.evictAllPlots();
        }
    }

    public void compact() {
        DrawAtlas.AtlasTokenTracker tokenTracker = this.mRC.getAtlasTokenTracker();
        for (DrawAtlas atlas : this.mAtlases) {
            if (atlas == null) continue;
            atlas.compact(tokenTracker.nextFlushToken());
        }
    }

    public void purge() {
        DrawAtlas.AtlasTokenTracker tokenTracker = this.mRC.getAtlasTokenTracker();
        for (DrawAtlas atlas : this.mAtlases) {
            if (atlas == null) continue;
            atlas.purge(tokenTracker.nextFlushToken());
        }
    }

    private DrawAtlas getAtlas(int maskFormat) {
        assert (maskFormat < 3);
        return this.mAtlases[maskFormat];
    }

    static {
        int plots = 8;
        assert (plots * plots <= 64);
    }
}

