/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.Blender;
import yslelf.cloudpick.render.core.Canvas;
import yslelf.cloudpick.render.core.Device;
import yslelf.cloudpick.render.core.GlyphRunList;
import yslelf.cloudpick.render.core.Image;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.RoundRect;
import yslelf.cloudpick.render.core.SamplingOptions;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.StrikeCache;
import yslelf.cloudpick.render.core.Vertices;
import yslelf.cloudpick.render.core.effects.ColorFilter;
import yslelf.cloudpick.render.core.shaders.ImageShader;
import yslelf.cloudpick.render.core.shaders.Shader;
import yslelf.cloudpick.render.engine.ISurface;
import yslelf.cloudpick.render.engine.ImageDesc;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.granite.ArcShape;
import yslelf.cloudpick.render.granite.BakedTextBlob;
import yslelf.cloudpick.render.granite.ClipStack;
import yslelf.cloudpick.render.granite.Draw;
import yslelf.cloudpick.render.granite.DrawOrder;
import yslelf.cloudpick.render.granite.DrawTask;
import yslelf.cloudpick.render.granite.GeometryRenderer;
import yslelf.cloudpick.render.granite.GraniteImage;
import yslelf.cloudpick.render.granite.PaintParams;
import yslelf.cloudpick.render.granite.SimpleShape;
import yslelf.cloudpick.render.granite.SubRunContainer;
import yslelf.cloudpick.render.granite.SubRunData;
import yslelf.cloudpick.render.granite.SurfaceDrawContext;
import yslelf.cloudpick.render.granite.TextBlobCache;
import yslelf.cloudpick.render.granite.geom.BoundsManager;
import yslelf.cloudpick.render.granite.geom.HybridBoundsManager;

public final class GraniteDevice
extends Device {
    private RecordingContext mRC;
    private SurfaceDrawContext mSDC;
    private final ClipStack mClipStack;
    private final ObjectArrayList<ClipStack.Element> mElementsForMask = new ObjectArrayList();
    private int mCurrentDepth = 0;
    private final BoundsManager mColorDepthBoundsManager;
    private final Paint mSubRunPaint = new Paint();
    private final TextBlobCache.FeatureKey mBlobKey = new TextBlobCache.FeatureKey();
    private final Rect2f mTmpClipBounds = new Rect2f();
    private final Rect2i mTmpClipBoundsI = new Rect2i();

    private GraniteDevice(RecordingContext rc, SurfaceDrawContext sdc) {
        super(sdc.getImageInfo());
        this.mRC = rc;
        this.mSDC = sdc;
        this.mClipStack = new ClipStack(this);
        this.mColorDepthBoundsManager = new HybridBoundsManager(this.getWidth(), this.getHeight(), 16, 64, 32);
    }

    @Nullable
    @SharedPtr
    public static GraniteDevice make(@RawPtr RecordingContext rc, @Nonnull ImageInfo deviceInfo, int surfaceFlags, int origin, byte initialLoadOp, String label, boolean trackDevice) {
        ImageDesc desc;
        if (rc == null) {
            return null;
        }
        if ((surfaceFlags & 4) != 0 && (surfaceFlags & 2) != 0) {
            return null;
        }
        int backingWidth = deviceInfo.width();
        int backingHeight = deviceInfo.height();
        if ((surfaceFlags & 2) != 0) {
            backingWidth = ISurface.getApproxSize(backingWidth);
            backingHeight = ISurface.getApproxSize(backingHeight);
        }
        if ((desc = rc.getCaps().getDefaultColorImageDesc(1, deviceInfo.colorType(), backingWidth, backingHeight, 1, surfaceFlags | 8 | 0x20)) == null) {
            return null;
        }
        short readSwizzle = rc.getCaps().getReadSwizzle(desc, deviceInfo.colorType());
        @SharedPtr ImageViewProxy targetView = ImageViewProxy.make(rc, desc, origin, readSwizzle, (surfaceFlags & 1) != 0, label);
        if (targetView == null) {
            return null;
        }
        return GraniteDevice.make(rc, targetView, deviceInfo, initialLoadOp, trackDevice);
    }

    @Nullable
    @SharedPtr
    public static GraniteDevice make(@RawPtr RecordingContext rc, @SharedPtr ImageViewProxy targetView, ImageInfo deviceInfo, byte initialLoadOp, boolean trackDevice) {
        if (rc == null) {
            return null;
        }
        SurfaceDrawContext sdc = SurfaceDrawContext.make(rc, targetView, deviceInfo);
        if (sdc == null) {
            return null;
        }
        if (initialLoadOp == 1) {
            sdc.clear(null);
        } else if (initialLoadOp == 2) {
            sdc.discard();
        }
        @SharedPtr GraniteDevice device = new GraniteDevice(rc, sdc);
        if (trackDevice) {
            rc.trackDevice(RefCnt.create(device));
        }
        return device;
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.mSDC.close();
        this.mSDC = null;
        assert (this.mRC == null);
    }

    public void setImmutable() {
        if (this.mRC != null) {
            this.flushPendingWork();
            this.mRC.untrackDevice(this);
            this.discardRC();
        }
    }

    public void discardRC() {
        this.mRC = null;
    }

    @Override
    @Nonnull
    public RecordingContext getRecordingContext() {
        assert (this.mRC != null);
        return this.mRC;
    }

    @RawPtr
    public ImageViewProxy getReadView() {
        return this.mSDC.getReadView();
    }

    @Nullable
    @SharedPtr
    public GraniteImage makeImageCopy(@Nonnull Rect2ic subset, boolean budgeted, boolean mipmapped, boolean approxFit) {
        assert (this.mRC.isOwnerThread());
        this.flushPendingWork();
        ImageInfo srcInfo = this.getImageInfo();
        ImageViewProxy srcView = this.mSDC.getReadView();
        Object label = srcView.getLabel();
        label = label == null || ((String)label).isEmpty() ? "CopyDeviceTexture" : (String)label + "_DeviceCopy";
        return GraniteImage.copy(this.mRC, srcView, srcInfo, subset, budgeted, mipmapped, approxFit, (String)label);
    }

    @Override
    public void pushClipStack() {
        this.mClipStack.save();
    }

    @Override
    public void popClipStack() {
        this.mClipStack.restore();
    }

    public ClipStack getClipStack() {
        return this.mClipStack;
    }

    @Override
    public void clipRect(Rect2fc rect, int clipOp, boolean doAA) {
        this.mClipStack.clipRect(this.getLocalToDevice33(), rect, clipOp);
    }

    @Override
    public boolean isClipAA() {
        return false;
    }

    @Override
    public boolean isClipEmpty() {
        return this.mClipStack.currentClipState() == 0;
    }

    @Override
    public boolean isClipRect() {
        int state = this.mClipStack.currentClipState();
        return state == 2 || state == 1;
    }

    @Override
    public boolean isClipWideOpen() {
        return this.mClipStack.currentClipState() == 1;
    }

    @Override
    public void getClipBounds(@Nonnull Rect2i bounds) {
        this.mClipStack.getConservativeBounds(this.mTmpClipBounds);
        this.mTmpClipBounds.roundOut(bounds);
    }

    @Override
    protected Rect2ic getClipBounds() {
        this.mClipStack.getConservativeBounds(this.mTmpClipBounds);
        this.mTmpClipBounds.roundOut(this.mTmpClipBoundsI);
        return this.mTmpClipBoundsI;
    }

    @Override
    public void drawPaint(Paint paint) {
        float[] color = new float[4];
        if (PaintParams.getSolidColor(paint, this.getImageInfo(), color)) {
            this.mSDC.clear(color);
        }
    }

    @Override
    public void drawPoints(int mode, float[] pts, int offset, int count, Paint paint) {
        int oldStyle = paint.getStyle();
        paint.setStyle(0);
        int cap = paint.getStrokeCap();
        if (mode == 0) {
            float radius = paint.getStrokeWidth() * 0.5f;
            if (cap == 1) {
                int e = offset + count * 2;
                for (int i = offset; i < e; i += 2) {
                    this.drawCircle(pts[i], pts[i + 1], radius, paint);
                }
            } else {
                Rect2f rect = new Rect2f(-radius, -radius, radius, radius);
                int e = offset + count * 2;
                for (int i = offset; i < e; i += 2) {
                    rect.offsetTo(pts[i], pts[i + 1]);
                    this.drawRect(rect, paint);
                }
            }
        } else {
            float width = paint.getStrokeWidth();
            int inc = mode == 1 ? 4 : 2;
            int e = offset + (count - 1) * 2;
            for (int i = offset; i < e; i += inc) {
                this.drawLine(pts[i], pts[i + 1], pts[i + 2], pts[i + 3], cap, width, paint);
            }
        }
        paint.setStyle(oldStyle);
    }

    @Override
    public void drawLine(float x0, float y0, float x1, float y1, int cap, float width, Paint paint) {
        SimpleShape shape = new SimpleShape();
        shape.setLine(x0, y0, x1, y1, cap, width);
        this.drawGeometry(this.getLocalToDevice33(), shape, SimpleShape::getBounds, paint, this.mRC.getRendererProvider().getSimpleBox(paint.isAntiAlias()), null);
    }

    @Override
    public void drawRect(Rect2fc r, Paint paint) {
        this.drawGeometry(this.getLocalToDevice33(), new SimpleShape(r), SimpleShape::getBounds, paint, this.mRC.getRendererProvider().getSimpleBox(paint.isAntiAlias()), null);
    }

    @Override
    public void drawRoundRect(RoundRect rr, Paint paint) {
        this.drawGeometry(this.getLocalToDevice33(), new SimpleShape(rr), SimpleShape::getBounds, paint, this.mRC.getRendererProvider().getSimpleBox(paint.isAntiAlias()), null);
    }

    @Override
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        SimpleShape shape = new SimpleShape();
        shape.setEllipseXY(cx, cy, radius, radius);
        this.drawGeometry(this.getLocalToDevice33(), shape, SimpleShape::getBounds, paint, this.mRC.getRendererProvider().getSimpleBox(paint.isAntiAlias()), null);
    }

    @Override
    public void drawArc(float cx, float cy, float radius, float startAngle, float sweepAngle, int cap, float width, Paint paint) {
        ArcShape shape = new ArcShape(cx, cy, radius, startAngle, sweepAngle, width * 0.5f);
        shape.mType = switch (cap) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            default -> throw new AssertionError();
        };
        this.drawGeometry(this.getLocalToDevice33(), shape, ArcShape::getBounds, paint, this.mRC.getRendererProvider().getArc(shape.mType), null);
    }

    @Override
    public void drawPie(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        ArcShape shape = new ArcShape(cx, cy, radius, startAngle, sweepAngle, 0.0f);
        shape.mType = 3;
        this.drawGeometry(this.getLocalToDevice33(), shape, ArcShape::getBounds, paint, this.mRC.getRendererProvider().getArc(shape.mType), null);
    }

    @Override
    public void drawChord(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        ArcShape shape = new ArcShape(cx, cy, radius, startAngle, sweepAngle, 0.0f);
        shape.mType = 4;
        this.drawGeometry(this.getLocalToDevice33(), shape, ArcShape::getBounds, paint, this.mRC.getRendererProvider().getArc(shape.mType), null);
    }

    @Override
    public void drawImageRect(@RawPtr Image image, Rect2fc src, Rect2fc dst, SamplingOptions sampling, Paint paint, int constraint) {
        Paint modifiedPaint;
        Rect2f modifiedDst = ImageShader.preparePaintForDrawImageRect(image, sampling, src, dst, constraint == 1, modifiedPaint = new Paint(paint));
        if (!modifiedDst.isEmpty()) {
            this.drawRect(modifiedDst, modifiedPaint);
        }
        modifiedPaint.close();
    }

    @Override
    protected void onDrawGlyphRunList(Canvas canvas, GlyphRunList glyphRunList, Paint paint) {
        Matrix positionMatrix = new Matrix(this.getLocalToDevice33());
        positionMatrix.preTranslate(glyphRunList.mOriginX, glyphRunList.mOriginY);
        if (glyphRunList.mOriginalTextBlob != null) {
            TextBlobCache blobCache = this.mRC.getTextBlobCache();
            this.mBlobKey.update(glyphRunList, paint, positionMatrix);
            BakedTextBlob entry = blobCache.find(glyphRunList.mOriginalTextBlob, this.mBlobKey);
            if (entry == null) {
                entry = BakedTextBlob.make(glyphRunList, paint, positionMatrix, StrikeCache.getGlobalStrikeCache());
                entry = blobCache.insert(glyphRunList.mOriginalTextBlob, this.mBlobKey, entry);
            }
            entry.draw(canvas, glyphRunList.mOriginX, glyphRunList.mOriginY, paint, this);
        } else {
            SubRunContainer container = SubRunContainer.make(glyphRunList, positionMatrix, paint, StrikeCache.getGlobalStrikeCache());
            container.draw(canvas, glyphRunList.mOriginX, glyphRunList.mOriginY, paint, this);
        }
    }

    @Override
    public void drawVertices(Vertices vertices, @SharedPtr Blender blender, Paint paint) {
        this.drawGeometry(this.getLocalToDevice33(), vertices, Vertices::getBounds, paint, this.mRC.getRendererProvider().getVertices(vertices.getVertexMode(), vertices.hasColors(), vertices.hasTexCoords()), blender);
    }

    public void drawAtlasSubRun(SubRunContainer.AtlasSubRun subRun, float originX, float originY, Paint paint) {
        int glyphsPrepared;
        int maskFormat = subRun.getMaskFormat();
        if (!this.mRC.getAtlasProvider().getGlyphAtlasManager().initAtlas(maskFormat)) {
            return;
        }
        int subRunEnd = subRun.getGlyphCount();
        Paint subRunPaint = this.mSubRunPaint;
        boolean flushed = false;
        int subRunCursor = 0;
        while (subRunCursor < subRunEnd && (glyphsPrepared = subRun.prepareGlyphs(subRunCursor, subRunEnd, this.mRC)) >= 0) {
            if (glyphsPrepared > 0) {
                Matrix subRunToLocal = new Matrix();
                Matrix subRunToDevice = new Matrix();
                int filter = subRun.getMatrixAndFilter(this.getLocalToDevice33(), originX, originY, subRunToLocal, subRunToDevice);
                SubRunData subRunData = new SubRunData(subRun, subRunToLocal, filter, subRunCursor, glyphsPrepared);
                subRunPaint.set(paint);
                if (subRun.getMaskFormat() == 2) {
                    subRunPaint.setShader(null);
                }
                subRunPaint.setStyle(0);
                this.drawGeometry(subRunToDevice, subRunData, SubRunData::getBounds, paint, this.mRC.getRendererProvider().getRasterText(maskFormat), BlendMode.DST_IN);
            } else if (flushed) break;
            if ((subRunCursor += glyphsPrepared) >= subRunEnd) continue;
            this.mRC.flushTrackedDevices();
            flushed = true;
        }
        subRunPaint.reset();
    }

    private static boolean blender_depends_on_dst(Blender blender, boolean srcIsTransparent) {
        BlendMode bm;
        BlendMode blendMode = bm = blender != null ? blender.asBlendMode() : BlendMode.SRC_OVER;
        if (bm == null) {
            return true;
        }
        if (bm == BlendMode.SRC || bm == BlendMode.CLEAR) {
            return false;
        }
        if (bm == BlendMode.SRC_OVER) {
            return srcIsTransparent;
        }
        return true;
    }

    private static boolean paint_depends_on_dst(float a, Shader shader, ColorFilter colorFilter, Blender finalBlender, Blender primitiveBlender) {
        boolean srcIsTransparent;
        boolean bl = srcIsTransparent = a != 1.0f || shader != null && !shader.isOpaque() || colorFilter != null && !colorFilter.isAlphaUnchanged();
        if (primitiveBlender != null && GraniteDevice.blender_depends_on_dst(primitiveBlender, srcIsTransparent)) {
            return true;
        }
        return GraniteDevice.blender_depends_on_dst(finalBlender, srcIsTransparent);
    }

    private static boolean paint_depends_on_dst(PaintParams paintParams) {
        return GraniteDevice.paint_depends_on_dst(paintParams.a(), paintParams.getShader(), paintParams.getColorFilter(), paintParams.getFinalBlender(), paintParams.getPrimitiveBlender());
    }

    public <GEO> void drawGeometry(Matrixc localToDevice, GEO geometry, BiConsumer<GEO, Rect2f> boundsFn, Paint paint, GeometryRenderer renderer, @SharedPtr Blender primitiveBlender) {
        Draw draw = new Draw();
        draw.mTransform = localToDevice;
        draw.mGeometry = geometry;
        draw.mRenderer = renderer;
        if (paint.getStyle() == 0) {
            draw.mHalfWidth = -1.0f;
        } else {
            draw.mHalfWidth = paint.getStrokeWidth() * 0.5f;
            switch (paint.getStrokeJoin()) {
                case 1: {
                    draw.mJoinLimit = -1.0f;
                    break;
                }
                case 2: {
                    draw.mJoinLimit = 0.0f;
                    break;
                }
                case 0: {
                    draw.mJoinLimit = paint.getStrokeMiter();
                }
            }
            draw.mStrokeCap = (byte)paint.getStrokeCap();
            draw.mStrokeAlign = (byte)paint.getStrokeAlign();
        }
        boolean outsetBoundsForAA = renderer.outsetBoundsForAA();
        this.mElementsForMask.clear();
        boolean clippedOut = this.mClipStack.prepareForDraw(draw, geometry, boundsFn, outsetBoundsForAA, (List<ClipStack.Element>)this.mElementsForMask);
        if (clippedOut) {
            RefCnt.move(primitiveBlender);
            return;
        }
        if (!renderer.emitsPrimitiveColor()) {
            primitiveBlender = RefCnt.move(primitiveBlender);
        } else if (primitiveBlender == null) {
            primitiveBlender = BlendMode.SRC_OVER;
        }
        draw.mPaintParams = new PaintParams(paint, primitiveBlender);
        int numNewRenderSteps = renderer.numSteps();
        boolean needsFlush = this.needsFlushBeforeDraw(numNewRenderSteps);
        if (needsFlush) {
            this.flushPendingWork();
        }
        int drawDepth = this.mCurrentDepth + 1;
        int clipOrder = this.mClipStack.updateForDraw(draw, (List<ClipStack.Element>)this.mElementsForMask, this.mColorDepthBoundsManager, drawDepth);
        int paintOrder = clipOrder + 1;
        if (renderer.emitsCoverage() || GraniteDevice.paint_depends_on_dst(draw.mPaintParams)) {
            int prevDraw = this.mColorDepthBoundsManager.getMostRecentDraw(draw.mDrawBounds);
            paintOrder = Math.max(paintOrder, prevDraw + 1);
        }
        draw.mDrawOrder = DrawOrder.makeFromDepthAndPaintersOrder(drawDepth, paintOrder);
        this.mSDC.recordDraw(draw);
        this.mColorDepthBoundsManager.recordDraw(draw.mDrawBounds, paintOrder);
        this.mCurrentDepth = drawDepth;
    }

    public void drawClipShape(Draw draw, boolean inverseFill) {
    }

    private boolean needsFlushBeforeDraw(int numNewRenderSteps) {
        return 4096 - this.mSDC.numPendingSteps() < (numNewRenderSteps += this.mClipStack.maxDeferredClipDraws() * 4);
    }

    public void flushPendingWork() {
        assert (this.mRC.isOwnerThread());
        this.mRC.getAtlasProvider().recordUploads(this.mSDC);
        this.mClipStack.recordDeferredClipDraws();
        this.mSDC.flush(this.mRC);
        this.mColorDepthBoundsManager.clear();
        this.mCurrentDepth = 0;
        this.mRC.getAtlasProvider().compact();
        DrawTask drawTask = this.mSDC.snapDrawTask(this.mRC);
        if (drawTask != null) {
            this.mRC.addTask(drawTask);
        }
    }
}

