/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.Image;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.ISurface;
import yslelf.cloudpick.render.engine.ImageDesc;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.task.CopyImageTask;

public final class GraniteImage
extends Image {
    @RawPtr
    RecordingContext mContext;
    @SharedPtr
    ImageViewProxy mImageViewProxy;

    public GraniteImage(@Nonnull @RawPtr RecordingContext context, @Nonnull @SharedPtr ImageViewProxy view, int colorType, int alphaType, @Nullable ColorSpace colorSpace) {
        super(ImageInfo.make(view.getWidth(), view.getHeight(), colorType, alphaType, colorSpace));
        this.mContext = context;
        this.mImageViewProxy = view;
    }

    @Nullable
    @SharedPtr
    public static GraniteImage copy(@RawPtr RecordingContext rc, @RawPtr ImageViewProxy srcView, @Nonnull ImageInfo srcInfo, @Nonnull Rect2ic subset, boolean budgeted, boolean mipmapped, boolean approxFit, @Nullable String label) {
        ImageDesc dstDesc;
        ImageViewProxy dst;
        assert (!mipmapped || !approxFit);
        if (srcView == null) {
            return null;
        }
        assert (new Rect2i(0, 0, srcInfo.width(), srcInfo.height()).contains(subset));
        int width = subset.width();
        int height = subset.height();
        if (approxFit) {
            width = ISurface.getApproxSize(width);
            height = ISurface.getApproxSize(height);
        }
        if ((dst = ImageViewProxy.make(rc, dstDesc = rc.getCaps().getImageDescForSampledCopy(srcView.getDesc(), width, height, 1, mipmapped ? 4 : 0), srcView.getOrigin(), srcView.getSwizzle(), budgeted, label)) == null) {
            return null;
        }
        @SharedPtr CopyImageTask copyTask = CopyImageTask.make(RefCnt.create(srcView), subset, RefCnt.create(dst), 0, 0, 0);
        if (copyTask == null) {
            RefCnt.move(dst);
            return null;
        }
        rc.addTask(copyTask);
        return new GraniteImage(rc, dst, srcInfo.colorType(), srcInfo.alphaType(), srcInfo.colorSpace());
    }

    @Override
    protected void deallocate() {
        this.mImageViewProxy = RefCnt.move(this.mImageViewProxy);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @RawPtr
    public ImageViewProxy getImageViewProxy() {
        return this.mImageViewProxy;
    }

    @Override
    public boolean isTextureBacked() {
        return true;
    }

    @Override
    public long getTextureSize() {
        return this.mImageViewProxy.getMemorySize();
    }

    public String toString() {
        return "GraniteImage{mContext=" + this.mContext + ", mImageViewProxy=" + this.mImageViewProxy + "}";
    }
}

