/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.Canvas;
import yslelf.cloudpick.render.core.Image;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.Surface;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.granite.GraniteDevice;
import yslelf.cloudpick.render.granite.GraniteImage;

public final class GraniteSurface
extends Surface {
    @SharedPtr
    private GraniteDevice mDevice;

    public GraniteSurface(@SharedPtr GraniteDevice device) {
        super(device.getWidth(), device.getHeight());
        this.mDevice = device;
    }

    @Nullable
    @SharedPtr
    static GraniteSurface make(RecordingContext rc, ImageInfo info, boolean budgeted, boolean mipmapped, boolean approxFit, int surfaceOrigin, byte initialLoadOp, String label, boolean trackDevice) {
        GraniteDevice device;
        int flags = 0;
        if (budgeted) {
            flags |= 1;
        }
        if (mipmapped) {
            flags |= 4;
        }
        if (approxFit) {
            flags |= 2;
        }
        if ((device = GraniteDevice.make(rc, info, flags, surfaceOrigin, initialLoadOp, label, trackDevice)) == null) {
            return null;
        }
        assert (budgeted || device.getReadView().isInstantiated());
        return new GraniteSurface(device);
    }

    @Nullable
    @SharedPtr
    public static GraniteSurface make(RecordingContext rc, ImageInfo info, boolean budgeted, boolean mipmapped, boolean approxFit, int surfaceOrigin, String label) {
        return GraniteSurface.make(rc, info, budgeted, mipmapped, approxFit, surfaceOrigin, (byte)1, label, true);
    }

    @Nullable
    @SharedPtr
    public static GraniteSurface makeRenderTarget(RecordingContext rc, @Nonnull ImageInfo info, boolean mipmapped, int surfaceOrigin, @Nullable String label) {
        if (label == null) {
            label = "SurfaceRenderTarget";
        }
        return GraniteSurface.make(rc, info, false, mipmapped, false, surfaceOrigin, label);
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.mDevice.setImmutable();
        this.mDevice = RefCnt.move(this.mDevice);
    }

    public void flush() {
        this.mDevice.flushPendingWork();
    }

    @Override
    @Nonnull
    public ImageInfo getImageInfo() {
        return this.mDevice.getImageInfo();
    }

    @Override
    protected Canvas onNewCanvas() {
        return new Canvas(RefCnt.create(this.mDevice));
    }

    @Override
    @Nullable
    protected Image onNewImageSnapshot(@Nullable Rect2ic subset) {
        return this.makeImageCopy(subset, this.mDevice.getReadView().isMipmapped());
    }

    @Override
    protected boolean onCopyOnWrite(int changeMode) {
        return true;
    }

    @Nullable
    @SharedPtr
    public GraniteImage makeImageCopy(@Nullable Rect2ic subset, boolean mipmapped) {
        assert (!this.hasCachedImage());
        if (subset == null) {
            subset = new Rect2i(0, 0, this.getWidth(), this.getHeight());
        }
        return this.mDevice.makeImageCopy(subset, false, mipmapped, false);
    }

    @Override
    protected RecordingContext onGetRecordingContext() {
        return this.mDevice.getRecordingContext();
    }
}

