/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.granite.PaintParams;

public class KeyContext {
    @RawPtr
    private final RecordingContext mRecordingContext;
    private final Caps mCaps;
    private final ImageInfo mTargetInfo;
    private float mR;
    private float mG;
    private float mB;
    private float mA;

    public KeyContext(@RawPtr RecordingContext recordingContext, ImageInfo targetInfo) {
        this.mRecordingContext = recordingContext;
        this.mCaps = recordingContext.getCaps();
        this.mTargetInfo = targetInfo;
    }

    public void reset(PaintParams paintParams) {
        ColorSpace dstCS = this.mTargetInfo.colorSpace();
        if (dstCS != null && !dstCS.isSrgb()) {
            float[] col = ColorSpace.connect(ColorSpace.get(ColorSpace.Named.SRGB), dstCS).transform(paintParams.r(), paintParams.g(), paintParams.b());
            this.mR = col[0];
            this.mG = col[1];
            this.mB = col[2];
        } else {
            this.mR = paintParams.r();
            this.mG = paintParams.g();
            this.mB = paintParams.b();
        }
        this.mA = paintParams.a();
    }

    @Nullable
    @RawPtr
    public RecordingContext getRecordingContext() {
        return this.mRecordingContext;
    }

    public Caps getCaps() {
        return this.mCaps;
    }

    public float r() {
        return this.mR;
    }

    public float g() {
        return this.mG;
    }

    public float b() {
        return this.mB;
    }

    public float a() {
        return this.mA;
    }

    public ImageInfo targetInfo() {
        return this.mTargetInfo;
    }
}

