/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.Blender;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.effects.ColorFilter;
import yslelf.cloudpick.render.core.shaders.Shader;
import yslelf.cloudpick.render.engine.KeyBuilder;
import yslelf.cloudpick.render.granite.FragmentHelpers;
import yslelf.cloudpick.render.granite.KeyContext;
import yslelf.cloudpick.render.granite.TextureDataGatherer;
import yslelf.cloudpick.render.granite.UniformDataGatherer;

public final class PaintParams
implements AutoCloseable {
    private final float mR;
    private final float mG;
    private final float mB;
    private final float mA;
    @SharedPtr
    private final Blender mPrimitiveBlender;
    @SharedPtr
    private final Shader mShader;
    @SharedPtr
    private final ColorFilter mColorFilter;
    @SharedPtr
    private final Blender mFinalBlender;
    private final boolean mDither;

    public PaintParams(@Nonnull Paint paint, @Nullable @SharedPtr Blender primitiveBlender) {
        this.mR = paint.r();
        this.mG = paint.g();
        this.mB = paint.b();
        this.mA = paint.a();
        this.mPrimitiveBlender = primitiveBlender;
        this.mShader = paint.refShader();
        this.mColorFilter = paint.refColorFilter();
        this.mFinalBlender = paint.refBlender();
        this.mDither = paint.isDither();
    }

    @Override
    public void close() {
        RefCnt.move(this.mShader);
        RefCnt.move(this.mColorFilter);
        RefCnt.move(this.mFinalBlender);
        RefCnt.move(this.mPrimitiveBlender);
    }

    public float r() {
        return this.mR;
    }

    public float g() {
        return this.mG;
    }

    public float b() {
        return this.mB;
    }

    public float a() {
        return this.mA;
    }

    @RawPtr
    public Shader getShader() {
        return this.mShader;
    }

    @RawPtr
    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    @RawPtr
    public Blender getFinalBlender() {
        return this.mFinalBlender;
    }

    @RawPtr
    public Blender getPrimitiveBlender() {
        return this.mPrimitiveBlender;
    }

    @Nonnull
    public BlendMode getFinalBlendMode() {
        BlendMode blendMode = this.mFinalBlender != null ? this.mFinalBlender.asBlendMode() : BlendMode.SRC_OVER;
        return blendMode != null ? blendMode : BlendMode.SRC;
    }

    public static float[] prepareColorForDst(float[] color, ImageInfo dstInfo, boolean copyOnWrite) {
        ColorSpace dstCS = dstInfo.colorSpace();
        if (dstCS != null && !dstCS.isSrgb()) {
            float[] result = copyOnWrite ? Arrays.copyOfRange(color, 0, 4) : color;
            return ColorSpace.connect(ColorSpace.get(ColorSpace.Named.SRGB), dstCS).transform(result);
        }
        return color;
    }

    public boolean isSolidColor() {
        return this.getSolidColor(null, null);
    }

    public boolean getSolidColor(ImageInfo targetInfo, @Nullable float[] outColor) {
        if (this.mShader == null && this.mPrimitiveBlender == null) {
            if (outColor != null) {
                outColor[0] = this.mR;
                outColor[1] = this.mG;
                outColor[2] = this.mB;
                outColor[3] = this.mA;
                PaintParams.prepareColorForDst(outColor, targetInfo, false);
                int i = 0;
                while (i < 3) {
                    int n2 = i++;
                    outColor[n2] = outColor[n2] * outColor[3];
                }
                if (this.mColorFilter != null) {
                    this.mColorFilter.filterColor4f(outColor, outColor, targetInfo.colorSpace());
                }
            }
            return true;
        }
        return false;
    }

    public static boolean getSolidColor(Paint paint, ImageInfo targetInfo, float[] outColor) {
        if (paint.getShader() == null) {
            if (outColor != null) {
                outColor[0] = paint.r();
                outColor[1] = paint.g();
                outColor[2] = paint.b();
                outColor[3] = paint.a();
                PaintParams.prepareColorForDst(outColor, targetInfo, false);
                int i = 0;
                while (i < 3) {
                    int n2 = i++;
                    outColor[n2] = outColor[n2] * outColor[3];
                }
                ColorFilter colorFilter = paint.getColorFilter();
                if (colorFilter != null) {
                    colorFilter.filterColor4f(outColor, outColor, targetInfo.colorSpace());
                }
            }
            return true;
        }
        return false;
    }

    private boolean shouldDither(int dstCT) {
        if (!this.mDither) {
            return false;
        }
        if (dstCT == 0) {
            return false;
        }
        if (dstCT == 1) {
            return true;
        }
        return this.mShader != null && !this.mShader.isConstant();
    }

    private static float getDitherRange(int dstCT) {
        return switch (dstCT) {
            case 1 -> 0.032258064f;
            case 2, 3, 4, 5, 6, 7, 8, 19, 22, 23, 24, 25 -> 0.003921569f;
            case 9, 10 -> 9.775171E-4f;
            case 11, 13, 15, 20 -> 3.051851E-5f;
            case 0, 12, 14, 16, 17, 18, 21 -> 0.0f;
            default -> throw new AssertionError(dstCT);
        };
    }

    private void appendPaintColorToKey(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer) {
        if (this.mShader != null) {
            FragmentHelpers.appendToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, this.mShader);
        } else {
            FragmentHelpers.appendRGBOpaquePaintColorBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
        }
    }

    private void handlePrimitiveColor(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer) {
        if (this.mPrimitiveBlender != null) {
            keyBuilder.addInt(22);
            this.appendPaintColorToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
            FragmentHelpers.appendPrimitiveColorBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
            FragmentHelpers.appendToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, this.mPrimitiveBlender);
        } else {
            this.appendPaintColorToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
        }
    }

    private void handlePaintAlpha(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer) {
        if (this.mShader == null && this.mPrimitiveBlender == null) {
            FragmentHelpers.appendSolidColorShaderBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, this.mR * this.mA, this.mG * this.mA, this.mB * this.mA, this.mA);
            return;
        }
        if (this.mA != 1.0f) {
            keyBuilder.addInt(22);
            this.handlePrimitiveColor(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
            FragmentHelpers.appendAlphaOnlyPaintColorBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
            FragmentHelpers.appendFixedBlendMode(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, BlendMode.SRC_IN);
        } else {
            this.handlePrimitiveColor(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
        }
    }

    private void handleColorFilter(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer) {
        if (this.mColorFilter != null) {
            keyBuilder.addInt(26);
            this.handlePaintAlpha(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
            FragmentHelpers.appendToKey(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, this.mColorFilter);
        } else {
            this.handlePaintAlpha(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
        }
    }

    private void handleDithering(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer) {
        float ditherRange;
        int dstCT = keyContext.targetInfo().colorType();
        if (this.shouldDither(dstCT) && (ditherRange = PaintParams.getDitherRange(dstCT)) != 0.0f) {
            keyBuilder.addInt(26);
            this.handleColorFilter(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
            FragmentHelpers.appendDitherShaderBlock(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer, ditherRange);
            return;
        }
        this.handleColorFilter(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
    }

    public void appendToKey(KeyContext keyContext, KeyBuilder keyBuilder, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer) {
        this.handleDithering(keyContext, keyBuilder, uniformDataGatherer, textureDataGatherer);
    }
}

