/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import java.util.Formatter;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.SLDataType;
import yslelf.cloudpick.render.engine.BlendInfo;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.Device;
import yslelf.cloudpick.render.engine.PipelineDesc;
import yslelf.cloudpick.render.engine.ShaderVar;
import yslelf.cloudpick.render.engine.VertexInputLayout;
import yslelf.cloudpick.render.granite.BlendFormula;
import yslelf.cloudpick.render.granite.FragmentNode;
import yslelf.cloudpick.render.granite.GraphicsPipelineDesc;
import yslelf.cloudpick.render.granite.ShaderCodeSource;
import yslelf.cloudpick.render.granite.shading.UniformHandler;
import yslelf.cloudpick.render.granite.shading.VaryingHandler;

public class PipelineBuilder {
    public static final String WORLD_POS_VAR_NAME = "worldPos";
    public static final String LOCAL_COORDS_VARYING_NAME = "f_LocalCoords";
    public static final String PRIMITIVE_COLOR_VAR_NAME = "primitiveColor";
    public static final int MAIN_DRAW_BUFFER_INDEX = 0;
    public static final int PRIMARY_COLOR_OUTPUT_INDEX = 0;
    public static final int SECONDARY_COLOR_OUTPUT_INDEX = 1;
    public static final String PRIMARY_COLOR_OUTPUT_NAME = "FragColor0";
    public static final String SECONDARY_COLOR_OUTPUT_NAME = "FragColor1";
    private final Caps mCaps;
    private final GraphicsPipelineDesc mDesc;
    private final FragmentNode[] mRootNodes;
    private final VaryingHandler mVaryings;
    private final UniformHandler mGeometryUniforms;
    private final UniformHandler mFragmentUniforms;
    private BlendInfo mBlendInfo = BlendInfo.BLEND_DST;
    private StringBuilder mVertCode;
    private StringBuilder mFragCode;
    private final String mFragLabel;
    private int mGeometryBlockVisibility;
    private int mFragmentBlockVisibility;
    private int mSnippetRequirementFlags;

    public PipelineBuilder(Device device, GraphicsPipelineDesc desc) {
        this.mCaps = device.getCaps();
        this.mDesc = desc;
        StringBuilder label = new StringBuilder();
        this.mRootNodes = desc.getRootNodes(device.getShaderCodeSource(), label);
        this.mFragLabel = label.toString();
        for (FragmentNode root : this.mRootNodes) {
            this.mSnippetRequirementFlags |= root.requirementFlags();
        }
        this.mVaryings = new VaryingHandler(this.mCaps.shaderCaps());
        this.mGeometryUniforms = new UniformHandler(this.mCaps.shaderCaps(), 0);
        this.mFragmentUniforms = new UniformHandler(this.mCaps.shaderCaps(), 0);
    }

    private boolean needsLocalCoords() {
        return (this.mSnippetRequirementFlags & 1) != 0;
    }

    private void getNodeUniforms(FragmentNode node) {
        node.stage().generateUniforms(this.mFragmentUniforms, node.stageIndex());
        for (FragmentNode child : node.children()) {
            this.getNodeUniforms(child);
        }
    }

    public PipelineDesc.GraphicsPipelineInfo build() {
        this.mDesc.geomStep().emitVaryings(this.mVaryings, this.mDesc.usesFastSolidColor());
        if (this.needsLocalCoords()) {
            this.mVaryings.addVarying(LOCAL_COORDS_VARYING_NAME, (byte)14);
        }
        this.mVaryings.finish();
        this.mGeometryUniforms.addUniform(1, (byte)16, "SV_Projection", -1);
        this.mDesc.geomStep().emitUniforms(this.mGeometryUniforms, this.mDesc.mayRequireLocalCoords());
        this.mDesc.geomStep().emitSamplers(this.mFragmentUniforms);
        for (FragmentNode root : this.mRootNodes) {
            this.getNodeUniforms(root);
        }
        this.buildFragmentShader();
        this.buildVertexShader();
        PipelineDesc.GraphicsPipelineInfo info = new PipelineDesc.GraphicsPipelineInfo();
        info.mPrimitiveType = this.mDesc.getPrimitiveType();
        info.mInputLayout = this.mDesc.geomStep().getInputLayout();
        info.mInputLayoutLabel = this.mDesc.geomStep().name();
        info.mVertSource = this.mVertCode;
        info.mFragSource = this.mFragCode;
        info.mVertLabel = this.mDesc.geomStep().name();
        if (this.needsLocalCoords()) {
            info.mVertLabel = info.mVertLabel + " (w/ local coords)";
        }
        info.mFragLabel = this.mFragLabel;
        info.mBlendInfo = this.mBlendInfo;
        info.mDepthStencilSettings = this.mDesc.getDepthStencilSettings();
        info.mUniformBlockInfos = new PipelineDesc.UniformBlockInfo[2];
        info.mUniformBlockInfos[0] = new PipelineDesc.UniformBlockInfo(this.mGeometryBlockVisibility, 0, "GeometryUniforms");
        info.mUniformBlockInfos[1] = new PipelineDesc.UniformBlockInfo(this.mFragmentBlockVisibility, 1, "FragmentUniforms");
        info.mSamplerInfos = new PipelineDesc.SamplerInfo[this.mFragmentUniforms.numSamplers()];
        for (int i = 0; i < info.mSamplerInfos.length; ++i) {
            info.mSamplerInfos[i] = new PipelineDesc.SamplerInfo(4, i, this.mFragmentUniforms.samplerVariable(i));
        }
        info.mPipelineLabel = info.mVertLabel + " + ";
        info.mPipelineLabel = info.mFragLabel.isEmpty() ? info.mPipelineLabel + (this.mDesc.usesFastSolidColor() ? "(simple)" : "(empty)") : info.mPipelineLabel + info.mFragLabel;
        return info;
    }

    public void buildVertexShader() {
        StringBuilder out = new StringBuilder();
        out.append(this.mCaps.shaderCaps().mGLSLVersion.mVersionDecl);
        if (this.mCaps.shaderCaps().mUsePrecisionModifiers) {
            out.append("precision highp float;\n");
            out.append("precision highp sampler2D;\n");
        }
        Formatter vs = new Formatter(out, Locale.ROOT);
        if (this.mGeometryUniforms.appendUniformDecls(1, 0, "GeometryUniforms", out)) {
            this.mGeometryBlockVisibility |= 1;
        } else assert (false);
        VertexInputLayout inputLayout = this.mDesc.geomStep().getInputLayout();
        int locationIndex = 0;
        for (int i = 0; i < inputLayout.getBindingCount(); ++i) {
            Iterator<VertexInputLayout.Attribute> attrs = inputLayout.getAttributes(i);
            while (attrs.hasNext()) {
                VertexInputLayout.Attribute attr2 = attrs.next();
                ShaderVar var = attr2.asShaderVar();
                assert (var.getTypeModifier() == 2);
                var.addLayoutQualifier("location", locationIndex);
                int locations = SLDataType.locations(var.getType());
                assert (locations > 0);
                assert (!var.isArray());
                locationIndex += locations;
                var.appendDecl(out);
                out.append(";\n");
            }
        }
        this.mVaryings.getVertDecls(out);
        out.append("void main() {\n");
        this.mDesc.geomStep().emitVertexGeomCode(vs, WORLD_POS_VAR_NAME, this.needsLocalCoords() ? LOCAL_COORDS_VARYING_NAME : null, this.mDesc.usesFastSolidColor());
        if (this.mCaps.depthClipNegativeOneToOne()) {
            vs.format("gl_Position = vec4(%1$s.xy * %2$s.xz + %1$s.ww * %2$s.yw, (%1$s.z * 2.0 - 1.0) * %1$s.w, %1$s.w);\n", WORLD_POS_VAR_NAME, "SV_Projection");
        } else {
            vs.format("gl_Position = vec4(%1$s.xy * %2$s.xz + %1$s.ww * %2$s.yw, %1$s.z * %1$s.w, %1$s.w);\n", WORLD_POS_VAR_NAME, "SV_Projection");
        }
        out.append("}");
        this.mVertCode = out;
    }

    public void buildFragmentShader() {
        String outputColor;
        StringBuilder out = new StringBuilder();
        if (this.mDesc.isDepthOnlyPass()) {
            this.mFragCode = out;
            return;
        }
        BlendMode blendMode = this.mDesc.getFinalBlendMode();
        assert (blendMode != null);
        BlendFormula coverageBlendFormula = null;
        if (this.mDesc.geomStep().emitsCoverage() && (coverageBlendFormula = BlendFormula.getBlendFormula(false, true, blendMode)) == null) {
            coverageBlendFormula = BlendFormula.getBlendFormula(false, true, BlendMode.SRC_OVER);
            assert (coverageBlendFormula != null);
        }
        out.append(this.mCaps.shaderCaps().mGLSLVersion.mVersionDecl);
        if (this.mCaps.shaderCaps().mUsePrecisionModifiers) {
            out.append("precision highp float;\n");
            out.append("precision highp sampler2D;\n");
        }
        Formatter fs = new Formatter(out, Locale.ROOT);
        assert (!this.mDesc.geomStep().emitsCoverage() || this.mDesc.geomStep().performsShading());
        if (this.mGeometryUniforms.appendUniformDecls(4, 0, "GeometryUniforms", out)) {
            this.mGeometryBlockVisibility |= 4;
        }
        if (this.mFragmentUniforms.appendUniformDecls(4, 1, "FragmentUniforms", out)) {
            this.mFragmentBlockVisibility |= 4;
        }
        this.mFragmentUniforms.appendSamplerDecls(4, out);
        this.mVaryings.getFragDecls(out);
        String layoutQualifier = "location=0";
        ShaderVar primaryOutput = new ShaderVar(PRIMARY_COLOR_OUTPUT_NAME, 16, 1, 0, layoutQualifier, "");
        ShaderVar secondaryOutput = null;
        if (coverageBlendFormula != null && coverageBlendFormula.hasSecondaryOutput()) {
            secondaryOutput = new ShaderVar(SECONDARY_COLOR_OUTPUT_NAME, 16, 1, 0, layoutQualifier, "");
            primaryOutput.addLayoutQualifier("index", 0);
            secondaryOutput.addLayoutQualifier("index", 1);
        }
        primaryOutput.appendDecl(out);
        out.append(";\n");
        if (secondaryOutput != null) {
            secondaryOutput.appendDecl(out);
            out.append(";\n");
        }
        ShaderCodeSource.emitDefinitions(this.mRootNodes, new IdentityHashMap<String, String>(), fs);
        out.append("void main() {\n");
        if (this.mDesc.usesFastSolidColor()) {
            out.append("vec4 initialColor;\n");
            this.mDesc.geomStep().emitFragmentColorCode(fs, "initialColor");
            outputColor = "initialColor";
        } else {
            if (this.mDesc.geomStep().emitsPrimitiveColor()) {
                fs.format("vec4 %s;\n", PRIMITIVE_COLOR_VAR_NAME);
                this.mDesc.geomStep().emitFragmentColorCode(fs, PRIMITIVE_COLOR_VAR_NAME);
            }
            outputColor = "vec4(0)";
        }
        String localCoords = this.needsLocalCoords() ? LOCAL_COORDS_VARYING_NAME : "vec2(0)";
        for (FragmentNode root : this.mRootNodes) {
            outputColor = ShaderCodeSource.invoke_node(root, localCoords, outputColor, "vec4(1)", fs);
        }
        if (this.mDesc.geomStep().emitsCoverage()) {
            out.append("vec4 outputCoverage;\n");
            this.mDesc.geomStep().emitFragmentCoverageCode(fs, "outputCoverage");
            assert (coverageBlendFormula != null);
            this.mBlendInfo = new BlendInfo(coverageBlendFormula.mEquation, coverageBlendFormula.mSrcFactor, coverageBlendFormula.mDstFactor, coverageBlendFormula.modifiesDst());
            PipelineBuilder.appendColorOutput(fs, coverageBlendFormula.mPrimaryOutput, PRIMARY_COLOR_OUTPUT_NAME, outputColor, "outputCoverage");
            if (coverageBlendFormula.hasSecondaryOutput()) {
                PipelineBuilder.appendColorOutput(fs, coverageBlendFormula.mSecondaryOutput, SECONDARY_COLOR_OUTPUT_NAME, outputColor, "outputCoverage");
            }
        } else {
            this.mDesc.geomStep().emitFragmentCoverageCode(fs, null);
            fs.format("%s = %s;\n", PRIMARY_COLOR_OUTPUT_NAME, outputColor);
            this.mBlendInfo = BlendInfo.getSimpleBlendInfo(blendMode);
            if (this.mBlendInfo == null) {
                this.mBlendInfo = BlendInfo.getSimpleBlendInfo(BlendMode.SRC_OVER);
                assert (this.mBlendInfo != null);
            }
        }
        out.append("}");
        this.mFragCode = out;
    }

    private static void appendColorOutput(Formatter fs, byte outputType, String output, String inColor, String inCoverage) {
        switch (outputType) {
            case 0: {
                fs.format("%s = vec4(0.0);\n", output);
                break;
            }
            case 1: {
                fs.format("%s = %s;\n", output, inCoverage);
                break;
            }
            case 2: {
                fs.format("%s = %s * %s;\n", output, inColor, inCoverage);
                break;
            }
            case 3: {
                fs.format("%s = %s.a * %s;\n", output, inColor, inCoverage);
                break;
            }
            case 4: {
                fs.format("%s = (1.0 - %s.a) * %s;\n", output, inColor, inCoverage);
                break;
            }
            case 5: {
                fs.format("%s = (1.0 - %s) * %s;\n", output, inColor, inCoverage);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unsupported output type.");
            }
        }
    }
}

