/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import java.util.Arrays;
import java.util.Objects;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.CommandBuffer;
import yslelf.cloudpick.render.engine.FramebufferDesc;
import yslelf.cloudpick.render.engine.Image;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.RenderPassDesc;
import yslelf.cloudpick.render.engine.ResourceProvider;
import yslelf.cloudpick.render.engine.task.Task;
import yslelf.cloudpick.render.granite.DrawPass;

public final class RenderPassTask
extends Task {
    DrawPass mDrawPass;
    RenderPassDesc mRenderPassDesc;
    @SharedPtr
    ImageViewProxy mColorTarget;
    @SharedPtr
    ImageViewProxy mResolveTarget;
    float[] mClearColor;

    private RenderPassTask(DrawPass drawPass, RenderPassDesc renderPassDesc, @SharedPtr ImageViewProxy colorTarget, @SharedPtr ImageViewProxy resolveTarget, float[] clearColor) {
        this.mDrawPass = drawPass;
        this.mRenderPassDesc = renderPassDesc;
        this.mColorTarget = colorTarget;
        this.mResolveTarget = resolveTarget;
        this.mClearColor = clearColor;
    }

    @SharedPtr
    public static RenderPassTask make(RecordingContext context, DrawPass drawPass, @SharedPtr ImageViewProxy colorTarget, @SharedPtr ImageViewProxy resolveTarget, byte loadOp, byte storeOp, float[] clearColor) {
        Objects.requireNonNull(drawPass);
        Objects.requireNonNull(colorTarget);
        assert (clearColor.length >= 4);
        RenderPassDesc renderPassDesc = new RenderPassDesc();
        renderPassDesc.mNumColorAttachments = 1;
        RenderPassDesc.ColorAttachmentDesc colorDesc = renderPassDesc.mColorAttachments[0] = new RenderPassDesc.ColorAttachmentDesc();
        colorDesc.mDesc = colorTarget.getDesc();
        colorDesc.mLoadOp = loadOp;
        colorDesc.mStoreOp = storeOp;
        int depthStencilFlags = drawPass.getDepthStencilFlags();
        if (depthStencilFlags != 0) {
            int depthBits = (depthStencilFlags & 1) != 0 ? 16 : 0;
            int stencilBits = (depthStencilFlags & 2) != 0 ? 8 : 0;
            RenderPassDesc.DepthStencilAttachmentDesc depthStencilAttachment = renderPassDesc.mDepthStencilAttachment;
            depthStencilAttachment.mDesc = context.getCaps().getDefaultDepthStencilImageDesc(depthBits, stencilBits, colorTarget.getWidth(), colorTarget.getHeight(), colorTarget.getSampleCount(), 96);
            assert (depthStencilAttachment.mDesc != null);
            depthStencilAttachment.mLoadOp = 1;
            depthStencilAttachment.mStoreOp = 1;
        }
        return new RenderPassTask(drawPass, renderPassDesc, colorTarget, resolveTarget, Arrays.copyOf(clearColor, 4));
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.mDrawPass.close();
        this.mDrawPass = null;
        this.mColorTarget = RefCnt.move(this.mColorTarget);
        this.mResolveTarget = RefCnt.move(this.mResolveTarget);
    }

    @Override
    public int prepare(RecordingContext context) {
        ResourceProvider resourceProvider = context.getResourceProvider();
        if (!this.mColorTarget.instantiateIfNonLazy(resourceProvider)) {
            return 1;
        }
        if (this.mResolveTarget != null && !this.mResolveTarget.instantiateIfNonLazy(resourceProvider)) {
            return 1;
        }
        if (!this.mDrawPass.prepare(resourceProvider, this.mRenderPassDesc)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int execute(ImmediateContext context, CommandBuffer commandBuffer) {
        assert (this.mColorTarget.isInstantiated());
        assert (this.mResolveTarget == null || this.mResolveTarget.isInstantiated());
        Image colorAttachment = this.mColorTarget.getImage();
        Image depthStencilAttachment = null;
        if (this.mRenderPassDesc.mDepthStencilAttachment.mDesc != null && (depthStencilAttachment = context.getResourceProvider().findOrCreateImage(this.mRenderPassDesc.mDepthStencilAttachment.mDesc, true, "SharedDSAttachment")) == null) {
            return 1;
        }
        colorAttachment.ref();
        Image resolveAttachment = this.mResolveTarget != null ? this.mResolveTarget.refImage() : null;
        FramebufferDesc framebufferDesc = new FramebufferDesc(colorAttachment.getWidth(), colorAttachment.getHeight(), colorAttachment.getSampleCount(), new FramebufferDesc.ColorAttachmentDesc(colorAttachment, resolveAttachment, 0, 0), new FramebufferDesc.DepthStencilAttachmentDesc(depthStencilAttachment));
        if (commandBuffer.beginRenderPass(this.mRenderPassDesc, framebufferDesc, this.mDrawPass.getBounds(), this.mClearColor, 0.0f, 0)) {
            commandBuffer.setViewport(0, 0, framebufferDesc.mWidth, framebufferDesc.mHeight);
            boolean success = this.mDrawPass.execute(commandBuffer);
            commandBuffer.endRenderPass();
            if (success) {
                commandBuffer.trackCommandBufferResource(colorAttachment);
                commandBuffer.trackCommandBufferResource(resolveAttachment);
                commandBuffer.trackCommandBufferResource(depthStencilAttachment);
                return 0;
            }
        }
        RefCnt.move(colorAttachment);
        RefCnt.move(resolveAttachment);
        RefCnt.move(depthStencilAttachment);
        return 1;
    }
}

