/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.granite.GeometryRenderer;
import yslelf.cloudpick.render.granite.GeometryStep;
import yslelf.cloudpick.render.granite.StaticBufferManager;
import yslelf.cloudpick.render.granite.geom.AnalyticArcStep;
import yslelf.cloudpick.render.granite.geom.AnalyticSimpleBoxStep;
import yslelf.cloudpick.render.granite.geom.RasterTextStep;
import yslelf.cloudpick.render.granite.geom.VerticesStep;

public class RendererProvider {
    private final GeometryRenderer[] mSimpleBox = new GeometryRenderer[2];
    private final GeometryRenderer[] mRasterText = new GeometryRenderer[3];
    private final GeometryRenderer[] mArc = new GeometryRenderer[5];
    private final GeometryRenderer[] mVertices = new GeometryRenderer[20];

    private static GeometryRenderer makeSingleStep(GeometryStep singleStep) {
        String name = "SingleStep[" + singleStep.name() + "]";
        return new GeometryRenderer(name, singleStep);
    }

    public RendererProvider(Caps caps, StaticBufferManager staticBufferManager) {
        int i;
        this.mSimpleBox[0] = RendererProvider.makeSingleStep(new AnalyticSimpleBoxStep(false));
        this.mSimpleBox[1] = RendererProvider.makeSingleStep(new AnalyticSimpleBoxStep(true));
        for (i = 0; i < 3; ++i) {
            if (i == 1) continue;
            this.mRasterText[i] = RendererProvider.makeSingleStep(new RasterTextStep(i));
        }
        for (i = 0; i < 5; ++i) {
            this.mArc[i] = RendererProvider.makeSingleStep(new AnalyticArcStep(i));
        }
        for (int mode = 0; mode < 5; ++mode) {
            for (int mask = 0; mask < 4; ++mask) {
                int index = mode * 4 + mask;
                this.mVertices[index] = RendererProvider.makeSingleStep(new VerticesStep(switch (mode) {
                    case 0 -> 0;
                    case 1 -> 1;
                    case 2 -> 2;
                    case 3 -> 3;
                    case 4 -> 4;
                    default -> throw new AssertionError();
                }, (mask & 2) != 0, (mask & 1) != 0));
            }
        }
    }

    public GeometryRenderer getSimpleBox(boolean aa) {
        return this.mSimpleBox[aa ? 1 : 0];
    }

    public GeometryRenderer getRasterText(int maskFormat) {
        return this.mRasterText[maskFormat];
    }

    public GeometryRenderer getArc(int type) {
        return this.mArc[type];
    }

    public GeometryRenderer getVertices(int vertexMode, boolean hasColor, boolean hasTexCoords) {
        return this.mVertices[vertexMode * 4 + (hasColor ? 2 : 0) + (hasTexCoords ? 1 : 0)];
    }
}

