/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.CommandBuffer;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.Resource;
import yslelf.cloudpick.render.engine.task.Task;
import yslelf.cloudpick.render.engine.task.TaskList;

public class RootTask
extends Task {
    private final TaskList mRootTaskList;
    private final ObjectArrayList<@SharedPtr Resource> mExtraResourceRefs;

    public RootTask(TaskList rootTaskList, ObjectArrayList<@SharedPtr Resource> extraResourceRefs) {
        this.mRootTaskList = rootTaskList;
        this.mExtraResourceRefs = extraResourceRefs;
    }

    @Override
    public int prepare(RecordingContext context) {
        return 0;
    }

    @Override
    public int execute(ImmediateContext context, CommandBuffer commandBuffer) {
        for (Resource resource : this.mExtraResourceRefs) {
            commandBuffer.trackResource(RefCnt.create(resource));
        }
        return this.mRootTaskList.execute(context, commandBuffer);
    }

    @Override
    protected void deallocate() {
        this.mRootTaskList.close();
        this.mExtraResourceRefs.forEach(Resource::unref);
        this.mExtraResourceRefs.clear();
    }

    public String toString() {
        return "RootTask{mRootTaskList=" + this.mRootTaskList + ", mExtraResourceRefs=" + this.mExtraResourceRefs + "}";
    }
}

