/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import yslelf.cloudpick.render.core.Point;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.RoundRect;

public class SimpleShape
extends RoundRect {
    public static final int kLine_Type = 6;
    public static final int kLineRound_Type = 7;

    public SimpleShape() {
    }

    public SimpleShape(RoundRect other) {
        super(other);
    }

    public SimpleShape(Rect2fc other) {
        super(other);
    }

    public void setLine(float x0, float y0, float x1, float y1, float radius, boolean round) {
        this.mLeft = x0;
        this.mTop = y0;
        this.mRight = x1;
        this.mBottom = y1;
        this.mRadii[0] = radius;
        this.mRadii[1] = radius;
        this.mType = round ? 7 : 6;
    }

    public void setLine(float x0, float y0, float x1, float y1, int cap, float width) {
        float radius = width * 0.5f;
        if (cap != 0) {
            float newY;
            double x = x1 - x0;
            double y = y1 - y0;
            double dmag = Math.sqrt(x * x + y * y);
            double dscale = 1.0 / dmag;
            float newX = (float)(x * dscale);
            if (Point.isDegenerate(newX, newY = (float)(y * dscale))) {
                this.setEmpty();
                return;
            }
            x1 += newX * radius;
            y1 += newY * radius;
            x0 -= newX * radius;
            y0 -= newY * radius;
        }
        this.setLine(x0, y0, x1, y1, radius, cap == 1);
    }

    @Override
    public void getBounds(Rect2f dest) {
        super.getBounds(dest);
        if (this.mType == 6 || this.mType == 7) {
            dest.sort();
            float outset = this.getSimpleRadiusX();
            dest.outset(outset, outset);
        }
    }
}

