/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.BufferViewInfo;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.QueueManager;
import yslelf.cloudpick.render.engine.Resource;
import yslelf.cloudpick.render.engine.ResourceProvider;
import yslelf.cloudpick.render.engine.SharedResourceCache;
import yslelf.cloudpick.render.engine.UploadBufferManager;
import yslelf.cloudpick.render.engine.task.CopyBufferTask;

public class StaticBufferManager {
    private ResourceProvider mResourceProvider;
    private UploadBufferManager mUploadManager;
    private BlockBuffer mVertexBuffer;
    private BlockBuffer mIndexBuffer;
    private boolean mMappingFailed = false;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE = 1;
    public static final int RESULT_NO_WORK = 2;

    public StaticBufferManager(ResourceProvider resourceProvider, Caps caps) {
        this.mResourceProvider = resourceProvider;
        this.mUploadManager = new UploadBufferManager(resourceProvider);
        this.mVertexBuffer = new BlockBuffer(caps, 65537);
        this.mIndexBuffer = new BlockBuffer(caps, 65538);
    }

    public long getVertexWriter(long requiredBytes, BufferViewInfo outInfo) {
        return this.prepareUploadBuffer(this.mVertexBuffer, requiredBytes, outInfo);
    }

    public long getIndexWriter(long requiredBytes, BufferViewInfo outInfo) {
        return this.prepareUploadBuffer(this.mIndexBuffer, requiredBytes, outInfo);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public int flush(QueueManager queueManager, SharedResourceCache sharedResourceCache) {
        if (this.mMappingFailed) {
            return 1;
        }
        long totalRequiredBytes = this.mVertexBuffer.mTotalRequiredBytes + this.mIndexBuffer.mTotalRequiredBytes;
        if (totalRequiredBytes == 0L) {
            return 2;
        }
        if (!this.mVertexBuffer.allocateAndSetBindings(this.mResourceProvider, queueManager, sharedResourceCache, "StaticVertexBuffer")) {
            return 1;
        }
        if (!this.mIndexBuffer.allocateAndSetBindings(this.mResourceProvider, queueManager, sharedResourceCache, "StaticIndexBuffer")) {
            return 1;
        }
        @SharedPtr ObjectArrayList resourceRefs = new ObjectArrayList();
        this.mUploadManager.flush((List<Resource>)resourceRefs);
        resourceRefs.forEach(Resource::unref);
        resourceRefs.clear();
        return 0;
    }

    private long prepareUploadBuffer(BlockBuffer target, long requiredBytes, BufferViewInfo outInfo) {
        BufferViewInfo srcInfo;
        assert (outInfo != null);
        outInfo.mBuffer = null;
        outInfo.mOffset = 0L;
        outInfo.mSize = 0L;
        if (requiredBytes == 0L || this.mMappingFailed) {
            return 0L;
        }
        long mappedPtr = this.mUploadManager.getUploadPointer(requiredBytes = MathUtil.alignTo(requiredBytes, (long)target.mOffsetAlignment), 4L, srcInfo = new BufferViewInfo());
        if (mappedPtr == 0L) {
            this.mMappingFailed = true;
            return 0L;
        }
        assert (requiredBytes == srcInfo.mSize);
        outInfo.mSize = requiredBytes;
        target.mData.add((Object)new CopyData(srcInfo, outInfo));
        target.mTotalRequiredBytes += requiredBytes;
        return mappedPtr;
    }

    private static class BlockBuffer {
        final int mUsage;
        final int mOffsetAlignment;
        final ObjectArrayList<CopyData> mData = new ObjectArrayList();
        long mTotalRequiredBytes;

        BlockBuffer(Caps caps, int usage) {
            this.mUsage = usage;
            this.mOffsetAlignment = (usage & 0x20) != 0 ? caps.minUniformBufferOffsetAlignment() : 4;
        }

        boolean allocateAndSetBindings(ResourceProvider resourceProvider, QueueManager queueManager, SharedResourceCache sharedResourceCache, String label) {
            if (this.mTotalRequiredBytes == 0L) {
                return true;
            }
            @SharedPtr Buffer buffer = resourceProvider.findOrCreateBuffer(this.mTotalRequiredBytes, this.mUsage, label);
            if (buffer == null) {
                return false;
            }
            long offset = 0L;
            for (CopyData data : this.mData) {
                assert (offset % (long)this.mOffsetAlignment == 0L);
                data.mTarget.mBuffer = buffer;
                data.mTarget.mOffset = offset;
                assert (data.mSource.mSize == data.mTarget.mSize);
                CopyBufferTask copyTask = CopyBufferTask.make(RefCnt.create(data.mSource.mBuffer), RefCnt.create(data.mTarget.mBuffer), data.mSource.mOffset, data.mTarget.mOffset, data.mSource.mSize);
                if (!queueManager.addTask(copyTask)) {
                    copyTask.unref();
                    buffer.unref();
                    return false;
                }
                copyTask.unref();
                offset += data.mSource.mSize;
            }
            assert (offset == this.mTotalRequiredBytes);
            sharedResourceCache.addStaticResource(buffer);
            return true;
        }
    }

    private static class CopyData {
        BufferViewInfo mSource;
        BufferViewInfo mTarget;

        CopyData(BufferViewInfo source, BufferViewInfo target) {
            this.mSource = source;
            this.mTarget = target;
        }
    }
}

